/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class UIComponent {
    int m_level = 0;
    String m_id;
    UIComponent m_parent;
    List<UIComponent> m_children = new ComponentList();
    boolean m_rendersChildren = false;
    AttributeMap m_attributes = new AttributeMap();
    boolean m_listModeRemoveDoesNotDestroy = false;
    Object m_rendered;

    public List<UIComponent> getChildren() {
        return this.m_children;
    }

    public int getChildCount() {
        return this.m_children.size();
    }

    public UIComponent getChild(int i) {
        return this.m_children.get(i);
    }

    public Iterator<UIComponent> getFacetsAndChildren() {
        return this.m_children.iterator();
    }

    public void addChild(UIComponent child) {
        this.m_children.add(child);
        child.setParent(this);
        child.m_level = this.m_level + 1;
    }

    public String getId() {
        if (this.m_id == null) {
            this.m_id = UniqueIdCreator.createUUID();
        }
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public String getClientId(FacesContext context) {
        return this.getId();
    }

    public UIComponent getParent() {
        return this.m_parent;
    }

    public void setParent(UIComponent parent) {
        this.m_parent = parent;
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public Map<String, Object> getAttributes() {
        return this.m_attributes;
    }

    public boolean isRendered() {
        Object result = this.m_attributes.get("rendered");
        if (result == null) {
            return true;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            return ValueManager.decodeBoolean((String)((String)result), (boolean)true);
        }
        return true;
    }

    public void setRendered(boolean value) {
        this.m_attributes.put(ICCComponentProperties.ATT_RENDERED, (Object)("" + value));
    }

    public ValueBinding getValueBinding(String name) {
        throw new Error("JSF 1.1 is not supported anymore.");
    }

    public ValueExpression getValueExpression(String name) {
        return this.m_attributes.getExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        this.m_attributes.put(name, (Object)binding);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new Error("No context passed");
        }
        if (!this.isRendered()) {
            return;
        }
        for (UIComponent child : this.m_children) {
            child.processDecodes(context);
        }
        this.decode(context);
    }

    public void queueEvent(FacesEvent event) {
        FacesContext fc = FacesContext.getCurrentInstance();
        fc.queueEvent(event);
    }

    public void processEncodeOfComponentTree(HttpServletResponse response, FacesContext context) {
        boolean riscClient = HttpSessionAccess.checkIfCurrentClientTypeIsRisc();
        if (riscClient) {
            try {
                response.getWriter().write("<page>\n");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.processEncodes(context);
            try {
                response.getWriter().write("</page>\n");
            }
            catch (Throwable throwable) {}
        } else {
            String sessionId = HttpSessionAccess.getCurrentHttpSession().getId();
            HttpServletRequest request = HttpSessionAccess.getCurrentRequest();
            String requestUrl = HttpSessionAccess.getCurrentRequest().getRequestURI().toString();
            try {
                int index = requestUrl.indexOf(";jsessionid");
                if (index >= 0) {
                    requestUrl = requestUrl.substring(0, index);
                }
                requestUrl = ServletUtil.encodeURL((String)requestUrl, (HttpServletRequest)request, (HttpServletResponse)response);
                if (!TypeOfSessionMgmt.getSessionMgmtViaCookie() && requestUrl.indexOf(";jsessionid=") < 0) {
                    requestUrl = requestUrl + ";jessionid=" + sessionId;
                }
                response.getWriter().write("<form id=\"ccForm\" name=\"ccForm\" action=\"" + requestUrl + "\">\n");
                response.getWriter().write("<input name=\"ccForm\" value=\"ccForm\"/>\n");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.processEncodes(context);
            try {
                response.getWriter().write("</form>\n");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void processEncodes(FacesContext context) {
        try {
            if (context == null) {
                throw new Error("No context passed");
            }
            if (!this.isRendered()) {
                return;
            }
            this.encodeBegin(context);
            if (!this.getRendersChildren()) {
                for (UIComponent child : this.getChildren()) {
                    child.processEncodes(context);
                }
            } else if (this.getChildCount() > 0) {
                this.encodeChildren(context);
            }
            this.encodeEnd(context);
        }
        catch (Throwable t) {
            throw new Error("Problem occurred during request processEncodes", t);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
    }

    public void encodeEnd(FacesContext context) throws IOException {
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new Error("No context passed");
        }
        if (!this.isRendered()) {
            return;
        }
        for (UIComponent child : this.getChildren()) {
            child.processUpdates(context);
        }
    }

    public boolean getRendersChildren() {
        return this.m_rendersChildren;
    }

    public void setRendersChildren(boolean rendersChildren) {
        this.m_rendersChildren = rendersChildren;
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void processValidators(FacesContext context) {
    }

    public Object saveState(FacesContext context) {
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
    }

    public void decode(FacesContext context) {
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        this.dump(sb);
        return sb.toString();
    }

    private void executeInModeRemoveDoesNotDestroy(Runnable r) {
        try {
            this.m_listModeRemoveDoesNotDestroy = true;
            r.run();
        }
        finally {
            this.m_listModeRemoveDoesNotDestroy = false;
        }
    }

    private void dump(StringBuffer sb) {
        for (int i = 0; i < this.m_level; ++i) {
            sb.append("    ");
        }
        sb.append(this.getClass().getSimpleName());
        sb.append("\n");
        for (UIComponent child : this.m_children) {
            child.dump(sb);
        }
    }

    public class AttributeMap
    extends HashMap<String, Object> {
        private AttributeMap() {
            super(5);
        }

        @Override
        public Object get(Object key) {
            Object result = null;
            result = ICCComponentProperties.ATT_RENDERED.equals(key) ? UIComponent.this.m_rendered : super.get(key);
            if (result instanceof ValueExpression) {
                return ((ValueExpression)result).getValue(FacesContext.getCurrentInstance().getELContext());
            }
            return result;
        }

        @Override
        public Object put(String key, Object value) {
            if (ICCComponentProperties.ATT_RENDERED.equals(key)) {
                Object result = UIComponent.this.m_rendered;
                UIComponent.this.m_rendered = value;
                return result;
            }
            return super.put(key, value);
        }

        public ValueExpression getExpression(Object key) {
            Object result = null;
            result = ICCComponentProperties.ATT_RENDERED.equals(key) ? UIComponent.this.m_rendered : super.get(key);
            if (result instanceof ValueExpression) {
                return (ValueExpression)result;
            }
            return null;
        }
    }

    public class ComponentList
    extends ArrayList<UIComponent> {
        private ComponentList() {
            super(5);
        }

        @Override
        public boolean add(final UIComponent child) {
            if (child.getParent() != null) {
                child.getParent().executeInModeRemoveDoesNotDestroy(new Runnable(){

                    @Override
                    public void run() {
                        child.getParent().getChildren().remove(child);
                    }
                });
            }
            child.setParent(UIComponent.this);
            child.m_level = UIComponent.this.m_level + 1;
            return super.add(child);
        }

        @Override
        public void add(int index, final UIComponent child) {
            if (child.getParent() != null) {
                child.getParent().executeInModeRemoveDoesNotDestroy(new Runnable(){

                    @Override
                    public void run() {
                        child.getParent().getChildren().remove(child);
                    }
                });
            }
            child.setParent(UIComponent.this);
            child.m_level = UIComponent.this.m_level + 1;
            super.add(index, child);
        }

        @Override
        public UIComponent remove(int index) {
            UIComponent child = (UIComponent)this.get(index);
            if (!UIComponent.this.m_listModeRemoveDoesNotDestroy) {
                child.setParent(null);
            }
            return (UIComponent)super.remove(index);
        }

        @Override
        public boolean remove(Object child) {
            if (!UIComponent.this.m_listModeRemoveDoesNotDestroy) {
                ((UIComponent)child).setParent(null);
            }
            return super.remove(child);
        }

        @Override
        public void clear() {
            for (UIComponent child : UIComponent.this.m_children) {
                child.setParent(null);
            }
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends UIComponent> c) {
            throw new Error("Not implemented!");
        }

        @Override
        public boolean addAll(int index, Collection<? extends UIComponent> c) {
            throw new Error("Not implemented!");
        }
    }
}

