package org.eclnt.ccaddons.pbc.demos;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.TimeZone;

import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.pagebean.PageBean;

@CCGenClass (expressionBase="#{d.TouchDateDemo1UI}")

public class TouchDateDemo1UI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------

    Date m_utilDate = new Date();
    LocalDate m_localDate = LocalDate.now();
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public TouchDateDemo1UI()
    {
    }

    public String getPageName() { return "/org/eclnt/ccaddons/pbc/demos/TouchDateDemo1.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.TouchDateDemo1UI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public LocalDate getLocalDate() { return m_localDate; }
    public void setLocalDate(LocalDate value) { this.m_localDate = value; }

    public String getTimeZone() { return TimeZone.getDefault().getID(); }

    public Date getUtilDate() { return m_utilDate; }
    public void setUtilDate(Date value) { this.m_utilDate = value; }

    public void onResetUtilDateAction(javax.faces.event.ActionEvent event) 
    {
        m_utilDate = new Date();
    }

    public void onResetLocalDateAction(javax.faces.event.ActionEvent event) 
    {
        m_localDate = LocalDate.now();
    }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
}
