package org.eclnt.ccaddons.templates.dialogs;

import java.io.Serializable;

import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.pagebean.PageBean;

@CCGenClass (expressionBase="#{d.BasicPopupDialogUI}")

public class BasicPopupDialogUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------
    
    public interface IListener extends Serializable
    {
        void reactOnCancel();
        void reactOnOK();
    }
    
    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    private IListener m_listener;
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public BasicPopupDialogUI()
    {
    }

    public String getPageName() { return "/org/eclnt/ccaddons/templates/dialogs/BasicPopupDialog.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.BasicPopupDialogUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public void prepare(IListener listener)
    {
        m_listener = listener;
    }

    public void onCancelAction(javax.faces.event.ActionEvent event) 
    {
        if (m_listener != null)
            m_listener.reactOnCancel();
    }

    public void onOKAction(javax.faces.event.ActionEvent event) 
    {
        boolean success = processOK();
        if (success == true)
        {
            if (m_listener != null)
                m_listener.reactOnOK();
        }
        else
        {
            Statusbar.outputError("OK processing did not succeed.");
        }
    }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
    
    private boolean processOK()
    {
        // ...process OK...
        return true;
    }

}
