package org.eclnt.ccaddons.templates.dialogs;

import java.io.Serializable;

import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.pagebean.PageBean;

@CCGenClass (expressionBase="#{d.LogonUI}")

public class LogonUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------
    
    public interface IListener extends Serializable
    {
        public void reactOnLogon(String userName);
    }
    
    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    private IListener m_listener;
    String m_userName;
    String m_password;
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public LogonUI()
    {
    }

    public String getPageName() { return "/org/eclnt/ccaddons/templates/dialogs/Logon.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.LogonUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public void prepare(IListener listener)
    {
        m_listener = listener;
    }

    public String getPassword() { return m_password; }
    public void setPassword(String value) { this.m_password = value; }

    public String getUserName() { return m_userName; }
    public void setUserName(String value) { this.m_userName = value; }

    public void onLogonAction(javax.faces.event.ActionEvent event) 
    {
        boolean logonOK = checkLogonData();
        if (logonOK == false)
        {
            Statusbar.outputError("Could not logon - please check yout input.");
        }
        else
        {
            if (m_listener != null)
            {
                m_listener.reactOnLogon(m_userName);
            }
        }
    }

    public void onRequestNewPasswordAction(javax.faces.event.ActionEvent event) {}
    
    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
    
    private boolean checkLogonData()
    {
        if (m_userName == null || m_userName.trim().length() == 0 ||
            m_password == null || m_password.trim().length() == 0)
        {
            return false;
        }
        // dummy logic
        if (m_userName.equals(m_password) == true)
        {
            return true;
        }
        return false;
    }

}
