package org.eclnt.ccaddons.templates.dialogs;

import java.io.Serializable;

import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.jsfserver.util.HttpSessionAccess;

@CCGenClass (expressionBase="#{d.OutestUI}")

public class OutestUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------
    
    public interface IListener extends Serializable
    {
    }
    
    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    private IListener m_listener;
    IPageBean m_contentUI;
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public OutestUI()
    {
        showLogonUI();
    }

    public String getPageName() { return "/org/eclnt/ccaddons/templates/dialogs/OutestUI.jsp"; }
    public String getRootExpressionUsedInPage() { return "#{d.OutestUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public void prepare(IListener listener)
    {
        m_listener = listener;
    }

    public IPageBean getContentUI() { return m_contentUI; }
    
    private void showLogonUI()
    {
        LogonUI ui = new LogonUI();
        ui.prepare(new LogonUI.IListener()
        {
            @Override
            public void reactOnLogon(String userName)
            {
                storeUserNameInDialogSession(userName);
                showMainApplicationDialog();
            }

        });
        m_contentUI = ui;
    }

    protected void showMainApplicationDialog()
    {
        MainDialogUI ui = new MainDialogUI();
        m_contentUI = ui;
    }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
    
    private void storeUserNameInDialogSession(String userName)
    {
        // here you may store the userName in some session context. Example:
        HttpSessionAccess.getCurrentDialogSession().setAttribute("myapp.userName",userName);
        // but: best create one central context-object which you store in the
        // dialog session - instead of registering individual attributes!
    }
}
