package org.eclnt.ccaddons.pbc.demos;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclnt.ccaddons.pbc.CCMultiValueSelection;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.util.valuemgmt.ValueManager;

@CCGenClass (expressionBase="#{d.MultiValueSelectionDemoUI}")

public class MultiValueSelectionDemoUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------
    
    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    CCMultiValueSelection m_departmentSelection = new CCMultiValueSelection();
    boolean m_selectionToTop;
    boolean m_withFilter = false;
    boolean m_withFooter = false;
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public MultiValueSelectionDemoUI()
    {
        loadDepartments();
        m_departmentSelection.prepare(new CCMultiValueSelection.IListener()
        {
            @Override
            public void reactOnSelectionUpdate(Set<String> selectedIds)
            {
            }
        });
    }

    public String getPageName() { return "/org/eclnt/ccaddons/pbc/demos/MultiValueSelectionDemo.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.MultiValueSelectionDemoUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public CCMultiValueSelection getDepartmentSelection() { return m_departmentSelection; }

    public String getSelectedDepartments() 
    { 
        Set<String> ids = m_departmentSelection.getSelectedIds();
        if (ids.size() > 0)
        {
            List<String> idsList = new ArrayList<String>(ids);
            Collections.sort(idsList);
            return ValueManager.encodeCSV(idsList);
        }
        else
        {
            return "No department selected";
        }
    }

    public boolean getWithFilter() { return m_withFilter; }
    public void setWithFilter(boolean value) { this.m_withFilter = value; }

    public boolean getWithFooter() { return m_withFooter; }
    public void setWithFooter(boolean value) { this.m_withFooter = value; }

    public void onSelectByLogicAction(javax.faces.event.ActionEvent event) 
    {
        Set<String> selectedIds = new HashSet<String>();
        selectedIds.add("0001");
        selectedIds.add("0002");
        m_departmentSelection.setSelectedIds(selectedIds);
    }

    public boolean getSelectionToTop() { return m_selectionToTop; }
    public void setSelectionToTop(boolean value) { this.m_selectionToTop = value; }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
    
    private void loadDepartments()
    {
        m_departmentSelection.addValue("0001","Sales");
        m_departmentSelection.addValue("0002","Production I");
        m_departmentSelection.addValue("0003","Production II");
        m_departmentSelection.addValue("0004","Human Resources");
        m_departmentSelection.addValue("0005","Administration");
        m_departmentSelection.addValue("0006","Quality Control");
        m_departmentSelection.addValue("0007","Delivery");
    }

}
