package org.eclnt.ccaddons.pbc.demos;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.TimeZone;

import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.pagebean.PageBean;

import javax.faces.event.ActionEvent;

@CCGenClass (expressionBase="#{d.TouchTimeDemo1UI}")

public class TouchTimeDemo1UI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    Date m_utilDate = new Date();
    LocalTime m_localTime = LocalTime.now();
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public TouchTimeDemo1UI()
    {
    }

    public String getPageName() { return "/org/eclnt/ccaddons/pbc/demos/TouchTimeDemo1.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.TouchTimeDemo1UI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public LocalTime getLocalTime() { return m_localTime; }
    public void setLocalTime(LocalTime value) { this.m_localTime = value; }

    public String getTimeZone() { return TimeZone.getDefault().getID(); }

    public Date getUtilDate() { return m_utilDate; }
    public void setUtilDate(Date value) { this.m_utilDate = value; }

    public void onResetUtilDateAction(javax.faces.event.ActionEvent event) 
    {
        m_utilDate = new Date();
    }

    public void onResetLocalTimeAction(javax.faces.event.ActionEvent event) 
    {
        m_localTime = LocalTime.now();
    }
    
    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
}
