package org.eclnt.ccaddons.templates.dialogs;

import java.io.Serializable;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.pagebean.PageBean;

import javax.faces.event.ActionEvent;

@CCGenClass (expressionBase="#{d.HelloWorldUI}")

public class HelloWorldUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------
    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    String m_nameBgpaint;
    String m_result = "...not yet available...";
    String m_name;
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public HelloWorldUI()
    {
    }

    public String getPageName() { return "/org/eclnt/ccaddons/templates/dialogs/HelloWorld.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.HelloWorldUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public String getNameBgpaint() { return m_nameBgpaint; }
    public void setNameBgpaint(String value) { this.m_nameBgpaint = value; }

    public String getResult() { return m_result; }
    public void setResult(String value) { this.m_result = value; }

    public String getName() { return m_name; }
    public void setName(String value) { this.m_name = value; }

    public void onSayHelloAction(javax.faces.event.ActionEvent event) 
    {
        if (m_name == null || m_name.trim().length() == 0)
        {
            m_nameBgpaint = "error()";
            m_result = "...problem occurred when resolving result...";
            Statusbar.outputError("Please define a name.");
            return;
        }
        m_nameBgpaint = null;
        m_result = "Hello world, " + m_name + "!";
    }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
}
