package org.eclnt.ccaddons.templates.dialogs;

import java.io.Serializable;
import java.time.LocalDate;

import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.util.ValidValuesBinding;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.valuemgmt.UniqueIdCreator;

@CCGenClass (expressionBase="#{d.PersonFormSimpleUI}")

public class PersonFormSimpleUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------

    /**
     * "Pojo class" for the person. This class normally is a class on its own
     * and e.g. also used as bean to be persisted.
     */
    public class Person
    {
        String i_id = UniqueIdCreator.createUUID();
        String i_firstName;
        String i_lastName;
        LocalDate i_birthDay;
        Integer i_height; // could also be int-type...
        Integer i_weight; // could also be int-type...
        String i_street;
        String i_street2;
        String i_city;
        String i_zipCode;
        String i_countryId;
        public String getId() { return i_id; }
        public void setId(String id) { i_id = id; }
        public String getFirstName() { return i_firstName; }
        public void setFirstName(String firstName) { i_firstName = firstName; }
        public String getLastName() { return i_lastName; }
        public void setLastName(String lastName) { i_lastName = lastName; }
        public LocalDate getBirthDay() { return i_birthDay; }
        public void setBirthDay(LocalDate birthDay) { i_birthDay = birthDay; }
        public Integer getHeight() { return i_height; }
        public void setHeight(Integer height) { i_height = height; }
        public Integer getWeight() { return i_weight; }
        public void setWeight(Integer weight) { i_weight = weight; }
        public String getStreet() { return i_street; }
        public void setStreet(String street) { i_street = street; }
        public String getStreet2() { return i_street2; }
        public void setStreet2(String street2) { i_street2 = street2; }
        public String getCity() { return i_city; }
        public void setCity(String city) { i_city = city; }
        public String getZipCode() { return i_zipCode; }
        public void setZipCode(String zipCode) { i_zipCode = zipCode; }
        public String getCountryId() { return i_countryId; }
        public void setCountryId(String countryId) { i_countryId = countryId; }
    }
    
    public interface IListener extends Serializable
    {
        public void reactOnPersonSaved(Person p);
    }

    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------

    private IListener m_listener;
    Person m_person;
    ValidValuesBinding m_countryVVS = new ValidValuesBinding();

    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public PersonFormSimpleUI()
    {
        super();
        findValidValuesCountry();
        if (HttpSessionAccess.checkIfDialogSessionInLayoutEditorPreview())
        {
            // this part is only called if the layout is previewed in the editor
            // otherwise the layout is expected to be initialized by the page bean
            // using this dialog
            Person p = new Person();
            p.setFirstName("Captain");
            p.setLastName("Casa");
            p.setBirthDay(LocalDate.of(2007,9,1));
            p.setHeight(200);
            p.setStreet("Hindemithweg 13");
            p.setZipCode("69245");
            p.setCity("Bammental");
            p.setCountryId("DE");
            prepare(p,null);
        }
    }

    public String getPageName() { return "/org/eclnt/ccaddons/templates/dialogs/PersonFormSimple.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.PersonFormSimpleUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public void prepare(Person p, IListener listener)
    {
        m_person = p;
        m_listener = listener;
    }

    public Person getPerson() { return m_person; }
    public ValidValuesBinding getCountryVVS() { return m_countryVVS; }

    public void onSaveAction(javax.faces.event.ActionEvent event) 
    {
        try
        {
            // check data of Person-bean
            // ...
            // save data of Person-bean
            // ...
            // notify registered listener
            if (m_listener != null)
                m_listener.reactOnPersonSaved(m_person);
        }
        catch (Throwable t)
        {
            Statusbar.outputError("Problem during saving: " + t.toString());
        }
    }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
    
    private void findValidValuesCountry()
    {
        // pick values - here: directly, normally by e.g. logical API
        m_countryVVS.addValidValue("BG","Bulgaria");
        m_countryVVS.addValidValue("DE","Germany");
        m_countryVVS.addValidValue("FR","France");
        m_countryVVS.addValidValue("UK","United Kingdom");
        m_countryVVS.addValidValue("US","United States");
    }

}
