package org.eclnt.ccaddons.templates.dialogs;

import java.io.Serializable;

import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup.IYesNoListener;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.jsfserver.util.HttpSessionAccess;

@CCGenClass (expressionBase="#{d.MainDialogUI}")

public class MainDialogUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------
    
    public interface IListener extends Serializable
    {
    }
    
    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    private IListener m_listener;
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public MainDialogUI()
    {
    }

    public String getPageName() { return "/org/eclnt/ccaddons/templates/dialogs/MainDialogUI.jsp"; }
    public String getRootExpressionUsedInPage() { return "#{d.MainDialogUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public void prepare(IListener listener)
    {
        m_listener = listener;
    }

    public void onLogOffAction(org.eclnt.jsfserver.base.faces.event.ActionEvent event) 
    {
        YESNOPopup.createInstance("Log off","Do you really want to log off?",new IYesNoListener()
        {
            @Override
            public void reactOnYes()
            {
                logoff();
            }
            @Override
            public void reactOnNo()
            {
            }
        });
    }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
    
    private void logoff()
    {
        HttpSessionAccess.getCurrentDialogSession().invalidate();
    }

}
