package org.eclnt.ccaddons.templates.dialogs;

import java.io.Serializable;
import java.time.LocalDate;

import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup.IYesNoListener;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.util.valuemgmt.UniqueIdCreator;

@CCGenClass (expressionBase="#{d.GridSimpleUI}")

public class GridSimpleUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------
    
    public interface IListener extends Serializable
    {
        public void reactOnItemSelected(String id);
    }
    
    public class GridItem extends FIXGRIDItem implements java.io.Serializable
    {    
        String i_id;
        LocalDate i_dateOfBirth;
        String i_lastName;
        String i_firstName;
        public String getId() { return i_id; }
        public void setId(String id) { i_id = id; }
        public LocalDate getDateOfBirth() { return i_dateOfBirth; }
        public void setDateOfBirth(LocalDate value) { this.i_dateOfBirth = value; }
        public String getLastName() { return i_lastName; }
        public void setLastName(String value) { this.i_lastName = value; }
        public String getFirstName() { return i_firstName; }
        public void setFirstName(String value) { this.i_firstName = value; }
        public void onRowSelect()
        {
        }
        public void onRowExecute()
        {
            if (m_listener != null)
                m_listener.reactOnItemSelected(i_id);
        }
        public void onItemRemoveAction(org.eclnt.jsfserver.base.faces.event.ActionEvent event) 
        {
            YESNOPopup.createInstance
            (
                "Removal of " + i_lastName + ", " + i_firstName,
                "Do you really want to remove the selected item?",
                new IYesNoListener()
                {
                    @Override
                    public void reactOnYes()
                    {
                        removeItemExecute();
                    }
                    @Override
                    public void reactOnNo() {}
                }
            );
        }
        private void removeItemExecute()
        {
            m_grid.getItems().remove(this);
        }
    }

    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    private IListener m_listener;
    FIXGRIDListBinding<GridItem> m_grid = new FIXGRIDListBinding<GridItem>();
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public GridSimpleUI()
    {
        fillGridWithDummyData();
    }

    public String getPageName() { return "/org/eclnt/ccaddons/templates/dialogs/GridSimple.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.GridSimpleUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public void prepare(IListener listener)
    {
        m_listener = listener;
    }

    public FIXGRIDListBinding<GridItem> getGrid() { return m_grid; }

    public void onAddItemAction(org.eclnt.jsfserver.base.faces.event.ActionEvent event) 
    {
        GridItem gi = new GridItem();
        gi.setId(UniqueIdCreator.createUUID());
        gi.setFirstName("...new...");
        gi.setLastName("...new...");
        gi.setDateOfBirth(LocalDate.of(2010,6,1));
        m_grid.getItems().add(0,gi);
        m_grid.deselectCurrentSelection();
        m_grid.selectAndFocusItem(gi);
    }

    public void onRemoveAllAction(org.eclnt.jsfserver.base.faces.event.ActionEvent event) 
    {
        YESNOPopup.createInstance
        (
            "Removal of all items",
            "Do you really want to remove all items?",
            new IYesNoListener()
            {
                @Override
                public void reactOnYes()
                {
                    removeAllExecute();
                }
                @Override
                public void reactOnNo() {}
            }
        );
    }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
    
    private void fillGridWithDummyData()
    {
        for (int i=0; i<10; i++)
        {
            GridItem gi = new GridItem();
            gi.setId(UniqueIdCreator.createUUID());
            gi.setFirstName("First " + i);
            gi.setLastName("Last " + i);
            gi.setDateOfBirth(LocalDate.of(2010,6,1));
            m_grid.getItems().add(gi);
        }
    }

    private void removeAllExecute()
    {
        m_grid.getItems().clear();
    }

}
