package org.eclnt.ccaddons.templates.dialogs;

import java.io.Serializable;
import java.time.LocalDate;

import org.eclnt.ccaddons.templates.dialogs.GridSimpleUI.GridItem;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup.IYesNoListener;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.util.valuemgmt.UniqueIdCreator;

@CCGenClass (expressionBase="#{d.GridSimpleWithBeansUI}")

public class GridSimpleWithBeansUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------
    
    public interface IListener extends Serializable
    {
        public void reactOnItemSelected(Person bean);
    }
    
    /* This class typically is an "outer" class that is part of some logic layer. */
    public class Person
    {
        String i_id;
        LocalDate i_dateOfBirth;
        String i_lastName;
        String i_firstName;
        public String getId() { return i_id; }
        public void setId(String id) { i_id = id; }
        public LocalDate getDateOfBirth() { return i_dateOfBirth; }
        public void setDateOfBirth(LocalDate value) { this.i_dateOfBirth = value; }
        public String getLastName() { return i_lastName; }
        public void setLastName(String value) { this.i_lastName = value; }
        public String getFirstName() { return i_firstName; }
        public void setFirstName(String value) { this.i_firstName = value; }
    }
    
    public class GridItem extends FIXGRIDItem implements java.io.Serializable
    {    
        Person i_bean;
        public GridItem(Person bean)
        {
            i_bean = bean; 
        }
        public Person getBean() { return i_bean; } 
        public void onRowSelect()
        {
        }
        public void onRowExecute()
        {
            if (m_listener != null)
                m_listener.reactOnItemSelected(i_bean);
        }
        public void onItemRemoveAction(org.eclnt.jsfserver.base.faces.event.ActionEvent event) 
        {
            YESNOPopup.createInstance
            (
                "Removal of " + i_bean.getLastName() + ", " + i_bean.getFirstName(),
                "Do you really want to remove the selected item?",
                new IYesNoListener()
                {
                    @Override
                    public void reactOnYes()
                    {
                        removeItemExecute();
                    }
                    @Override
                    public void reactOnNo() {}
                }
            );
        }
        private void removeItemExecute()
        {
            m_grid.getItems().remove(this);
        }
    }
    
    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    private IListener m_listener;
    FIXGRIDListBinding<GridItem> m_grid = new FIXGRIDListBinding<GridItem>();
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public GridSimpleWithBeansUI()
    {
        fillGridWithDummyData();
    }

    public String getPageName() { return "/org/eclnt/ccaddons/templates/dialogs/GridSimpleWithBeans.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.GridSimpleWithBeansUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public void prepare(IListener listener)
    {
        m_listener = listener;
    }

    public FIXGRIDListBinding<GridItem> getGrid() { return m_grid; }

    public void onAddItemAction(org.eclnt.jsfserver.base.faces.event.ActionEvent event) 
    {
        Person p = new Person();
        p.setId(UniqueIdCreator.createUUID());
        p.setFirstName("...new...");
        p.setLastName("...new...");
        p.setDateOfBirth(LocalDate.of(2010,6,1));
        GridItem gi = new GridItem(p);
        m_grid.getItems().add(0,gi);
        m_grid.deselectCurrentSelection();
        m_grid.selectAndFocusItem(gi);
    }

    public void onRemoveAllAction(org.eclnt.jsfserver.base.faces.event.ActionEvent event) 
    {
        YESNOPopup.createInstance
        (
            "Removal of all items",
            "Do you really want to remove all items?",
            new IYesNoListener()
            {
                @Override
                public void reactOnYes()
                {
                    removeAllExecute();
                }
                @Override
                public void reactOnNo() {}
            }
        );
    }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
    
    private void fillGridWithDummyData()
    {
        for (int i=0; i<10; i++)
        {
            Person p = new Person();
            p.setId(UniqueIdCreator.createUUID());
            p.setFirstName("First " + i);
            p.setLastName("Last " + i);
            p.setDateOfBirth(LocalDate.of(2010,6,1));
            GridItem gi = new GridItem(p);
            m_grid.getItems().add(gi);
        }
    }

    private void removeAllExecute()
    {
        m_grid.getItems().clear();
    }

}
