package org.eclnt.ccaddons.templates.dialogs;

import java.io.Serializable;

import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.pagebean.PageBean;

@CCGenClass (expressionBase="#{d.TreeSimpleUI}")

public class TreeSimpleUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------
    
    public interface IListener extends Serializable
    {
    }
    
    public class TreeNode extends FIXGRIDTreeItem implements java.io.Serializable
    {
        int i_inhabitants;
        public TreeNode(FIXGRIDTreeItem parent, String text, int inhabitants, boolean isCityNode)
        {
            super(parent);
            setText(text);
            i_inhabitants = inhabitants;
            if (isCityNode)
            {
                setStatus(STATUS_ENDNODE);
                setImage("/org/eclnt/ccaddons/templates/dialogs/images/city_16x16.svg");
            }
        }
        public void setInhabitants(int value) { i_inhabitants = value; }
        public int getInhabitants() { return i_inhabitants; }
        public void onRowSelect()
        {
            Statusbar.outputMessage("SELECT on " + getText());
        }
        public void onRowExecute()
        {
        }
        public void onToggle()
        {
        }
    }

    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    private IListener m_listener;
    FIXGRIDTreeBinding<TreeNode> m_tree = new FIXGRIDTreeBinding<TreeNode>();
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public TreeSimpleUI()
    {
        loadTreeData();
    }

    public String getPageName() { return "/org/eclnt/ccaddons/templates/dialogs/TreeSimple.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.TreeSimpleUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    public void prepare(IListener listener)
    {
        m_listener = listener;
    }

    public FIXGRIDTreeBinding<TreeNode> getTree() { return m_tree; }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
    
    private void loadTreeData()
    {
        TreeNode country;
        TreeNode town;
        country = new TreeNode(m_tree.getRootNode(),"Germany",80000000,false);
        town    = new TreeNode(country,"Bammental",6800,true);
        town    = new TreeNode(country,"Berlin",3000000,true);
        town    = new TreeNode(country,"Munich",1000000,true);
        town    = new TreeNode(country,"Hamburg",1200000,true);
        country = new TreeNode(m_tree.getRootNode(),"Liechtenstein",20000,false);
        town    = new TreeNode(country,"Vaduz",20000,true);
        country = new TreeNode(m_tree.getRootNode(),"United Kingdom",60000000,false);
        town    = new TreeNode(country,"London",6000000,true);
        town    = new TreeNode(country,"Manchester",500000,true);
        country = new TreeNode(m_tree.getRootNode(),"United States",280000000,false);
        town    = new TreeNode(country,"Los Angeles",5000000,true);
        town    = new TreeNode(country,"New York",9000000,true);
        town    = new TreeNode(country,"San Francisco",1000000,true);
    }

}
