package org.eclnt.ccaddons.templates.dialogs;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.pagebean.PageBean;

@CCGenClass (expressionBase="#{d.TreeSimpleWithBeansUI}")

public class TreeSimpleWithBeansUI
    extends PageBean 
    implements Serializable
{
    // ------------------------------------------------------------------------
    // inner classes
    // ------------------------------------------------------------------------
    
    public interface IListener extends Serializable
    {
    }

    /*
     * This class is some external class normally...
     */
    public static class CostCentre
    {
        String i_name;
        BigDecimal i_budget;
        BigDecimal i_cost;
        public String getName() { return i_name; }
        public void setName(String name) { i_name = name; }
        public BigDecimal getBudget() { return i_budget; }
        public void setBudget(BigDecimal budget) { i_budget = budget; }
        public BigDecimal getCost() { return i_cost; }
        public void setCost(BigDecimal cost) { i_cost = cost; }
    }
    
    public class TreeNode extends FIXGRIDTreeItem implements java.io.Serializable
    {
        CostCentre i_bean;
        boolean i_subNodesRead = false;
        public TreeNode(FIXGRIDTreeItem parentNode, CostCentre bean)
        {
            super(parentNode);
            i_bean = bean;
            setText(bean.getName());
        }
        public CostCentre getBean() { return i_bean; }
        public void onRowSelect() { }
        public void onRowExecute() { }
        public void onToggle()
        {
            if (i_subNodesRead == false)
            {
                List<CostCentre> subCcs = readSubCostCentres(i_bean);
                for (CostCentre cc: subCcs)
                {
                    TreeNode tn = new TreeNode(this,cc);
                    tn.setStatus(TreeNode.STATUS_CLOSED);
                }
            }
        }
        // example for a property which is not available in the bean
        // but which is "ad hoc" added on UI layer
        public BigDecimal getDelta()
        {
            return i_bean.getBudget().subtract(i_bean.getCost());
        }
        public String getDeltaColor()
        {
            BigDecimal delta = getDelta();
            if (delta.compareTo(new BigDecimal(0)) >= 0)
                return "#E0FFE0";
            else
                return "#FFE0E0";
        }
    }

    // ------------------------------------------------------------------------
    // members
    // ------------------------------------------------------------------------
    
    private IListener m_listener;
    FIXGRIDTreeBinding<TreeNode> m_tree = new FIXGRIDTreeBinding<TreeNode>();
    
    // ------------------------------------------------------------------------
    // constructors & initialization
    // ------------------------------------------------------------------------

    public TreeSimpleWithBeansUI()
    {
        List<CostCentre> ccs = readRootCostCentres();
        for (CostCentre cc: ccs)
        {
            TreeNode tn = new TreeNode(m_tree.getRootNode(),cc);
            tn.setStatus(TreeNode.STATUS_CLOSED);
        }
    }

    public String getPageName() { return "/org/eclnt/ccaddons/templates/dialogs/TreeSimpleWithBeans.xml"; }
    public String getRootExpressionUsedInPage() { return "#{d.TreeSimpleWithBeansUI}"; }

    // ------------------------------------------------------------------------
    // public usage
    // ------------------------------------------------------------------------

    /* Initialization of the bean. Add any parameter that is required within your scenario. */
    public void prepare(IListener listener)
    {
        m_listener = listener;
    }

    public FIXGRIDTreeBinding<TreeNode> getTree() { return m_tree; }

    // ------------------------------------------------------------------------
    // private usage
    // ------------------------------------------------------------------------
    
    private List<CostCentre> readRootCostCentres()
    {
        // this logic should be located in the logic part of your application
        Random r = new Random();
        List<CostCentre> result = new ArrayList<CostCentre>();
        for (int i=0; i<5; i++)
        {
            CostCentre cc = new CostCentre();
            cc.setName("Cost centre " + r.nextInt(1000));
            cc.setBudget(new BigDecimal(r.nextInt(1000000)));
            cc.setCost(new BigDecimal(r.nextInt(50000)));
            result.add(cc);
        }
        return result;
    }
    
    public List<CostCentre> readSubCostCentres(CostCentre bean)
    { 
        // this logic should be located in the logic part of your application
        Random r = new Random();
        int maxi = r.nextInt(5) + 1;
        List<CostCentre> result = new ArrayList<CostCentre>();
        for (int i=0; i<maxi; i++)
        {
            CostCentre cc = new CostCentre();
            cc.setName("Cost centre " + r.nextInt(1000));
            cc.setBudget(new BigDecimal(r.nextInt(1000000)));
            cc.setCost(new BigDecimal(r.nextInt(1000000)));
            result.add(cc);
        }
        return result;
    }

}
