/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.event.ActionEvent;
import org.eclnt.ccaddons.pbc.dyndata.CCDynDataBrowser;
import org.eclnt.ccaddons.pbc.simplexml.CCSimpleXMLEditor;
import org.eclnt.ccaddons.pbc.simplexml.ENUMDropPosition;
import org.eclnt.ccaddons.pbc.simplexml.logic.SXMLLogic;
import org.eclnt.ccaddons.pbc.simplexml.logic.SXMLMetaData;
import org.eclnt.ccaddons.pbc.sjrxml.CCSjrxmlEditorMessagesUI;
import org.eclnt.ccaddons.pbc.sjrxml.CCSjrxmlPalette;
import org.eclnt.ccaddons.pbc.sjrxml.i18n.SJRXMLLit;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataDynDataDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlLogic;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlPersistence;
import org.eclnt.ccaddons.pbc.sjrxml.logic.XYContentRenderer;
import org.eclnt.ccaddons.pbc.sjrxml.logic.XYContentSJRXMLElement;
import org.eclnt.ccaddons.pbc.text.CCShowText;
import org.eclnt.ccaddons.pbc.xyeditor.CCXYEditor;
import org.eclnt.ccaddons.pbc.xyeditor.logic.IXYContent;
import org.eclnt.ccaddons.pbc.xyeditor.logic.IXYContentRenderer;
import org.eclnt.ccaddons.pbc.xyeditor.logic.XYMargin;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.dyndata.DynDataMap;
import org.eclnt.ccee.dyndata.DynDataReader;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.DynDataUtil;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.JRXMLGeneratorLogic;
import org.eclnt.ccee.sjrxml.checking.SJRXMLChecker;
import org.eclnt.ccee.sjrxml.checking.SJRXMLCheckerResultItem;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponent;
import org.eclnt.jsfserver.util.tempfile.TempFileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.PojoManager;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IWorkpageAwarePageBean;
import org.eclnt.workplace.IWorkpageDispatcher;

@CCGenClass(expressionBase="#{d.CCSjrxmlEditor}")
public class CCSjrxmlEditor
extends PageBeanComponent
implements Serializable,
ICCEEConstants,
IWorkpageAwarePageBean {
    static final int TABVALUE_EDITOR = 0;
    static final int TABVALUE_PDF = 1;
    static final int TABVALUE_HTML = 2;
    private IListener m_listener;
    CCSimpleXMLEditor m_sxmlEditor;
    CCXYEditor m_xyEditor;
    SjrxmlLogic m_logic = new SjrxmlLogic();
    XYContentRenderer m_xyContentRenderer = new XYContentRenderer();
    CCXYEditor.IListener m_editorListener;
    boolean m_justProcessingSelection = false;
    int m_tabValue = 0;
    String m_pdfURL = "about:blank";
    String m_htmlURL = "about:blank";
    CCSjrxmlEditorMessagesUI m_messagesUI = new CCSjrxmlEditorMessagesUI();
    String m_height = "100%";
    String m_width = "100%";
    int m_dataBrowserWidth = 290;
    CCDynDataBrowser m_dddBrowser = new CCDynDataBrowser();
    String m_formId = "undefined";
    String m_dddId = "undefined";
    DynDataReaderContext m_ddrContext;
    CCSjrxmlPalette m_palette = new CCSjrxmlPalette();
    private static double PIXEL_PER_CM = 28.346457;
    private static String COLOR_GRID_LIGHT = "#00000008";
    private static String COLOR_GRID = "#00000010";
    private static String COLOR_GRID_SIDE = "#00000020";
    IWorkpageDispatcher m_dispatcher;

    public CCSjrxmlEditor() {
        this.m_sxmlEditor = new CCSimpleXMLEditor();
        this.m_xyEditor = new CCXYEditor();
        String ppcm = ValueManager.convertObject2ValueString((Object)PIXEL_PER_CM);
        String ppcm5 = ValueManager.convertObject2ValueString((Object)(5.0 * PIXEL_PER_CM));
        this.m_xyEditor.setDrawCommandsHeader(ValueManager.encodeMethod((String)"grid", (String[])new String[]{ppcm, ppcm, COLOR_GRID_SIDE}));
        this.m_xyEditor.setDrawCommandsLeft(ValueManager.encodeMethod((String)"grid", (String[])new String[]{ppcm, ppcm, COLOR_GRID_SIDE}));
        this.m_xyEditor.setDrawCommandsBody(ValueManager.encodeMethod((String)"grid", (String[])new String[]{ppcm, ppcm, COLOR_GRID_LIGHT}) + ";" + ValueManager.encodeMethod((String)"grid", (String[])new String[]{ppcm5, ppcm5, COLOR_GRID}));
        this.m_xyEditor.setScalePercentage(150);
    }

    public void setWorkpageDispatcher(IWorkpageDispatcher dispatcher) {
        this.m_dispatcher = dispatcher;
        this.m_dddBrowser.setWorkpageDispatcher(dispatcher);
    }

    public String getRootExpressionUsedInPage() {
        return "#{d.CCSjrxmlEditor}";
    }

    public boolean getRenderedEditor() {
        return this.m_tabValue == 0;
    }

    public boolean getRenderedPdf() {
        return this.m_tabValue == 1;
    }

    public boolean getRenderedHtml() {
        return this.m_tabValue == 2;
    }

    public String getPdfURL() {
        return this.m_pdfURL;
    }

    public String getHtmlURL() {
        return this.m_htmlURL;
    }

    public CCSjrxmlPalette getPalette() {
        return this.m_palette;
    }

    public String getHeight() {
        return this.m_height;
    }

    public void setHeight(String value) {
        this.m_height = value;
    }

    public String getWidth() {
        return this.m_width;
    }

    public void setWidth(String value) {
        this.m_width = value;
    }

    public void prepare(String formId, String xml, String xmlMetaData, String dddId, DynDataReaderContext ddrContext, IListener listener) {
        this.m_formId = formId;
        this.m_dddId = dddId;
        this.m_ddrContext = ddrContext;
        SXMLMetaData md = SXMLLogic.parseMetaData((String)xmlMetaData);
        this.m_editorListener = new CCXYEditor.IListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reactOnSelected(Set<IXYContent> xyContents) {
                if (CCSjrxmlEditor.this.m_justProcessingSelection) {
                    return;
                }
                try {
                    CCSjrxmlEditor.this.m_justProcessingSelection = true;
                    HashSet<SimpleXMLElement> elements = new HashSet<SimpleXMLElement>();
                    for (IXYContent xyContent : xyContents) {
                        elements.add(((XYContentSJRXMLElement)xyContent).getXmlElement());
                    }
                    CCSjrxmlEditor.this.m_sxmlEditor.selectXMLElements(elements);
                }
                finally {
                    CCSjrxmlEditor.this.m_justProcessingSelection = false;
                }
            }

            public void reactOnContentUpdate() {
                CCSjrxmlEditor.this.updateXYEditorFromSXMLEditor();
            }

            public void reactOnNewXMLElement(SimpleXMLElement parent, SimpleXMLElement newChild) {
                CCSjrxmlEditor.this.m_sxmlEditor.addNewElement(parent, newChild);
            }
        };
        this.m_xyEditor.prepare((IXYContentRenderer)this.m_xyContentRenderer, new ArrayList(), this.m_editorListener);
        this.m_sxmlEditor.prepare(md, xml, (CCSimpleXMLEditor.IListener)new CCSimpleXMLEditor.DefaultListener(){

            public void reactOnXmlUpdate() {
                CCSjrxmlEditor.this.updateXYEditorFromSXMLEditor();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reactOnSelection(Set<SimpleXMLElement> xmlElements) {
                if (CCSjrxmlEditor.this.m_justProcessingSelection) {
                    return;
                }
                try {
                    CCSjrxmlEditor.this.m_justProcessingSelection = true;
                    if (CCSjrxmlEditor.this.m_xyEditor != null) {
                        HashSet<IXYContent> xyContents = new HashSet<IXYContent>();
                        for (SimpleXMLElement xmlElement : xmlElements) {
                            xyContents.add(CCSjrxmlEditor.this.findXYContent(xmlElement, CCSjrxmlEditor.this.m_xyEditor.getXyContents()));
                        }
                        CCSjrxmlEditor.this.m_xyEditor.selectXYContents(xyContents);
                    }
                }
                finally {
                    CCSjrxmlEditor.this.m_justProcessingSelection = false;
                }
            }

            public void reactOnXMLElementCreated(SimpleXMLElement xmlElement) {
                CCSjrxmlEditor.this.m_logic.updateNewElement(xmlElement);
            }

            public void reactOnNodeCreatedByCopyFromOtherNode(SimpleXMLElement createdElement, SimpleXMLElement movedElement, SimpleXMLElement toElement, ENUMDropPosition position) {
                CCSjrxmlEditor.this.m_logic.updateElementCreatedByCopy(createdElement, movedElement, toElement, position);
            }
        });
        this.updateXYEditorFromSXMLEditor();
        this.m_messagesUI.prepare(new CCSjrxmlEditorMessagesUI.IListener(){

            @Override
            public void reactOnSelection(SimpleXMLElement[] xmlElements) {
                HashSet<SimpleXMLElement> se = new HashSet<SimpleXMLElement>();
                for (SimpleXMLElement element : xmlElements) {
                    se.add(element);
                }
                CCSjrxmlEditor.this.m_sxmlEditor.selectXMLElements(se);
            }
        });
        this.updateDynDataBrowser();
        this.m_listener = listener;
    }

    public CCDynDataBrowser getDddBrowser() {
        return this.m_dddBrowser;
    }

    public int getDataBrowserWidth() {
        return this.m_dataBrowserWidth;
    }

    public void setDataBrowserWidth(int value) {
        this.m_dataBrowserWidth = value;
    }

    public void initializePageBean(Map<String, String> initData) {
        super.initializePageBean(initData);
        PojoManager.transferStringMapDataIntoPojoChangesOnly(initData, (Object)this, (boolean)false);
    }

    public void onBeforeRendering() {
    }

    public CCSimpleXMLEditor getSxmlEditor() {
        return this.m_sxmlEditor;
    }

    public CCXYEditor getXyEditor() {
        return this.m_xyEditor;
    }

    public CCSjrxmlEditorMessagesUI getMessagesUI() {
        return this.m_messagesUI;
    }

    public int getTabValue() {
        return this.m_tabValue;
    }

    public void setTabValue(int value) {
        this.m_tabValue = value;
    }

    public void onTabAction(ActionEvent event) {
        switch (this.m_tabValue) {
            case 0: {
                break;
            }
            case 1: {
                this.checkCurrentContent();
                this.showPDF();
                break;
            }
            case 2: {
                this.checkCurrentContent();
                this.showHTML();
                break;
            }
        }
    }

    public void onCheckAction(ActionEvent event) {
        this.checkCurrentContent();
    }

    public String getCurrentXml() {
        return this.m_sxmlEditor.getXml();
    }

    public SimpleXMLElement getCurrentSimpleXml() {
        return this.m_sxmlEditor.getSimpleXml();
    }

    public String getCurrentDynamicDataDefinitionXml() {
        return this.m_dddBrowser.getCurrentXml();
    }

    public void onShowJrxmlAction(ActionEvent event) {
        try {
            String sjrxml = this.getCurrentXml();
            String jrxml = new JRXMLGeneratorLogic().createJrxmlFromSjrxml(sjrxml);
            final CCShowText ui = new CCShowText();
            ui.prepare(null);
            ui.setText(jrxml);
            ui.resetFilteredText();
            ui.onBeforeRendering();
            ModelessPopup p = this.openModelessPopup((IPageBean)ui, "", 1000, 800, new ModelessPopup.IModelessPopupListener(){

                public void reactOnPopupClosedByUser() {
                    CCSjrxmlEditor.this.closePopup((IPageBean)ui);
                }
            });
            p.setUndecorated(true);
            p.setCloseonclickoutside(true);
            p.setSizeableIfUndecorated(true);
        }
        catch (Throwable t) {
            CLog.L.log(LL_INF, "Problem creating JRXML", t);
            Statusbar.outputError((String)("Problem when creating JRXML: " + t), (String)ValueManager.getStackstraceString((Throwable)t));
        }
    }

    private void checkCurrentContent() {
        SimpleXMLElement top = this.m_sxmlEditor.getSimpleXml();
        List<Object> messages = null;
        messages = top != null ? new SJRXMLChecker().checkXml(top).getItems() : new ArrayList();
        this.m_messagesUI.showMessages(messages);
    }

    private void showHTML() {
        this.m_htmlURL = "about:blank";
        try {
            String xml = this.m_sxmlEditor.getXml();
            JRXMLGeneratorLogic logic = new JRXMLGeneratorLogic();
            Object dataObject = this.createDataObject();
            byte[] bytes = logic.exportHtmlBytes(null, xml, dataObject);
            this.m_htmlURL = TempFileManager.saveTempFile((String)"demo.html", (byte[])bytes);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem creating HTML", t);
            Statusbar.outputError((String)t.toString(), (String)ValueManager.getStackstraceString((Throwable)t));
            this.showErrorInMessages(t);
        }
    }

    private void showErrorInMessages(Throwable t) {
        ArrayList<SJRXMLCheckerResultItem> messages = new ArrayList<SJRXMLCheckerResultItem>();
        Throwable current = t;
        while (true) {
            SJRXMLCheckerResultItem message = new SJRXMLCheckerResultItem();
            String text = current.getMessage();
            if (text == null) {
                text = current.toString();
            }
            text = text.replace("\r", "");
            text = text.replace("\n", ", ");
            text = text + "\n\n" + ValueManager.getStackstraceString((Throwable)t);
            message.setErrorText(text);
            messages.add(message);
            if (current.getCause() == null || current.getCause() == current) break;
            current = current.getCause();
        }
        this.m_messagesUI.showMessages(messages);
    }

    private void showPDF() {
        this.m_pdfURL = "about:blank";
        try {
            String xml = this.m_sxmlEditor.getXml();
            JRXMLGeneratorLogic logic = new JRXMLGeneratorLogic();
            Object dataObject = this.createDataObject();
            byte[] bytes = logic.exportPdfBytes(this.buildExportId(), xml, dataObject);
            this.m_pdfURL = TempFileManager.saveTempFile((String)"preview.pdf", (byte[])bytes);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem creating PDF", t);
            Statusbar.outputError((String)t.toString(), (String)ValueManager.getStackstraceString((Throwable)t));
            this.showErrorInMessages(t);
        }
    }

    private String buildExportId() {
        return ValueManager.convertStringIntoFileName((String)this.m_formId);
    }

    private Object createDataObject() {
        if (this.m_listener != null) {
            return this.m_listener.createPreviewDataObject();
        }
        HashMap map = new HashMap();
        DynDataDefinition ddd = this.m_dddBrowser.getCurrentDynDataDefinition();
        DynDataMap ddm = new DynDataReader(new DynDataReaderContext()).createDynDataMapFromMap(ddd, map);
        return map;
    }

    private IXYContent findXYContent(SimpleXMLElement element, List<IXYContent> xyContents) {
        for (IXYContent xyContent : xyContents) {
            XYContentSJRXMLElement xyc = (XYContentSJRXMLElement)xyContent;
            if (xyc.getXmlElement() == element) {
                return xyc;
            }
            IXYContent childResult = this.findXYContent(element, xyc.getChildren());
            if (childResult == null) continue;
            return childResult;
        }
        return null;
    }

    private void updateXYEditorFromSXMLEditor() {
        Statusbar.outputSuccess((String)("UPDATE" + System.currentTimeMillis()));
        SimpleXMLElement xmlElement = this.m_sxmlEditor.getSimpleXml();
        List<IXYContent> xyContents = this.m_logic.transferXmlIntoXYContent(xmlElement);
        XYMargin margin = new XYMargin(xmlElement.getValue("margin"));
        Set selectedXys = this.m_xyEditor.getSelectedXYContent();
        Set<SimpleXMLElement> selectedElements = this.findSimpleXMLElementsFromXYContent(selectedXys);
        this.m_xyEditor.setPageMargin(margin);
        this.m_xyEditor.prepare((IXYContentRenderer)this.m_xyContentRenderer, xyContents, this.m_editorListener);
        Set<IXYContent> newSelectedXys = this.findSelectedXYContentFromSimpleXMLElements(xyContents, selectedElements);
        this.m_xyEditor.selectXYContents(newSelectedXys);
    }

    private Set<IXYContent> dumpXYContent(List<IXYContent> content) {
        HashSet<IXYContent> result = new HashSet<IXYContent>();
        for (IXYContent xy : content) {
            this.dumpXYContent(xy, result);
        }
        return result;
    }

    private void dumpXYContent(IXYContent content, Set<IXYContent> result) {
        result.add(content);
        for (IXYContent child : content.getChildren()) {
            this.dumpXYContent(child, result);
        }
    }

    private Set<IXYContent> findSelectedXYContentFromSimpleXMLElements(List<IXYContent> xys, Set<SimpleXMLElement> selectedElements) {
        Set<IXYContent> all = this.dumpXYContent(xys);
        HashSet<IXYContent> result = new HashSet<IXYContent>();
        for (IXYContent xy : all) {
            SimpleXMLElement el;
            if (!(xy instanceof XYContentSJRXMLElement) || !selectedElements.contains(el = ((XYContentSJRXMLElement)xy).getXmlElement())) continue;
            result.add(xy);
        }
        return result;
    }

    private Set<SimpleXMLElement> findSimpleXMLElementsFromXYContent(Set<IXYContent> xys) {
        HashSet<SimpleXMLElement> result = new HashSet<SimpleXMLElement>();
        for (IXYContent xy : xys) {
            if (!(xy instanceof XYContentSJRXMLElement)) continue;
            SimpleXMLElement el = ((XYContentSJRXMLElement)xy).getXmlElement();
            result.add(el);
        }
        return result;
    }

    private void refreshDynDataBrowser() {
        if (this.m_listener != null) {
            String xml = this.m_listener.readRefreshedDynDataDefinitionXml();
            this.updateDynDataBrowser();
        }
    }

    private void updateDynDataBrowser() {
        String xml = null;
        if (this.m_dddId != null) {
            DataDynDataDefinition dddd = SjrxmlPersistence.instance().readDataDynData(this.m_dddId);
            xml = dddd.getXml();
        }
        DynDataDefinition ddd = null;
        ddd = xml != null ? DynDataUtil.parseDynDataDefinitionXml(xml) : DynDataUtil.createDemoDDD();
        this.m_dddBrowser.prepare(ddd, this.m_ddrContext, this.m_dddId, new CCDynDataBrowser.IListener(){

            @Override
            public void reactOnRefreshRequested() {
                CCSjrxmlEditor.this.refreshDynDataBrowser();
            }

            @Override
            public void reactOnDynDataChanged(DynDataDefinition ddd) {
                CCSjrxmlEditor.this.saveUpdatedDynDataDefinition(ddd);
                Statusbar.outputSuccess((String)SJRXMLLit.lit("msgDataDefinitionSaved", new String[0]));
            }
        });
    }

    protected void saveUpdatedDynDataDefinition(DynDataDefinition ddd) {
        DataDynDataDefinition dddd = SjrxmlPersistence.instance().readDataDynData(this.m_dddId);
        String xml = DynDataUtil.marshalDynDataDefinition((DynDataDefinition)ddd);
        dddd.setXml(xml);
        SjrxmlPersistence.instance().saveDataDynData(dddd);
        this.updateDynDataBrowser();
    }

    public static interface IListener
    extends Serializable {
        public Object createPreviewDataObject();

        public String readRefreshedDynDataDefinitionXml();
    }
}

