/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.ccaddons.pbc.sjrxml.i18n.SJRXMLLit;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataDynDataDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlLogicExportImport;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlPersistence;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDItem;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponent;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.tempfile.TempFileManager;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.file.ZipUtil;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

@CCGenClass(expressionBase="#{d.CCSjrxmlExport}")
public class CCSjrxmlExport
extends PageBeanComponent
implements Serializable {
    private IListener m_listener;
    String m_exportDirectory;
    Trigger m_downloadTrigger = new Trigger();
    String m_downloadUrl;
    FIXGRIDListBinding<ExportGridItem> m_exportGrid = new FIXGRIDListBinding();

    public CCSjrxmlExport() {
        this.addForms();
        this.addDynData();
        this.m_exportDirectory = FileManager.getTempFileDirectory().getAbsolutePath() + "/exportimport";
        this.m_exportDirectory = ValueManager.encodeIntoValidFileName((String)this.m_exportDirectory, (boolean)true);
    }

    public String getRootExpressionUsedInPage() {
        return "#{d.CCSjrxmlExport}";
    }

    public void prepare(IListener listener) {
        this.m_listener = listener;
    }

    public FIXGRIDListBinding<ExportGridItem> getExportGrid() {
        return this.m_exportGrid;
    }

    public String getExportDirectory() {
        return this.m_exportDirectory;
    }

    public void setExportDirectory(String value) {
        this.m_exportDirectory = value;
    }

    public Trigger getDownloadTrigger() {
        return this.m_downloadTrigger;
    }

    public String getDownloadUrl() {
        return this.m_downloadUrl;
    }

    public void setDownloadUrl(String value) {
        this.m_downloadUrl = value;
    }

    public void onExportAction(ActionEvent event) {
        try {
            if (this.m_exportGrid.getSelectedItems().size() == 0) {
                throw new Exception("No export item selected.");
            }
            this.exportSelectedItems();
            Statusbar.outputSuccess((String)SJRXMLLit.lit("msgExportExecuted", new String[0]));
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem during export to " + this.m_exportDirectory, t);
            Statusbar.outputError((String)t.toString(), (String)ValueManager.getStackstraceString((Throwable)t));
        }
    }

    public void onSelectClearAction(ActionEvent event) {
        this.m_exportGrid.deselectCurrentSelection();
    }

    public void onSelectAllAction(ActionEvent event) {
        this.m_exportGrid.deselectCurrentSelection();
        for (ExportGridItem gi : this.m_exportGrid.getItems()) {
            this.m_exportGrid.selectItem((IFIXGRIDItem)gi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDownloadAsZip(ActionEvent event) {
        String tempDir = HttpSessionAccess.getServletTempDirectory() + "/ZIP_" + UniqueIdCreator.createUUID();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (this.m_exportGrid.getSelectedItems().size() == 0) {
                throw new Exception("No export item selected.");
            }
            FileManager.ensureDirectoryExists((String)tempDir);
            tempDir = ValueManager.encodeIntoValidFileName((String)tempDir, (boolean)true);
            ArrayList<File> files = new ArrayList<File>();
            for (ExportGridItem gi : this.m_exportGrid.getSelectedItems()) {
                SjrxmlLogicExportImport.ExportData exp = gi.createExportData();
                FileManager.writeFile((String)(tempDir + exp.getFileName()), (byte[])exp.getContent().getBytes(ValueManager.CHARSET_UTF8), (boolean)true);
                files.add(new File(tempDir + exp.getFileName()));
            }
            new ZipUtil().zipFiles(files, (OutputStream)bos);
            bos.close();
            this.m_downloadUrl = TempFileManager.saveTempFile((String)"export.zip", (String)"application/octet-stream", (byte[])bos.toByteArray());
            this.m_downloadTrigger.trigger();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem during export to " + this.m_exportDirectory, t);
            Statusbar.outputError((String)t.toString(), (String)ValueManager.getStackstraceString((Throwable)t));
        }
        finally {
            try {
                bos.close();
            }
            catch (Throwable files) {}
            FileManager.deleteDirectory((String)tempDir);
        }
    }

    private void exportSelectedItems() {
        for (ExportGridItem gi : this.m_exportGrid.getSelectedItems()) {
            gi.export();
        }
    }

    private void addForms() {
        List<String> categories = SjrxmlPersistence.instance().readCategories();
        for (String category : categories) {
            List<String> formIds = SjrxmlPersistence.instance().readFormsInCategory(category);
            for (String formId : formIds) {
                ExportGridItem gi = new ExportGridItem(formId, TYPE.FORM, category);
                this.m_exportGrid.getItems().add(gi);
            }
        }
    }

    private void addDynData() {
        List<String> dddIds = SjrxmlPersistence.instance().readDynDataIds();
        for (String dddId : dddIds) {
            DataDynDataDefinition dddd = SjrxmlPersistence.instance().readDataDynData(dddId);
            ExportGridItem gi = new ExportGridItem(dddId, TYPE.DYNDATA, dddd.getCategoryId());
            this.m_exportGrid.getItems().add(gi);
        }
    }

    public static interface IListener
    extends Serializable {
    }

    public class ExportGridItem
    extends FIXGRIDItem
    implements Serializable {
        String i_id;
        String i_category;
        TYPE i_type;

        public ExportGridItem(String id, TYPE type, String category) {
            this.i_id = id;
            this.i_type = type;
            this.i_category = category;
        }

        public String getId() {
            return this.i_id;
        }

        public String getType() {
            return this.i_type.toString();
        }

        public String getCategory() {
            return this.i_category;
        }

        public void onRowSelect() {
        }

        public void onRowExecute() {
        }

        public void export() {
            if (this.i_type == TYPE.FORM) {
                SjrxmlLogicExportImport.exportForm(CCSjrxmlExport.this.m_exportDirectory, this.i_id);
                Statusbar.outputSuccess((String)SJRXMLLit.lit("msgExportForm", this.i_id));
            } else if (this.i_type == TYPE.DYNDATA) {
                SjrxmlLogicExportImport.exportDynDataDefinition(CCSjrxmlExport.this.m_exportDirectory, this.i_id);
                Statusbar.outputSuccess((String)SJRXMLLit.lit("msgExportDataDefinition", this.i_id));
            }
        }

        public SjrxmlLogicExportImport.ExportData createExportData() {
            SjrxmlLogicExportImport.ExportData exportData = null;
            if (this.i_type == TYPE.FORM) {
                exportData = SjrxmlLogicExportImport.createFormExportData(this.i_id);
            } else if (this.i_type == TYPE.DYNDATA) {
                exportData = SjrxmlLogicExportImport.createDynDataDefinitionExportData(this.i_id);
            }
            return exportData;
        }

        public void onDownloadClientAction(ActionEvent event) {
            SjrxmlLogicExportImport.ExportData exportData = this.createExportData();
            byte[] bytes = exportData.getContent().getBytes(ValueManager.CHARSET_UTF8);
            CCSjrxmlExport.this.m_downloadUrl = TempFileManager.saveTempFile((String)exportData.getFileName(), (String)"application/octet-stream", (byte[])bytes);
            CCSjrxmlExport.this.m_downloadTrigger.trigger();
        }
    }

    public static enum TYPE {
        FORM,
        DYNDATA,
        PROPERTIES;

    }
}

