/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataDynDataDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataFormDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.ISjrxmlPersistence;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlPersistence;
import org.eclnt.ccee.dyndata.DynDataUtil;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.util.valuemgmt.PojoManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class DataLogic {
    public static List<String> saveDataDynDataDefinition(DataDynDataDefinition dddd, boolean isNew) {
        DataDynDataDefinition ddddExisting;
        List<String> result = DataLogic.checkDataDynDataDefinition(dddd);
        if (isNew && dddd.getId() != null && (ddddExisting = SjrxmlPersistence.instance().readDataDynData(dddd.getId())) != null) {
            result.add("Data definition with id " + dddd.getId() + " already exists.");
        }
        if (result.size() == 0) {
            ISjrxmlPersistence p = SjrxmlPersistence.instance();
            p.saveDataDynData(dddd);
        }
        return result;
    }

    public static String createSaveStamp(DataDynDataDefinition dddd) {
        return PojoManager.calculateHashForPojo((Object)dddd);
    }

    public static String createSaveStamp(DataFormDefinition dfd) {
        return PojoManager.calculateHashForPojo((Object)dfd);
    }

    public static List<String> checkDataDynDataDefinition(DataDynDataDefinition dddd) {
        ArrayList<String> result = new ArrayList<String>();
        if (ValueManager.isEmpty((String)dddd.getId())) {
            result.add("Id is not defined.");
        }
        if (ValueManager.isEmpty((String)dddd.getName())) {
            result.add("Name is not defined.");
        }
        if (ValueManager.isEmpty((String)dddd.getCategoryId())) {
            result.add("Category is not defined.");
        }
        return result;
    }

    public static List<String> saveFormDefinition(DataFormDefinition dfd, boolean asNewForm) {
        ISjrxmlPersistence sjrxmlPersistence = SjrxmlPersistence.instance();
        ArrayList<String> result = new ArrayList<String>();
        if (!DataLogic.isDefined(dfd.getId())) {
            result.add("Id is undefined.");
        }
        if (!DataLogic.isDefined(dfd.getName())) {
            result.add("Name is undefined.");
        }
        if (!DataLogic.isDefined(dfd.getCategoryId())) {
            result.add("Category is undefined.");
        }
        if (!DataLogic.isDefined(dfd.getDddId())) {
            result.add("Data definition is undefined.");
        }
        if (!DataLogic.isDefined(dfd.getXml())) {
            dfd.setXml(SjrxmlPersistence.instance().createEmptySjrxml());
        }
        if (asNewForm && sjrxmlPersistence.readDataFormForEditor(dfd.getId()) != null) {
            result.add("Data definition with same id already exists. Please use different id.");
        }
        if (result.size() == 0) {
            sjrxmlPersistence.saveDataForm(dfd);
            DataDynDataDefinition dataDdd = SjrxmlPersistence.instance().readDataDynData(dfd.getDddId());
            if (dataDdd == null) {
                dataDdd = new DataDynDataDefinition();
                dataDdd.setId(dfd.getDddId());
                dataDdd.setCategoryId(dfd.getCategoryId());
                dataDdd.setName(dfd.getName());
                dataDdd.setXml(SjrxmlPersistence.instance().createEmptyDdd());
            }
            SjrxmlPersistence.instance().saveDataDynData(dataDdd);
        }
        return result;
    }

    public static List<String> getListOfCategories() {
        ArrayList<String> result = new ArrayList<String>();
        ISjrxmlPersistence sjrxmlPersistence = SjrxmlPersistence.instance();
        List<String> cats = sjrxmlPersistence.readCategories();
        result.addAll(cats);
        Collections.sort(result);
        return result;
    }

    public static List<String> getListOfDataDefinitions() {
        ISjrxmlPersistence sjrxmlPersistence = SjrxmlPersistence.instance();
        return sjrxmlPersistence.readDynDataIds();
    }

    public static DataDynDataDefinition createDataDynDataDefintion() {
        DataDynDataDefinition result = new DataDynDataDefinition();
        DynDataDefinition ddd = new DynDataDefinition();
        ddd.setId("TOP");
        result.setXml(DynDataUtil.marshalDynDataDefinition((DynDataDefinition)ddd));
        return result;
    }

    private static boolean isDefined(Object o) {
        if (o == null) {
            return false;
        }
        return o.toString().trim().length() != 0;
    }
}

