/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml.logic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclnt.ccaddons.pbc.simplexml.ENUMDropPosition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.ISjrxmlViewConstants;
import org.eclnt.ccaddons.pbc.sjrxml.logic.XYContentSJRXMLElement;
import org.eclnt.ccaddons.pbc.sjrxml.logic.XYContentSJRXMLElementGrid;
import org.eclnt.ccaddons.pbc.sjrxml.logic.XYContentSJRXMLElementSection;
import org.eclnt.ccaddons.pbc.sjrxml.logic.XYContentSJRXMLElementText;
import org.eclnt.ccaddons.pbc.xyeditor.logic.IXYContent;
import org.eclnt.ccee.simplexml.SimpleXML;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.IConstantsElementNames;
import org.eclnt.ccee.sjrxml.util.AutoCalculationSJRXML;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.ccee.sjrxml.util.ENUMUnit;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.valuemgmt.ValueManager;

public class SjrxmlLogic
implements ISjrxmlViewConstants,
IConstantsElementNames {
    private static final Set<String> TAGS_WITH_XY = new HashSet<String>();
    private static final Set<String> TAGS_WITH_TEXT = new HashSet<String>();
    AutoCalculationSJRXML m_calculationSJRXML;
    XYContentSJRXMLElement m_bodyContent;

    public static SimpleXMLElement readTestXmlElement() {
        String xml = SjrxmlLogic.readTestXml();
        SimpleXMLElement xmlElement = SimpleXML.parseXML((String)xml, (boolean)true);
        return xmlElement;
    }

    public static String readTestXml() {
        String path = SjrxmlLogic.class.getPackage().getName().replace(".", "/") + "/testdata.xml";
        String xml = new ClassloaderReader(true).readUTF8File(path, true);
        return xml;
    }

    public static String readSimpleXmlEditorMetadataXml() {
        String path = "/org/eclnt/ccee/sjrxml/sxmlmetadata.xml";
        return new ClassloaderReader(true).readUTF8File(path, true);
    }

    public static String readTestDynDataDefinitionXml() {
        String path = SjrxmlLogic.class.getPackage().getName().replace(".", "/") + "/testddd.xml";
        String xml = new ClassloaderReader(true).readUTF8File(path, true);
        return xml;
    }

    public List<IXYContent> transferXmlIntoXYContent(SimpleXMLElement xmlElement) {
        this.m_calculationSJRXML = new AutoCalculationSJRXML(xmlElement);
        this.resetInternalCounters();
        ArrayList<IXYContent> result = new ArrayList<IXYContent>();
        for (SimpleXMLElement sub : xmlElement.getSubElements()) {
            XYContentSJRXMLElement xyContent = this.transferXMLElementToXYContent(null, sub, 0, 0);
            result.add(xyContent);
        }
        return result;
    }

    public void updateNewElement(SimpleXMLElement xmlElement) {
        if (xmlElement.getValueMap().containsKey("text") && xmlElement.getValue("text") == null) {
            xmlElement.setValue("text", xmlElement.getName());
        }
        if (TAGS_WITH_TEXT.contains(xmlElement.getName()) && xmlElement.getValue("text") == null) {
            xmlElement.setValue("text", "text");
        }
        if (TAGS_WITH_XY.contains(xmlElement.getName())) {
            if (xmlElement.getValue("x") == null) {
                xmlElement.setValue("x", "0");
            }
            if (xmlElement.getValue("y") == null) {
                xmlElement.setValue("y", "0");
            }
        }
        if (xmlElement.getValue("x") != null && ValueManager.decodeInt((String)xmlElement.getValue("x"), (int)-1) < 0) {
            xmlElement.setValue("x", "0");
        }
        if (xmlElement.getValue("y") != null && ValueManager.decodeInt((String)xmlElement.getValue("y"), (int)-1) < 0) {
            xmlElement.setValue("y", "0");
        }
    }

    public void updateElementCreatedByCopy(SimpleXMLElement createdElement, SimpleXMLElement movedElement, SimpleXMLElement toElement, ENUMDropPosition position) {
        String y;
        if (createdElement.getParent() == movedElement.getParent() && !"gridcol".equals(createdElement.getName()) && (y = createdElement.getValue("y")) != null) {
            ENUMUnit unit = DPICalculation.findUnitFromSize(y);
            int yDots = DPICalculation.calculate72DpiPixelValue(y);
            String yUpdated = DPICalculation.transfer72DpiPixelValueToString(yDots += 20, unit);
            createdElement.setValue("y", yUpdated);
        }
    }

    private XYContentSJRXMLElement transferXMLElementToXYContent(IXYContent xyParent, SimpleXMLElement xmlElement, int paddingLeft, int paddingTop) {
        XYContentSJRXMLElement result = null;
        switch (xmlElement.getName()) {
            case "title": 
            case "header": 
            case "body": 
            case "footer": 
            case "background": 
            case "summary": {
                XYContentSJRXMLElementSection xyc = new XYContentSJRXMLElementSection(this.m_calculationSJRXML, xyParent, xmlElement);
                xyc.setZ(1);
                xyc.setFixSizeAndPosition(true);
                xyc.setSelectionEnabled(true);
                xyc.setText(xmlElement.getName());
                if ("body".equals(xmlElement.getName())) {
                    this.m_bodyContent = xyc;
                }
                result = xyc;
                break;
            }
            case "band": {
                XYContentSJRXMLElementSection xyc = new XYContentSJRXMLElementSection(this.m_calculationSJRXML, xyParent, xmlElement);
                xyc.setZ(2);
                xyc.setFixSizeAndPosition(false);
                xyc.setSelectionEnabled(true);
                xyc.setText(xmlElement.getName());
                result = xyc;
                break;
            }
            case "grid": {
                XYContentSJRXMLElementGrid xyc = new XYContentSJRXMLElementGrid(this.m_calculationSJRXML, xyParent, xmlElement, true);
                xyc.setZ(3);
                xyc.setSelectionEnabled(true);
                xyc.setFixSizeAndPosition(false);
                result = xyc;
                break;
            }
            case "text": {
                XYContentSJRXMLElementText xyc = new XYContentSJRXMLElementText(this.m_calculationSJRXML, xyParent, xmlElement);
                xyc.setSelectionEnabled(true);
                result = xyc;
                break;
            }
            default: {
                XYContentSJRXMLElement xyc = new XYContentSJRXMLElement(this.m_calculationSJRXML, xyParent, xmlElement, true);
                xyc.setSelectionEnabled(true);
                result = xyc;
                break;
            }
        }
        this.drillDownnXMLElementToXYContent(result, xmlElement);
        result.postProcessChildrenAfterDrillDown();
        return result;
    }

    public void drillDownnXMLElementToXYContent(XYContentSJRXMLElement result, SimpleXMLElement xmlElement) {
        if (!result.getTakeOverDrillDown()) {
            for (SimpleXMLElement sub : xmlElement.getSubElements()) {
                this.transferXMLElementToXYContent(result, sub, 0, 0);
            }
        } else {
            result.drillDownXMLElementToXYContent(this);
        }
    }

    private void resetInternalCounters() {
    }

    public static SimpleXMLElement findSubElement(SimpleXMLElement parent, String tagName) {
        List subs = parent.getSubElements();
        for (SimpleXMLElement sub : subs) {
            if (!ValueManager.checkIfStringsAreEqual((String)tagName, (String)sub.getName())) continue;
            return sub;
        }
        return null;
    }

    static {
        TAGS_WITH_XY.add("barcode");
        TAGS_WITH_XY.add("frame");
        TAGS_WITH_XY.add("grid");
        TAGS_WITH_XY.add("image");
        TAGS_WITH_XY.add("qrcode");
        TAGS_WITH_XY.add("stack");
        TAGS_WITH_XY.add("text");
        TAGS_WITH_TEXT.add("barcode");
        TAGS_WITH_TEXT.add("qrcode");
        TAGS_WITH_TEXT.add("text");
    }
}

