/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataDynDataDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.ISjrxmlPersistence;
import org.eclnt.util.file.ClassloaderReader;

public abstract class SjrxmlPersistenceBase
implements ISjrxmlPersistence {
    @Override
    public List<DataDynDataDefinition> readDataDynDataDefinitions() {
        List<String> ids = this.readDynDataIds();
        ArrayList<DataDynDataDefinition> result = new ArrayList<DataDynDataDefinition>();
        for (String id : ids) {
            DataDynDataDefinition dddd = this.readDataDynData(id);
            result.add(dddd);
        }
        Collections.sort(result, new Comparator<DataDynDataDefinition>(){

            @Override
            public int compare(DataDynDataDefinition o1, DataDynDataDefinition o2) {
                String s1 = o1.getId();
                String s2 = o2.getId();
                if (s1 == null) {
                    s1 = "";
                }
                if (s2 == null) {
                    s2 = "";
                }
                return s1.compareTo(s2);
            }
        });
        return result;
    }

    @Override
    public String createEmptySjrxml() {
        String path = SjrxmlPersistenceBase.class.getPackage().getName().replace(".", "/");
        String sjrxml = new ClassloaderReader(true).readUTF8File(path + "/template_form.xml", true);
        return sjrxml;
    }

    @Override
    public String createEmptyDdd() {
        String path = SjrxmlPersistenceBase.class.getPackage().getName().replace(".", "/");
        String dddxml = new ClassloaderReader(true).readUTF8File(path + "/template_ddd.xml", true);
        return dddxml;
    }
}

