/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml.logic.processing;

import java.io.File;
import java.util.List;
import org.eclnt.ccaddons.pbc.sjrxml.logic.processing.PDFProcessorXML;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class PDFDirectoryScanner
implements ICCEEConstants {
    static ScannerThread s_thread;

    public static void start(String directory) {
        if (s_thread != null && !PDFDirectoryScanner.s_thread.i_stopped) {
            PDFDirectoryScanner.s_thread.i_stopped = true;
        }
        s_thread = new ScannerThread(directory);
        s_thread.start();
    }

    public static void stop() {
        if (s_thread != null) {
            PDFDirectoryScanner.s_thread.i_stopped = true;
            s_thread = null;
        }
    }

    public static void processOneScan(String directory) {
        new ScannerThread(directory).run();
    }

    public static class ScannerThread
    extends Thread {
        String i_directory;
        boolean i_stopped = false;

        public ScannerThread(String directory) {
            this.i_directory = directory;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (this.i_stopped) {
                            return;
                        }
                        AppLog.L.log(ICCEEConstants.LL_INF, "PDFDirectoryScanner: waiting...");
                        Thread.sleep(5000L);
                        if (this.i_stopped) {
                            return;
                        }
                        this.processScan();
                    }
                }
                catch (Throwable t) {
                    AppLog.L.log(ICCEEConstants.LL_ERR, "Problem processing PDF: " + t);
                    continue;
                }
                break;
            }
        }

        private void processScan() {
            AppLog.L.log(ICCEEConstants.LL_INF, "PDFDirectoryScanner: processing files of directory: " + this.i_directory);
            List files = FileManager.getFilesOfDirectory((String)this.i_directory);
            for (File file : files) {
                if (this.i_stopped) {
                    return;
                }
                String fileName = file.getAbsolutePath();
                if (!fileName.endsWith(".new.xml")) continue;
                AppLog.L.log(ICCEEConstants.LL_INF, "PDFDirectoryScanner: processing file: " + fileName);
                try {
                    String xml = FileManager.readUTF8File((String)file.getAbsolutePath(), (boolean)true);
                    byte[] pdf = PDFProcessorXML.instance().processPDFOrder(xml);
                    String pdfFileName = fileName.replace(".new.xml", ".pdf");
                    FileManager.writeFile((String)pdfFileName, (byte[])pdf, (boolean)true);
                    String processedFileName = fileName.replace(".new.xml", ".processed.xml");
                    FileManager.copyFile((String)fileName, (String)processedFileName, (boolean)true);
                    FileManager.deleteFile((String)fileName);
                    AppLog.L.log(ICCEEConstants.LL_INF, "PDFDirectoryScanner: processing file: success: " + fileName);
                }
                catch (Throwable t) {
                    AppLog.L.log(ICCEEConstants.LL_INF, "PDFDirectoryScanner: processing file: error: " + t.toString());
                    String s = ValueManager.getStackstraceString((Throwable)t);
                    String errorFileName = fileName.replace(".new.xml", ".error." + System.currentTimeMillis() + ".txt");
                    FileManager.writeUTF8File((String)errorFileName, (String)s, (boolean)true);
                }
            }
        }
    }
}

