/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml.logic.processing;

import java.util.HashMap;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlPersistence;
import org.eclnt.ccee.dyndata.DynDataMap;
import org.eclnt.ccee.dyndata.DynDataReader;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.DynDataUtil;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.ccee.simplexml.SimpleXML;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.JRXMLGeneratorLogic;

public class PDFProcessorXML {
    static PDFProcessorXML s_instance = new PDFProcessorXML();

    public static PDFProcessorXML instance() {
        return s_instance;
    }

    public byte[] processPDFOrder(String orderXml) {
        try {
            SimpleXMLElement order = SimpleXML.parseXML((String)orderXml);
            String formId = order.getValue("formId");
            SimpleXMLElement data = (SimpleXMLElement)order.getSubElements().get(0);
            return this.createPDF(data, formId);
        }
        catch (Throwable t) {
            throw new Error("Problem processing XML order: " + orderXml, t);
        }
    }

    public byte[] createPDF(SimpleXMLElement data, String formId) {
        try {
            HashMap m = new HashMap();
            DynDataUtil.transferSimpleXMLElementToMap(m, (SimpleXMLElement)data);
            DynDataDefinition ddd = SjrxmlPersistence.instance().readDynDataForFormForRuntime(formId);
            DynDataMap dynDataMap = new DynDataReader(new DynDataReaderContext()).createDynDataMapFromMap(ddd, m);
            String sjrxml = SjrxmlPersistence.instance().readDataFormForRuntime(formId).getXml();
            JRXMLGeneratorLogic logic = new JRXMLGeneratorLogic();
            byte[] result = logic.exportPdfBytes(sjrxml.hashCode() + "", sjrxml, dynDataMap);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Error processing: " + formId, t);
        }
    }
}

