/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.pdfbysjrxml.comm;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.json.jackson.JSONUtil;
import org.eclnt.ccee.pdfbysjrxml.comm.data.PDFProcessingInvoke;
import org.eclnt.ccee.pdfbysjrxml.comm.data.PDFProcessingResult;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.file.StreamUtil;
import org.eclnt.util.valuemgmt.PojoManager;

public class PDFTestClientCW {
    public static void main(String[] args) {
        try {
            String json = PDFTestClientCW.buildRequestBody();
            URL url = new URL("http://localhost:50000/jKarat-web/cccreatepdf");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.getOutputStream().write(json.getBytes("UTF-8"));
            InputStream is = con.getInputStream();
            byte[] isBytes = StreamUtil.transferStreamContentIntoBytes((InputStream)is);
            String responseString = new String(isBytes, "UTF-8");
            PDFProcessingResult result = (PDFProcessingResult)JSONUtil.unmarshalSimpleObject((String)responseString, PDFProcessingResult.class);
            FileManager.writeFile((String)"c:\\temp\\aaaaaaaaaapdfCW1.pdf", (byte[])result.getContent(), (boolean)true);
            System.out.println("FINISHED!");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String buildRequestBody() {
        PDFProcessingInvoke pc = new PDFProcessingInvoke();
        pc.setFormId("CWTEST");
        pc.setFormLanguage("de");
        pc.setFormCountry("DE");
        Map<String, Object> m = PDFTestClientCW.buildBodyMap();
        pc.setData(m);
        String s = JSONUtil.marshalSimpleObject((Object)pc);
        return s;
    }

    private static Map<String, Object> buildBodyMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Map> envMaps = new ArrayList<Map>();
        map.put("ENVIRONMENTS", envMaps);
        for (int i = 0; i < 3; ++i) {
            JKEnvironment env = new JKEnvironment();
            env.setName("Env " + i);
            env.setEnvironmentAdministorator("Sven Doberanzke");
            Map envMap = PojoManager.transferPojoIntoMap((Object)env);
            envMaps.add(envMap);
            ArrayList<Map> systemMaps = new ArrayList<Map>();
            envMap.put("SYSTEMS", systemMaps);
            for (int j = 0; j < 5; ++j) {
                JKSystem sys = new JKSystem();
                sys.setName("Syst\u00e4m " + i + ", " + j);
                sys.setVersion(j);
                sys.setCustomerId(12412);
                Map sysMap = PojoManager.transferPojoIntoMap((Object)sys);
                systemMaps.add(sysMap);
            }
        }
        String json = JSONUtil.marshalMap(map);
        System.out.println(json);
        return map;
    }

    public static class JKEnvironment {
        String m_name;
        String m_environmentAdministorator;
        List<JKSystem> m_systems = new ArrayList<JKSystem>();

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public List<JKSystem> getSystems() {
            return this.m_systems;
        }

        public void setSystems(List<JKSystem> systems) {
            this.m_systems = systems;
        }

        public String getEnvironmentAdministorator() {
            return this.m_environmentAdministorator;
        }

        public void setEnvironmentAdministorator(String environmentAdministorator) {
            this.m_environmentAdministorator = environmentAdministorator;
        }
    }

    public static class JKSystem {
        String m_name;
        String m_adminEmail;
        int m_version;
        int m_customerId;

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public String getAdminEmail() {
            return this.m_adminEmail;
        }

        public void setAdminEmail(String adminEmail) {
            this.m_adminEmail = adminEmail;
        }

        public int getVersion() {
            return this.m_version;
        }

        public void setVersion(int version) {
            this.m_version = version;
        }

        public int getCustomerId() {
            return this.m_customerId;
        }

        public void setCustomerId(int customerId) {
            this.m_customerId = customerId;
        }
    }
}

