/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.checking;

import org.eclnt.ccee.simplexml.SimpleXML;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.checking.CheckerBase;
import org.eclnt.ccee.sjrxml.checking.SJRXMLCheckerResult;
import org.eclnt.ccee.sjrxml.util.AutoCalculationSJRXML;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class SJRXMLChecker
extends CheckerBase {
    public SJRXMLCheckerResult checkXml(String xml) {
        SJRXMLCheckerResult result = new SJRXMLCheckerResult();
        SimpleXMLElement top = SimpleXML.parseXML((String)xml);
        this.checkXML(top, result, new AutoCalculationSJRXML(top));
        return result;
    }

    public SJRXMLCheckerResult checkXml(SimpleXMLElement top) {
        SJRXMLCheckerResult result = new SJRXMLCheckerResult();
        this.checkXML(top, result, new AutoCalculationSJRXML(top));
        return result;
    }

    private void checkXML(SimpleXMLElement xmlElement, SJRXMLCheckerResult result, AutoCalculationSJRXML autoCalculation) {
        this.checkXMLElementItself(xmlElement, result, autoCalculation);
        for (SimpleXMLElement child : xmlElement.getSubElements()) {
            this.checkXML(child, result, autoCalculation);
        }
    }

    private void checkXMLElementItself(SimpleXMLElement xmlElement, SJRXMLCheckerResult result, AutoCalculationSJRXML autoCalculation) {
        try {
            String packageName = this.getClass().getPackage().getName() + ".impl";
            String className = packageName + "." + ValueManager.toUpperCaseId((String)xmlElement.getName()) + "Checker";
            Class<?> c = Class.forName(className, true, HotDeployManager.currentClassLoader());
            CheckerBase checkerBase = (CheckerBase)c.newInstance();
            checkerBase.checkElement(xmlElement, result, autoCalculation);
        }
        catch (Throwable t) {
            result.addResultItem(0, "Inner problem: " + t.toString(), "INNER_PROBLEM_CHECKER", "", xmlElement, null);
            CLog.L.log(CLog.LL_INF, "Problem checking element: " + t);
        }
    }

    @Override
    public void checkElementExecute(SimpleXMLElement xmlElement, SJRXMLCheckerResult result, AutoCalculationSJRXML autoCalculation) {
    }
}

