/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.parsing.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.parsing.JRXMLContext;
import org.eclnt.ccee.sjrxml.parsing.StylesGenerator;
import org.eclnt.ccee.sjrxml.parsing.elements.BaseElement;
import org.eclnt.ccee.sjrxml.parsing.elements.CalculatingAttributesUtil;
import org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil;
import org.eclnt.ccee.sjrxml.parsing.elements.GRIDFOOTERElement;
import org.eclnt.ccee.sjrxml.parsing.elements.GRIDHEADERElement;
import org.eclnt.ccee.sjrxml.util.AutoCalculationGeneral;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.ccee.sjrxml.util.IPixelPositionAccess;
import org.eclnt.ccee.sjrxml.util.PaddingCalculation;
import org.eclnt.util.valuemgmt.ValueManager;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class GRIDElement
extends BaseElement {
    @Override
    public boolean validate() {
        return false;
    }

    @Override
    public void fillAttribute(SimpleXMLElement element, String attrName) {
        if ("height".equals(attrName)) {
            String value = element.getValue("height");
            if (value == null || value.equals("auto")) {
                int v1 = ValueManager.decodeInt((String)this.getAttributes().get("columnsCellHeight"), (int)0);
                int v2 = ValueManager.decodeInt((String)this.getAttributes().get("columnsHeaderHeight"), (int)0);
                int all = PaddingCalculation.increaseHeightByPadding(v1 + v2, element.getValue("padding"));
                this.getAttributes().put("height", "" + all);
            } else {
                int pixelValue = DPICalculation.calculate72DpiPixelValue(element.getValue("height"));
                this.getAttributes().put("height", "" + pixelValue);
            }
        } else if ("columnsCellHeight".equals(attrName)) {
            this.getAttributes().put(attrName, element.getValue(attrName));
            List<IPixelPositionAccess> ppas = this.buildChildrenListForContentSizing();
            int pixelsInt = AutoCalculationGeneral.calculatePixelHeightFromElement(this.m_elementName, attrName, this.getAttributes(), ppas, 0);
            String pixels = String.valueOf(pixelsInt);
            this.getAttributes().put(attrName, pixels);
        } else if ("columnsHeaderHeight".equals(attrName)) {
            this.getAttributes().put(attrName, element.getValue(attrName));
            List<IPixelPositionAccess> ppas = this.buildChildrenListForHeadlineSizing();
            int pixelsInt = AutoCalculationGeneral.calculatePixelHeightFromElement(this.m_elementName, attrName, this.getAttributes(), ppas, 0);
            String pixels = String.valueOf(pixelsInt);
            this.getAttributes().put(attrName, pixels);
        } else {
            super.fillAttribute(element, attrName);
        }
    }

    @Override
    protected Set<String> findAttributesWithAutoCalculation() {
        Set<String> result = super.findAttributesWithAutoCalculation();
        result.add("columnsCellHeight");
        result.add("columnsHeaderHeight");
        return result;
    }

    @Override
    protected List<IPixelPositionAccess> buildChildrenListForSizing() {
        return this.buildChildrenListForHeadlineSizing();
    }

    protected List<IPixelPositionAccess> buildChildrenListForHeadlineSizing() {
        ArrayList<IPixelPositionAccess> ppas = new ArrayList<IPixelPositionAccess>();
        for (BaseElement ppa : this.getChildren()) {
            if (!"gridcol".equals(ppa.getElementName())) continue;
            ppas.add(ppa);
        }
        return ppas;
    }

    protected List<IPixelPositionAccess> buildChildrenListForContentSizing() {
        ArrayList<IPixelPositionAccess> ppas = new ArrayList<IPixelPositionAccess>();
        for (final BaseElement ppa : this.getChildren()) {
            if (!"gridcol".equals(ppa.getElementName())) continue;
            ppas.add(new IPixelPositionAccess(){

                @Override
                public int getY() {
                    return 0;
                }

                @Override
                public int getX() {
                    return 0;
                }

                @Override
                public int getWidth() {
                    return ppa.getWidth();
                }

                @Override
                public int getHeight() {
                    String s = ppa.getAttributes().get("cellHeight");
                    return ValueManager.decodeInt((String)s, (int)-1);
                }
            });
        }
        return ppas;
    }

    @Override
    public Element generateJRXMLElement(JRXMLContext context) {
        String methodName;
        String data;
        String refclass = (String)this.m_attributes.get("refclass");
        if (refclass == null) {
            refclass = Map.class.getName();
        }
        if ((data = (String)this.m_attributes.get("data")) == null) {
            throw new Error("The attribute \"data\" is not defined. Please check your print form definition.");
        }
        data = ExpressionUtil.isolateVariablesFromExpression(data);
        String[] dataValues = data.split("\\.");
        String dsName = "";
        if (refclass.equals(Map.class.getName())) {
            dsName = dataValues[1] + "DataSet";
            context.addSubDataSet(dsName, refclass);
        } else {
            dsName = dataValues[1] + "DataSet";
            context.addSubDataSet(dsName, refclass);
        }
        Element grid = new Element("componentElement");
        Element reportElement = new Element("reportElement");
        reportElement.setAttribute("mode", "Transparent");
        reportElement.setAttribute(new Attribute("x", (String)this.m_attributes.get("x")));
        reportElement.setAttribute(new Attribute("y", (String)this.m_attributes.get("y")));
        reportElement.setAttribute(new Attribute("width", (String)this.m_attributes.get("width")));
        reportElement.setAttribute(new Attribute("height", (String)this.m_attributes.get("height")));
        if (this.m_attributes.containsKey("positionType")) {
            reportElement.setAttribute("positionType", (String)this.m_attributes.get("positionType"));
        } else {
            reportElement.setAttribute("positionType", "Float");
        }
        if (this.m_attributes.get("border") != null) {
            Map borderAttributes = ValueManager.decodeComplexValue((String)((String)this.m_attributes.get("border")));
            String styleName = new StylesGenerator().createBorderStyleAndReturnName("gridBorderStyle", context, this.m_attributes, borderAttributes);
            reportElement.setAttribute(new Attribute("style", styleName));
        }
        if (this.m_attributes.containsKey("rendered")) {
            Element printWhenExpression = new Element("printWhenExpression");
            printWhenExpression.setContent((Content)new CDATA(this.calculateRenderedAttributeSJRXMLValue(context)));
            reportElement.addContent((Content)printWhenExpression);
        }
        grid.addContent((Content)reportElement);
        Namespace ns = Namespace.getNamespace((String)"jr", (String)"http://jasperreports.sourceforge.net/jasperreports/components");
        Element jrTable = new Element("table", ns);
        Element datasetRun = new Element("datasetRun");
        datasetRun.setAttribute(new Attribute("subDataset", dsName));
        Element dataSourceExpression = new Element("dataSourceExpression");
        String[] values = data.split("\\.");
        if (refclass.equals(Map.class.getName())) {
            methodName = "get(\"" + values[1] + "\")";
            dataSourceExpression.setContent((Content)new CDATA("new net.sf.jasperreports.engine.data.JRMapCollectionDataSource((java.util.List)$F{data}." + methodName + ")"));
        } else {
            methodName = "get" + StringUtils.capitalize((String)(values[1] + "()"));
            dataSourceExpression.setContent((Content)new CDATA("new net.sf.jasperreports.engine.data.JRBeanCollectionDataSource($F{data}." + methodName + ")"));
        }
        datasetRun.addContent((Content)dataSourceExpression);
        jrTable.addContent((Content)datasetRun);
        grid.addContent((Content)jrTable);
        Element jrColumnGroup = new Element("columnGroup", ns);
        for (BaseElement gridElement : this.getChildren()) {
            if (gridElement.getAttributes().get("height") == null) continue;
            if (gridElement instanceof GRIDFOOTERElement && !this.getChildren().iterator().next().getElementName().equals("gridheader")) {
                jrColumnGroup.addContent(0, (Content)gridElement.generateJRXMLElement(context));
                continue;
            }
            if (gridElement instanceof GRIDFOOTERElement && this.getChildren().iterator().next().getElementName().equals("gridheader")) {
                jrColumnGroup.addContent(1, (Content)gridElement.generateJRXMLElement(context));
                continue;
            }
            if (gridElement instanceof GRIDHEADERElement) {
                jrColumnGroup.addContent(0, (Content)gridElement.generateJRXMLElement(context));
                continue;
            }
            jrColumnGroup.addContent((Content)gridElement.generateJRXMLElement(context));
        }
        CalculatingAttributesUtil.calculateElementWidthAndEditIfNeeded(jrColumnGroup, this.m_attributes);
        CalculatingAttributesUtil.calculateElementWidthAndEditIfNeeded(reportElement, this.m_attributes);
        jrTable.addContent((Content)jrColumnGroup);
        return grid;
    }
}

