/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.parsing.elements;

import java.util.HashMap;
import java.util.Map;
import org.eclnt.ccee.sjrxml.IConstantsAttributeNames;
import org.eclnt.ccee.sjrxml.parsing.JRXMLContext;
import org.eclnt.ccee.sjrxml.parsing.ParserUtil;
import org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil;
import org.eclnt.ccee.sjrxml.util.conversions.FontConversion;
import org.eclnt.util.valuemgmt.ValueManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class PropertyExpressionUtil
implements IConstantsAttributeNames {
    private static String CONVERSION_CLASS = "org.eclnt.ccee.sjrxml.util.conversions.FontConversion";
    private static Map<String, String> m_validPropertyExpressionNames = new HashMap<String, String>();

    public static boolean addPropertyExpressionIfNeeded(Element element, Attribute attribute, JRXMLContext context) {
        Element reportElement = element.getChild("reportElement");
        Element textElement = element.getChild("textElement");
        Element fontElement = new Element("font");
        String attributeValue = attribute.getValue();
        if (ExpressionUtil.checkIfStraightExpression(attributeValue)) {
            String propertyExpressionName = m_validPropertyExpressionNames.get(attribute.getName());
            if (!ParserUtil.isEmpty(propertyExpressionName)) {
                Element propertyExpression = new Element("propertyExpression");
                propertyExpression.setAttribute("name", propertyExpressionName);
                propertyExpression.addContent(ExpressionUtil.parseAndBuildExpression(context, attribute.getValue()));
                if ("reportElement".equals(element.getName())) {
                    element.addContent((Content)propertyExpression);
                } else if (element.getChild("reportElement") != null) {
                    element.getChild("reportElement").addContent((Content)propertyExpression);
                }
            }
            return true;
        }
        if ("font".equals(attribute.getName()) && ExpressionUtil.checkIfStringContainsExpression(attributeValue, true)) {
            String result;
            String propertyExpressionName;
            Element propertyExpression;
            String propertyExpressionName2;
            Map fontAttributes = ValueManager.decodeComplexValue((String)attributeValue);
            if (fontAttributes.containsKey("family")) {
                String fontName = (String)fontAttributes.get("family");
                propertyExpressionName2 = m_validPropertyExpressionNames.get("family");
                if (!ParserUtil.isEmpty(propertyExpressionName2)) {
                    propertyExpression = new Element("propertyExpression");
                    propertyExpression.setAttribute("name", propertyExpressionName2);
                    if (ExpressionUtil.checkIfStraightExpression(fontName)) {
                        propertyExpression.addContent(ExpressionUtil.parseAndBuildExpression(context, fontName));
                        reportElement.addContent((Content)propertyExpression);
                    } else {
                        fontElement.setAttribute("fontName", fontName);
                    }
                }
            }
            if (fontAttributes.containsKey("size")) {
                String fontSize = (String)fontAttributes.get("size");
                propertyExpressionName2 = m_validPropertyExpressionNames.get("size");
                if (!ParserUtil.isEmpty(propertyExpressionName2)) {
                    propertyExpression = new Element("propertyExpression");
                    propertyExpression.setAttribute("name", propertyExpressionName2);
                    if (ExpressionUtil.checkIfStraightExpression(fontSize)) {
                        propertyExpression.addContent(ExpressionUtil.parseAndBuildExpression(context, fontSize));
                        reportElement.addContent((Content)propertyExpression);
                    } else {
                        fontElement.setAttribute("size", fontSize);
                    }
                }
            }
            if (fontAttributes.containsKey("weight") && !ParserUtil.isEmpty(propertyExpressionName = m_validPropertyExpressionNames.get("weight"))) {
                String fontWeight = (String)fontAttributes.get("weight");
                propertyExpression = new Element("propertyExpression");
                propertyExpression.setAttribute("name", propertyExpressionName);
                if (ExpressionUtil.checkIfStraightExpression(fontWeight)) {
                    propertyExpression.addContent(CONVERSION_CLASS + ".convertFontWeight((String)" + ExpressionUtil.parseAndBuildExpression(context, fontWeight) + ")");
                    reportElement.addContent((Content)propertyExpression);
                } else {
                    result = FontConversion.convertFontWeight(fontWeight);
                    fontElement.setAttribute("isBold", result);
                }
            }
            if (fontAttributes.containsKey("posture") && !ParserUtil.isEmpty(propertyExpressionName = m_validPropertyExpressionNames.get("posture"))) {
                String fontPosture = (String)fontAttributes.get("posture");
                propertyExpression = new Element("propertyExpression");
                propertyExpression.setAttribute("name", propertyExpressionName);
                if (ExpressionUtil.checkIfStraightExpression(fontPosture)) {
                    propertyExpression.addContent(CONVERSION_CLASS + ".convertFontPosture((String)" + ExpressionUtil.parseAndBuildExpression(context, fontPosture) + ")");
                    reportElement.addContent((Content)propertyExpression);
                } else {
                    result = FontConversion.convertFontPosture(fontPosture);
                    fontElement.setAttribute("isItalic", result);
                }
            }
            if (fontAttributes.containsKey("underline") && !ParserUtil.isEmpty(propertyExpressionName = m_validPropertyExpressionNames.get("underline"))) {
                String fontUnderline = (String)fontAttributes.get("underline");
                propertyExpression = new Element("propertyExpression");
                propertyExpression.setAttribute("name", propertyExpressionName);
                if (ExpressionUtil.checkIfStraightExpression(fontUnderline)) {
                    propertyExpression.addContent("(String)" + ExpressionUtil.parseAndBuildExpression(context, fontUnderline));
                    reportElement.addContent((Content)propertyExpression);
                } else if ("true".equals(fontUnderline)) {
                    fontElement.setAttribute("isUnderline", "true");
                } else {
                    fontElement.setAttribute("isUnderline", "false");
                }
            }
            if (fontAttributes.containsKey("strikethrough") && !ParserUtil.isEmpty(propertyExpressionName = m_validPropertyExpressionNames.get("strikethrough"))) {
                String fontStrikeThrough = (String)fontAttributes.get("strikethrough");
                propertyExpression = new Element("propertyExpression");
                propertyExpression.setAttribute("name", propertyExpressionName);
                if (ExpressionUtil.checkIfStraightExpression(fontStrikeThrough)) {
                    propertyExpression.addContent("(String)" + ExpressionUtil.parseAndBuildExpression(context, fontStrikeThrough));
                    reportElement.addContent((Content)propertyExpression);
                } else if ("true".equals(fontStrikeThrough)) {
                    fontElement.setAttribute("isStrikeThrough", "true");
                } else {
                    fontElement.setAttribute("isStrikeThrough", "false");
                }
            }
            if (!fontElement.getAttributes().isEmpty()) {
                textElement.addContent((Content)fontElement);
            }
            return true;
        }
        return false;
    }

    static {
        m_validPropertyExpressionNames.put("backcolor", "net.sf.jasperreports.style.backcolor");
        m_validPropertyExpressionNames.put("forecolor", "net.sf.jasperreports.style.forecolor");
        m_validPropertyExpressionNames.put("family", "net.sf.jasperreports.style.fontName");
        m_validPropertyExpressionNames.put("size", "net.sf.jasperreports.style.fontSize");
        m_validPropertyExpressionNames.put("weight", "net.sf.jasperreports.style.isBold");
        m_validPropertyExpressionNames.put("posture", "net.sf.jasperreports.style.isItalic");
        m_validPropertyExpressionNames.put("underline", "net.sf.jasperreports.style.isUnderline");
        m_validPropertyExpressionNames.put("strikethrough", "net.sf.jasperreports.style.isStrikeThrough");
    }
}

