/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.parsing.elements;

import java.awt.Font;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.parsing.JRXMLContext;
import org.eclnt.ccee.sjrxml.parsing.ParserUtil;
import org.eclnt.ccee.sjrxml.parsing.StylesGenerator;
import org.eclnt.ccee.sjrxml.parsing.elements.BaseElement;
import org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil;
import org.eclnt.ccee.sjrxml.parsing.elements.PropertyExpressionUtil;
import org.eclnt.ccee.sjrxml.util.AutoCalculationFont;
import org.eclnt.ccee.sjrxml.util.Inset;
import org.eclnt.util.valuemgmt.ValueManager;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class TEXTElement
extends BaseElement {
    @Override
    public void fillAttribute(SimpleXMLElement element, String attrName) {
        if ("height".equals(attrName)) {
            this.getAttributes().put(attrName, element.getValue(attrName));
            int pixelsInt = AutoCalculationFont.calculatePixelHeightFromElement(this.getAttributes());
            String pixels = String.valueOf(pixelsInt);
            this.getAttributes().put(attrName, pixels);
        } else {
            super.fillAttribute(element, attrName);
        }
    }

    @Override
    public boolean validate() {
        return false;
    }

    @Override
    public Element generateJRXMLElement(JRXMLContext context) {
        Element reportElement = new Element("reportElement");
        this.fillReportElementAttributes(reportElement, context);
        if (this.m_attributes.get("forecolor") != null) {
            this.setAttributeinJDOMElement(reportElement, "forecolor", context);
        }
        if (this.m_attributes.get("backcolor") != null) {
            this.setAttributeinJDOMElement(reportElement, "backcolor", context);
            reportElement.setAttribute("mode", "Opaque");
        } else {
            reportElement.setAttribute("mode", "Transparent");
        }
        if (this.m_attributes.get("stretchType") != null) {
            reportElement.setAttribute("stretchType", (String)this.m_attributes.get("stretchType"));
        }
        String textValue = "";
        if (this.m_attributes.get("text") != null) {
            textValue = (String)this.m_attributes.get("text");
        }
        String hyperlinkUrlValue = null;
        if (this.m_attributes.get("hyperlinkUrl") != null) {
            hyperlinkUrlValue = (String)this.m_attributes.get("hyperlinkUrl");
        }
        Element textField = new Element("textField");
        Element textFieldExpression = new Element("textFieldExpression");
        this.buildTextField(context, reportElement, textValue, textField, textFieldExpression, hyperlinkUrlValue);
        return textField;
    }

    private void buildTextField(JRXMLContext context, Element reportElement, String textValue, Element textField, Element textFieldExpression, String hyperlinkUrl) {
        String variableName;
        String fontExpression;
        String textExpression;
        String fontDef = (String)this.m_attributes.get("font");
        if (ExpressionUtil.checkIfStringContainsExpression(textValue, true)) {
            textExpression = ExpressionUtil.parseAndBuildStaticTextCombinedWithExpression(context, textValue);
            if (ExpressionUtil.checkIfStraightExpression(fontDef)) {
                fontExpression = ExpressionUtil.parseAndBuildExpression(context, fontDef);
                textFieldExpression.setContent((Content)new CDATA("org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil.buildStyledText(" + textExpression + "," + fontExpression + ")"));
                this.m_attributes.put("markup", "styled");
            } else {
                textFieldExpression.setContent((Content)new CDATA(textExpression));
                if (textExpression.contains("$V{")) {
                    textField.setAttribute(new Attribute("evaluationTime", "Master"));
                }
            }
        } else if (ExpressionUtil.checkIfStraightExpression(textValue)) {
            textExpression = ExpressionUtil.parseAndBuildExpression(context, textValue);
            if (ExpressionUtil.checkIfStraightExpression(fontDef)) {
                fontExpression = ExpressionUtil.parseAndBuildExpression(context, fontDef);
                textFieldExpression.setContent((Content)new CDATA("org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil.buildStyledText(" + textExpression + "," + fontExpression + ")"));
            } else {
                textFieldExpression.setContent((Content)new CDATA(textExpression));
            }
        } else if (ExpressionUtil.checkIfPageExpression(textValue)) {
            textExpression = ExpressionUtil.parseAndBuildPageExpression(context, textValue, textField, this.m_attributes);
            if (ExpressionUtil.checkIfStraightExpression(fontDef)) {
                textFieldExpression.setContent((Content)new CDATA("org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil.buildStyledText(" + textExpression + ", " + fontDef + ")"));
            } else {
                textFieldExpression.setContent((Content)new CDATA(textExpression));
            }
        } else if (ExpressionUtil.checkIfStraightExpression(fontDef)) {
            String fontExpression2 = ExpressionUtil.parseAndBuildExpression(context, fontDef);
            textFieldExpression.setContent((Content)new CDATA("org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil.buildStyledText(\"" + textValue + "\", " + fontExpression2 + ")"));
        } else {
            textFieldExpression.setContent((Content)new CDATA("\"" + textValue + "\""));
        }
        if (ExpressionUtil.checkIfVariableExpression(textValue)) {
            variableName = ExpressionUtil.applyVariableInGridColContext(context, textValue);
            textFieldExpression.setContent((Content)new CDATA(variableName));
        }
        if (this.m_attributes.get("decimalformat") != null && ExpressionUtil.checkIfVariableExpression(textValue)) {
            variableName = "$V{" + StringUtils.substringBetween((String)textValue, (String)",", (String)"}").trim() + "}";
            textFieldExpression.setContent((Content)new CDATA("new java.text.DecimalFormat(\"" + (String)this.m_attributes.get("decimalformat") + "\").format(" + variableName + ")"));
        }
        textField.addContent((Content)reportElement);
        if (this.m_attributes.get("padding") != null) {
            String padding = Inset.convertInsetIntoPixelInset((String)this.m_attributes.get("padding"));
            textField.addContent((Content)new StylesGenerator().createPaddingBoxElement(padding));
        }
        this.parseAndBuildFontExpression(context, reportElement, textField);
        if (this.m_attributes.get("evaluationTime") != null) {
            textField.setAttribute("evaluationTime", (String)this.m_attributes.get("evaluationTime"));
        }
        textField.setAttribute("isStretchWithOverflow", "true");
        if (this.m_attributes.get("textAdjust") != null) {
            textField.setAttribute("textAdjust", (String)this.m_attributes.get("textAdjust"));
        }
        textField.setAttribute("isBlankWhenNull", "true");
        textField.addContent((Content)textFieldExpression);
        if (hyperlinkUrl != null) {
            textField.setAttribute("hyperlinkType", "Reference");
            textField.setAttribute("hyperlinkTarget", "Blank");
            Element hyperlinkReferenceElement = new Element("hyperlinkReferenceExpression");
            Content hyperlinkReferenceContent = ExpressionUtil.convertJRXMLAttributValueIntoExpressionJRXML(context, hyperlinkUrl);
            hyperlinkReferenceElement.setContent(hyperlinkReferenceContent);
            textField.addContent((Content)hyperlinkReferenceElement);
        }
    }

    private void parseAndBuildFontExpression(JRXMLContext context, Element reportElement, Element element) {
        String fontDef;
        Attribute att = null;
        if (this.m_attributes.get("font") != null) {
            att = new Attribute("font", (String)this.m_attributes.get("font"));
        }
        if (ExpressionUtil.checkIfStraightExpression(fontDef = (String)this.m_attributes.get("font"))) {
            Element textElement = this.buildTextElement(null);
            if (textElement != null) {
                element.addContent((Content)textElement);
            }
            PropertyExpressionUtil.addPropertyExpressionIfNeeded(element, att, context);
        } else if (ExpressionUtil.checkIfStringContainsExpression(fontDef, false)) {
            Element textElement = this.buildTextElement(null);
            if (textElement != null) {
                element.addContent((Content)textElement);
            }
            PropertyExpressionUtil.addPropertyExpressionIfNeeded(element, att, context);
        } else {
            Font font = ParserUtil.decodeFont(fontDef);
            Map fontAttributes = ValueManager.decodeComplexValue((String)fontDef);
            if (font != null) {
                Element fontElement = new Element("font");
                Element textElement = this.buildTextElement(null);
                textElement.addContent((Content)fontElement);
                if (textElement != null) {
                    if (fontAttributes.get("family") != null) {
                        fontElement.setAttribute("fontName", (String)fontAttributes.get("family"));
                    } else if (ParserUtil.isEmpty(context.getDefaultFont())) {
                        fontElement.setAttribute("fontName", "Arial");
                    } else if (ExpressionUtil.checkIfStraightExpression(context.getDefaultFont())) {
                        att = new Attribute("family", context.getDefaultFont());
                        PropertyExpressionUtil.addPropertyExpressionIfNeeded(element, att, context);
                    } else {
                        fontElement.setAttribute("fontName", context.getDefaultFont());
                    }
                    if (fontAttributes.get("size") != null) {
                        fontElement.setAttribute("size", (String)fontAttributes.get("size"));
                    }
                    if (fontAttributes.get("weight") != null) {
                        fontElement.setAttribute("isBold", "true");
                    }
                    if (fontAttributes.get("posture") != null) {
                        fontElement.setAttribute("isItalic", "true");
                    }
                    if (fontAttributes.get("underline") != null) {
                        fontElement.setAttribute("isUnderline", "true");
                    }
                    if (fontAttributes.get("strikethrough") != null) {
                        fontElement.setAttribute("isStrikeThrough", "true");
                    }
                    element.addContent((Content)textElement);
                }
            } else if (ParserUtil.isEmpty(context.getDefaultFont())) {
                Element fontElement = new Element("font");
                Element textElement = this.buildTextElement(null);
                textElement.addContent((Content)fontElement);
                if (textElement != null) {
                    fontElement.setAttribute("fontName", "Arial");
                    fontElement.setAttribute("size", "10");
                    element.addContent((Content)textElement);
                }
            } else {
                Element fontElement = new Element("font");
                Element textElement = this.buildTextElement(null);
                textElement.addContent((Content)fontElement);
                if (textElement != null) {
                    if (ParserUtil.isEmpty(context.getDefaultFont())) {
                        fontElement.setAttribute("fontName", "Arial");
                    } else if (ExpressionUtil.checkIfStraightExpression(context.getDefaultFont())) {
                        att = new Attribute("family", context.getDefaultFont());
                        PropertyExpressionUtil.addPropertyExpressionIfNeeded(element, att, context);
                    } else {
                        fontElement.setAttribute("fontName", context.getDefaultFont());
                    }
                    fontElement.setAttribute("size", "10");
                    element.addContent((Content)textElement);
                }
            }
        }
    }

    private Element buildTextElement(Element textElement) {
        String align = (String)this.m_attributes.get("align");
        String valign = (String)this.m_attributes.get("valign");
        if (!ParserUtil.isEmpty(align) || !ParserUtil.isEmpty(valign)) {
            if (textElement == null) {
                textElement = new Element("textElement");
            }
            if (!ParserUtil.isEmpty(align) && ("Center".equals(align) || "Left".equals(align) || "Right".equals(align) || "Justified".equals(align))) {
                textElement.setAttribute(new Attribute("textAlignment", align));
            }
            if (!ParserUtil.isEmpty(valign) && ("Top".equals(valign) || "Bottom".equals(valign) || "Middle".equals(valign) || "Justified".equals(valign))) {
                textElement.setAttribute(new Attribute("verticalAlignment", valign));
            }
        }
        if (this.m_attributes.containsKey("font") && textElement == null) {
            textElement = new Element("textElement");
        }
        if (this.m_attributes.get("markup") != null) {
            if (textElement == null) {
                textElement = new Element("textElement");
            }
            textElement.setAttribute("markup", (String)this.m_attributes.get("markup"));
        }
        if (ParserUtil.isEmpty(valign)) {
            if (textElement == null) {
                textElement = new Element("textElement");
            }
            textElement.setAttribute(new Attribute("verticalAlignment", "Middle"));
        }
        return textElement;
    }
}

