/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.util;

import java.math.BigDecimal;
import org.eclnt.ccee.sjrxml.util.ENUMUnit;
import org.eclnt.util.valuemgmt.ValueManager;

public class DPICalculation {
    public static ENUMUnit findUnitFromSize(String size) {
        if (size == null) {
            return ENUMUnit.DOT;
        }
        if (size.contains("mm")) {
            return ENUMUnit.MM;
        }
        if (size.contains("cm")) {
            return ENUMUnit.CM;
        }
        return ENUMUnit.DOT;
    }

    public static int calculate72DpiPixelValue(String size) {
        if (size == null) {
            return 0;
        }
        if ((size = size.trim()).endsWith("mm")) {
            size = size.replace("mm", "");
            double d = ValueManager.decodeDouble((String)size, (double)0.0);
            return (int)Math.abs(d *= 2.8346457);
        }
        if (size.endsWith("cm")) {
            size = size.replace("cm", "");
            double d = ValueManager.decodeDouble((String)size, (double)0.0);
            return (int)Math.abs(d *= 28.346457);
        }
        return ValueManager.decodeInt((String)size, (int)0);
    }

    public static String transfer72DpiPixelValueToString(int yDots, ENUMUnit unit) {
        if (unit == null || unit == ENUMUnit.DOT) {
            return "" + yDots;
        }
        if (unit == ENUMUnit.MM) {
            return DPICalculation.transfer72DpiPixelValueToMm(yDots) + "mm";
        }
        if (unit == ENUMUnit.CM) {
            return DPICalculation.transfer72DpiPixelValueToCm(yDots) + "cm";
        }
        throw new Error("Unknown unit: " + (Object)((Object)unit));
    }

    public static int transfer72DpiPixelValueToMm(int pixelValue) {
        return (int)Math.round((double)pixelValue / 2.8346457);
    }

    public static BigDecimal transfer72DpiPixelValueToCm(int pixelValue) {
        int mmValue = DPICalculation.transfer72DpiPixelValueToMm(pixelValue);
        return new BigDecimal(mmValue).divide(new BigDecimal(10));
    }
}

