/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.dyndata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.ccaddons.pbc.CCMasterDetail;
import org.eclnt.ccaddons.pbc.dyndata.CCDynDataDetail;
import org.eclnt.ccaddons.pbc.sjrxml.i18n.SJRXMLLit;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlLogicToolset;
import org.eclnt.ccaddons.pbc.text.CCEditText;
import org.eclnt.ccaddons.pbc.text.CCShowText;
import org.eclnt.ccee.dyndata.DynDataInstanceToMetaData;
import org.eclnt.ccee.dyndata.DynDataMap;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.DynDataUtil;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.ccee.xml.JAXBUtil;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.elements.events.BaseActionEventDrop;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDItem;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponent;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

@CCGenClass(expressionBase="#{d.CCDynDataEditor}")
public class CCDynDataEditor
extends PageBeanComponent
implements Serializable {
    static final int TLINDEX_TREE = 0;
    static final int TLINDEX_XML = 1;
    private IListener m_listener;
    FIXGRIDTreeBinding<TreeNode> m_tree = new FIXGRIDTreeBinding();
    CCMasterDetail m_masterDetailUI = new CCMasterDetail();
    DynDataDefinition m_ddd;
    DynDataDefinition m_selectedDdd;
    TreeNode m_top;
    CCDynDataDetail m_detailUI = null;
    DynDataReaderContext m_ddrContext;
    boolean m_showFooter = false;
    boolean m_showHeader = false;
    int m_tlIndex = 0;
    int m_currentTlIndex = 0;
    String m_dragSendPrefix = UniqueIdCreator.createCounter() + "";

    public String getRootExpressionUsedInPage() {
        return "#{d.CCDynDataEditor}";
    }

    public void prepare(DynDataDefinition ddd, DynDataReaderContext ddrContext, IListener listener) {
        this.m_ddd = ddd;
        this.m_ddrContext = ddrContext;
        this.m_listener = listener;
        this.updateTree();
        this.selectTopItem();
    }

    public void selectNode(String dddId) {
        TreeNode node = this.m_top.findNodeWithDDDId(dddId);
        if (node != null) {
            this.m_tree.deselectCurrentSelection();
            this.m_tree.selectItem((IFIXGRIDItem)node);
        }
    }

    public boolean getShowFooter() {
        return this.m_showFooter;
    }

    public void setShowFooter(boolean showFooter) {
        this.m_showFooter = showFooter;
    }

    public boolean getShowHeader() {
        return this.m_showHeader;
    }

    public void setShowHeader(boolean value) {
        this.m_showHeader = value;
    }

    public FIXGRIDTreeBinding<TreeNode> getTree() {
        return this.m_tree;
    }

    public CCMasterDetail getMasterDetailUI() {
        return this.m_masterDetailUI;
    }

    public CCDynDataDetail getDetailUI() {
        return this.m_detailUI;
    }

    public DynDataDefinition getDynDataDefintion() {
        return this.m_ddd;
    }

    public void onCancelAction(ActionEvent event) {
        if (this.m_listener != null) {
            this.m_listener.reactOnCancel();
        }
    }

    public void omOKAction(ActionEvent event) {
        boolean testResult = this.testCurrentInstance(new StringBuffer());
        if (!testResult) {
            YESNOPopup.createInstance((String)SJRXMLLit.lit("yntitTestFailed", new String[0]), (String)SJRXMLLit.lit("ynmsgTestFailed", new String[0]), (YESNOPopup.IYesNoListener)new YESNOPopup.IYesNoListener(){

                public void reactOnYes() {
                    CCDynDataEditor.this.processOKExecute();
                }

                public void reactOnNo() {
                    CCDynDataEditor.this.onTestAction(null);
                }
            });
        } else {
            this.processOKExecute();
        }
    }

    private void processOKExecute() {
        if (this.m_listener != null) {
            this.m_listener.reactOnOK();
        }
    }

    public void onTestAction(ActionEvent event) {
        StringBuffer protocol = new StringBuffer();
        this.testCurrentInstance(protocol);
        CCShowText.openPopupInstance((IPageBean)this, (String)"Test protocol", (String)protocol.toString());
    }

    public void onImportTestAction(ActionEvent event) {
        YESNOPopup.createInstance((String)SJRXMLLit.lit("yntitImportOverwrite", new String[0]), (String)SJRXMLLit.lit("ynmsgImportOverwrite", new String[0]), (YESNOPopup.IYesNoListener)new YESNOPopup.IYesNoListener(){

            public void reactOnYes() {
                CCDynDataEditor.this.importTestObjectStructure();
            }

            public void reactOnNo() {
            }
        });
    }

    public int getTlIndex() {
        return this.m_tlIndex;
    }

    public void setTlIndex(int value) {
        this.m_tlIndex = value;
    }

    public void onTlAction(ActionEvent event) {
        if (this.m_currentTlIndex == this.m_tlIndex) {
            return;
        }
        this.m_currentTlIndex = this.m_tlIndex;
    }

    public void onXMLAction(ActionEvent event) {
        String xml = JAXBUtil.marshalSimpleObject((Object)this.m_ddd);
        CCEditText.openAsPopup((IPageBean)this, (String)xml, (CCEditText.IListener)new CCEditText.IListener(){

            public void reactOnOK(String text) {
                CCDynDataEditor.this.updateDdd(text);
            }

            public void reactOnCancel() {
            }

            public boolean checkText(String text) {
                try {
                    DynDataDefinition ddd = DynDataUtil.parseDynDataDefinitionXml((String)text);
                    return ddd != null;
                }
                catch (Throwable t) {
                    Statusbar.outputAlert((String)("Problem parsing XML: " + t.toString()), (String)"", (String)ValueManager.getStackstraceString((Throwable)t));
                    return false;
                }
            }
        });
    }

    private void updateDdd(String text) {
        DynDataDefinition ddd;
        this.m_ddd = ddd = DynDataUtil.parseDynDataDefinitionXml((String)text);
        this.updateTree();
        this.selectTopItem();
    }

    private void updateTree() {
        this.m_tree.getRootNode().removeAllChildNodes(true);
        this.m_top = new TreeNode(this.m_ddd, this.m_tree.getRootNode());
        this.m_top.createSubNodes();
    }

    private void selectTopItem() {
        if (this.m_top != null) {
            this.m_tree.selectItem((IFIXGRIDItem)this.m_top);
        }
    }

    private void showDetails(final TreeNode treeNode) {
        this.m_selectedDdd = treeNode.i_ddd;
        this.m_masterDetailUI.notifyMasterDetail();
        if (this.m_detailUI == null) {
            this.m_detailUI = new CCDynDataDetail();
        }
        this.m_detailUI.prepare(this.m_ddrContext, treeNode.i_ddd, new CCDynDataDetail.IListener(){

            @Override
            public List<DynDataDefinition> findParentDynDataDefinitions() {
                FIXGRIDTreeItem parentObject;
                ArrayList<DynDataDefinition> result = new ArrayList<DynDataDefinition>();
                TreeNode currentTreeNode = treeNode;
                while ((parentObject = currentTreeNode.getParentNode()) != null && parentObject instanceof TreeNode) {
                    TreeNode parentTreeNode = (TreeNode)parentObject;
                    result.add(parentTreeNode.i_ddd);
                    currentTreeNode = parentTreeNode;
                }
                return result;
            }
        });
    }

    private void importTestObjectStructure() {
        try {
            DynDataMap root = SjrxmlLogicToolset.createPreviewDataObject(this.m_ddrContext, this.m_ddd);
            DynDataDefinition ddd = DynDataInstanceToMetaData.createMetaDataFromInstance((DynDataMap)root, (DynDataDefinition)this.m_ddd);
            this.prepare(ddd, this.m_ddrContext, this.m_listener);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem importing test object structure", t);
            Statusbar.outputError((String)t.toString());
        }
    }

    private boolean testCurrentInstance(StringBuffer protocol) {
        try {
            protocol.append("Reading data object...\n");
            DynDataMap root = SjrxmlLogicToolset.createPreviewDataObject(this.m_ddrContext, this.m_ddd);
            protocol.append("Reading data object finished.\n");
            protocol.append("Content of data object is:\n\n");
            protocol.append(root.toString(0));
            return true;
        }
        catch (Throwable t) {
            protocol.append("Problem occurred when executing test.\n");
            protocol.append(ValueManager.getStackstraceString((Throwable)t));
            return false;
        }
    }

    public void moveSelectedNode(TreeNode treeNode, BaseActionEventDrop e) {
        TreeNode selNode = (TreeNode)this.m_tree.getSelectedItem();
        if (selNode == null) {
            return;
        }
        if (selNode == treeNode) {
            return;
        }
        if (treeNode.checkIfNodeHasAsParent(selNode)) {
            Statusbar.outputError((String)SJRXMLLit.lit("msgParentNodeCannotBeMoved", new String[0]));
            return;
        }
        boolean asChild = treeNode.getLevelInt() == 0 || e.getPercentageHorizontal() >= 50;
        boolean upper = e.getPercentageVertical() < 50;
        TreeNode selParentNode = (TreeNode)selNode.getParentNode();
        selNode.removeNode();
        if (selNode.getChildNodes().size() == 0) {
            selNode.setStatus(2);
        }
        if (asChild) {
            treeNode.addSubNode(selNode, upper);
            treeNode.setStatus(0);
        } else {
            int index = treeNode.getParentNode().getChildNodes().indexOf(treeNode);
            if (!upper) {
                ++index;
            }
            treeNode.getParentNode().addSubNode((FIXGRIDTreeItem)selNode, index);
        }
        if (selParentNode != null && selParentNode.getChildNodes().size() == 0) {
            selParentNode.setStatus(2);
        }
    }

    public class TreeNode
    extends FIXGRIDTreeItem
    implements Serializable {
        DynDataDefinition i_ddd;

        public TreeNode(DynDataDefinition ddd, FIXGRIDTreeItem parentNode) {
            super(parentNode);
            this.i_ddd = ddd;
        }

        public void onRowSelect() {
            CCDynDataEditor.this.showDetails(this);
        }

        public void onRowExecute() {
        }

        public void onToggle() {
        }

        public String getText() {
            return this.i_ddd.getId() + ", " + this.abbreviateClassName(this.i_ddd.getClassName());
        }

        public String getDropReceive() {
            if (this.getLevelInt() != 0) {
                return CCDynDataEditor.this.m_dragSendPrefix + ":edges";
            }
            return CCDynDataEditor.this.m_dragSendPrefix + ":verticalsplit";
        }

        public String getDragSend() {
            if (this.getLevelInt() == 0) {
                return null;
            }
            return CCDynDataEditor.this.m_dragSendPrefix + ":DATA";
        }

        public void processTREENDOEAction(ActionEvent event) {
            BaseActionEventDrop e;
            super.processTREENDOEAction(event);
            if (event instanceof BaseActionEventDrop && (e = (BaseActionEventDrop)event).getDragInfo().startsWith(CCDynDataEditor.this.m_dragSendPrefix)) {
                CCDynDataEditor.this.moveSelectedNode(this, e);
            }
        }

        private String abbreviateClassName(String s) {
            if (s == null) {
                return "-";
            }
            int index = s.lastIndexOf(46);
            return s.substring(index + 1);
        }

        public void createSubNodes() {
            for (DynDataDefinition childDdd : this.i_ddd.getChildren()) {
                TreeNode sub = new TreeNode(childDdd, this);
                sub.createSubNodes();
            }
            if (this.getChildNodes().size() > 0) {
                this.setStatus(0);
            } else {
                this.setStatus(2);
            }
        }

        public void onRowPopupMenuItem(BaseActionEventPopupMenuItem event) {
            if ("REMOVE".equals(event.getCommand())) {
                if (this.getLevelInt() == 0) {
                    Statusbar.outputAlert((String)SJRXMLLit.lit("msgTopNodeCannotBeRemoved", new String[0]));
                    return;
                }
                YESNOPopup.createInstance((String)SJRXMLLit.lit("yntitRemovingNode", new String[0]), (String)SJRXMLLit.lit("ynmsgRemovingNode", new String[0]), (YESNOPopup.IYesNoListener)new YESNOPopup.IYesNoListener(){

                    public void reactOnYes() {
                        TreeNode.this.removeNodeExecute();
                    }

                    public void reactOnNo() {
                    }
                });
            } else if ("NEWCHILD".equals(event.getCommand())) {
                DynDataDefinition ddd = new DynDataDefinition();
                ddd.setId("...new...");
                this.i_ddd.getChildren().add(ddd);
                TreeNode childNode = new TreeNode(ddd, this);
                this.setStatus(0);
                childNode.setStatus(2);
            }
        }

        private void removeNodeExecute() {
            TreeNode parentNode = (TreeNode)this.getParentNode();
            parentNode.i_ddd.getChildren().remove(this.i_ddd);
            this.removeNode();
            if (parentNode.getChildNodes().size() == 0) {
                parentNode.setStatus(2);
            }
        }

        public TreeNode findNodeWithDDDId(String id) {
            if (this.i_ddd != null && ValueManager.checkIfStringsAreEqual((String)id, (String)this.i_ddd.getId())) {
                return this;
            }
            for (Object o : this.getChildNodes()) {
                TreeNode childNode = (TreeNode)o;
                TreeNode childResult = childNode.findNodeWithDDDId(id);
                if (childResult == null) continue;
                return childResult;
            }
            return null;
        }
    }

    public static interface IListener
    extends Serializable {
        public void reactOnCancel();

        public void reactOnOK();
    }
}

