/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml;

import java.io.Serializable;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.ccaddons.pbc.dyndata.CCDynDataEditor;
import org.eclnt.ccaddons.pbc.sjrxml.i18n.SJRXMLLit;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataDynDataDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataLogic;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlPersistence;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.DynDataUtil;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.ISetId;
import org.eclnt.jsfserver.defaultscreens.IdTextSelection;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.elements.events.BaseActionEventValueHelp;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponent;
import org.eclnt.util.valuemgmt.ValueManager;

@CCGenClass(expressionBase="#{d.CCDynDataDefinitionDetail}")
public class CCDynDataDefinitionDetail
extends PageBeanComponent
implements Serializable {
    private IListener m_listener;
    DataDynDataDefinition m_dddd;
    CCDynDataEditor m_editor = new CCDynDataEditor();
    DynDataDefinition m_ddd;
    DynDataReaderContext m_ddReaderContext;
    String m_ddddSaveStamp;
    boolean m_isNew = false;

    public String getRootExpressionUsedInPage() {
        return "#{d.CCDynDataDefinitionDetail}";
    }

    public void prepare(DataDynDataDefinition dddd, boolean isNew, DynDataReaderContext ddrContext, IListener listener) {
        this.m_listener = listener;
        this.m_dddd = dddd;
        this.m_isNew = isNew;
        this.m_ddd = !ValueManager.isEmpty((String)this.m_dddd.getXml()) ? DynDataUtil.parseDynDataDefinitionXml((String)dddd.getXml()) : new DynDataDefinition();
        this.m_ddReaderContext = ddrContext;
        this.m_editor.prepare(this.m_ddd, this.m_ddReaderContext, new CCDynDataEditor.IListener(){

            @Override
            public void reactOnOK() {
            }

            @Override
            public void reactOnCancel() {
            }
        });
        this.m_editor.setShowHeader(false);
        this.m_editor.setShowFooter(false);
        this.m_ddddSaveStamp = DataLogic.createSaveStamp(this.m_dddd);
    }

    public boolean getEnabledId() {
        return this.m_isNew;
    }

    public CCDynDataEditor getEditor() {
        return this.m_editor;
    }

    public DataDynDataDefinition getDddd() {
        return this.m_dddd;
    }

    public void onSaveAction(ActionEvent event) {
        this.updateDynDataDefinitionFromEditor();
        List<String> result = DataLogic.saveDataDynDataDefinition(this.m_dddd, this.m_isNew);
        if (result.size() == 0) {
            this.m_ddddSaveStamp = DataLogic.createSaveStamp(this.m_dddd);
            this.m_isNew = false;
            if (this.m_listener != null) {
                this.m_listener.reactOnSaved(this.m_dddd);
            }
        } else {
            this.transferListOfErrors(result, "Problem occurred when saving data definition.");
        }
    }

    public void onCloseAction(ActionEvent event) {
        if (this.checkIfUnsavedChanges()) {
            YESNOPopup.createInstance((String)SJRXMLLit.lit("yntitUnsavedChanges", new String[0]), (String)SJRXMLLit.lit("ynmsgUnsavedChanges", new String[0]), (YESNOPopup.IYesNoListener)new YESNOPopup.IYesNoListener(){

                public void reactOnYes() {
                    CCDynDataDefinitionDetail.this.closeExecute();
                }

                public void reactOnNo() {
                }
            });
            return;
        }
        this.closeExecute();
    }

    public boolean checkIfUnsavedChanges() {
        this.updateDynDataDefinitionFromEditor();
        String nowStamp = DataLogic.createSaveStamp(this.m_dddd);
        return !ValueManager.checkIfStringsAreEqual((String)this.m_ddddSaveStamp, (String)nowStamp);
    }

    public void onCategoryAction(ActionEvent event) {
        if (event instanceof BaseActionEventValueHelp) {
            IdTextSelection idts = IdTextSelection.createInstance();
            List<String> ids = SjrxmlPersistence.instance().readCategories();
            for (String id : ids) {
                idts.addLine(id, id);
            }
            idts.preselect(this.m_dddd.getCategoryId());
            idts.setCallBack(new ISetId(){

                public void setId(String id) {
                    CCDynDataDefinitionDetail.this.m_dddd.setCategoryId(id);
                }
            });
        }
    }

    private void closeExecute() {
        if (this.m_listener != null) {
            this.m_listener.reactOnClose();
        }
    }

    private void updateDynDataDefinitionFromEditor() {
        this.m_ddd = this.m_editor.getDynDataDefintion();
        String xml = DynDataUtil.marshalDynDataDefinition((DynDataDefinition)this.m_ddd);
        this.m_dddd.setXml(xml);
    }

    private void transferListOfErrors(List<String> result, String summary) {
        for (String line : result) {
            Statusbar.outputError((String)line);
        }
        if (result.size() > 1) {
            Statusbar.outputError((String)summary);
            Statusbar.setImmediatelyShowAllMessages((boolean)true);
        } else {
            Statusbar.setImmediatelyShowAllMessages((boolean)false);
        }
    }

    public static interface IListener
    extends Serializable {
        public void reactOnSaved(DataDynDataDefinition var1);

        public void reactOnClose();
    }
}

