/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.ccaddons.pbc.sjrxml.i18n.SJRXMLLit;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataFormDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlLogicExportImport;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.bufferedcontent.DefaultUploadContent;
import org.eclnt.jsfserver.bufferedcontent.IUploadContent;
import org.eclnt.jsfserver.bufferedcontent.UploadContentMgr;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDItem;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponent;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

@CCGenClass(expressionBase="#{d.CCSjrxmlImport}")
public class CCSjrxmlImport
extends PageBeanComponent
implements Serializable {
    static final int TAB_DIRECTORY = 0;
    static final int TAB_UPLOAD = 1;
    MyUploadContent m_uploadContent = new MyUploadContent();
    private IListener m_listener;
    String m_directory;
    FIXGRIDListBinding<GridItem> m_grid = new FIXGRIDListBinding();
    String m_uploadDirectoryName;
    int m_tabValue = 0;

    public CCSjrxmlImport() {
        UploadContentMgr.add((IUploadContent)this.m_uploadContent);
        this.m_directory = FileManager.getTempFileDirectory().getAbsolutePath() + "/exportimport";
        this.m_directory = ValueManager.encodeIntoValidFileName((String)this.m_directory, (boolean)true);
    }

    public String getRootExpressionUsedInPage() {
        return "#{d.CCSjrxmlImport}";
    }

    public void prepare(IListener listener) {
        this.m_listener = listener;
    }

    public void onUploadAction(ActionEvent event) {
        this.m_directory = this.m_uploadDirectoryName;
        this.m_tabValue = 0;
        this.onShowFilesAction(null);
    }

    public String getZipUploadURL() {
        return this.m_uploadContent.getURL();
    }

    public void onImportAction(ActionEvent event) {
        try {
            if (this.m_grid.getSelectedItems().size() == 0) {
                throw new Exception("No item for import selected.");
            }
            this.importNext();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem during import from " + this.m_directory, t);
            Statusbar.outputError((String)t.toString(), (String)ValueManager.getStackstraceString((Throwable)t));
        }
    }

    private void importNext() {
        final GridItem item = (GridItem)this.m_grid.getSelectedItem();
        if (item == null) {
            Statusbar.outputSuccess((String)SJRXMLLit.lit("msgImportFinished", new String[0]));
        } else {
            Object o = item.checkIfDataAlreadyExists();
            if (o != null) {
                if (o instanceof DataFormDefinition) {
                    DataFormDefinition dfd = (DataFormDefinition)o;
                    YESNOPopup.createInstance((String)"", (String)SJRXMLLit.lit("ynmsgImportFormAlreadyExists", dfd.getDescription()), (YESNOPopup.IYesNoListener)new YESNOPopup.IYesNoListener(){

                        public void reactOnYes() {
                            CCSjrxmlImport.this.m_grid.deselectItem((IFIXGRIDItem)item);
                            item.importData();
                            CCSjrxmlImport.this.importNext();
                        }

                        public void reactOnNo() {
                            CCSjrxmlImport.this.m_grid.deselectItem((IFIXGRIDItem)item);
                            CCSjrxmlImport.this.importNext();
                        }
                    });
                }
            } else {
                this.m_grid.deselectItem((IFIXGRIDItem)item);
                item.importData();
                this.importNext();
            }
        }
    }

    public void onShowFilesAction(ActionEvent event) {
        this.m_grid.getItems().clear();
        List fileNames = FileManager.getFilesOfDirectoryByPattern((String)this.m_directory, (String)".xml");
        for (String fileName : fileNames) {
            GridItem gi = new GridItem(new File(fileName));
            this.m_grid.getItems().add(gi);
        }
    }

    public String getDirectory() {
        return this.m_directory;
    }

    public void setDirectory(String value) {
        this.m_directory = value;
    }

    public FIXGRIDListBinding<GridItem> getGrid() {
        return this.m_grid;
    }

    public int getTabValue() {
        return this.m_tabValue;
    }

    public void setTabValue(int tabValue) {
        this.m_tabValue = tabValue;
    }

    public void onSelectClearAction(ActionEvent event) {
        this.m_grid.deselectCurrentSelection();
    }

    public void onSelectAllAction(ActionEvent event) {
        this.m_grid.deselectCurrentSelection();
        for (GridItem gi : this.m_grid.getItems()) {
            this.m_grid.selectItem((IFIXGRIDItem)gi);
        }
    }

    private void createUploadDirectory() {
        this.m_uploadDirectoryName = HttpSessionAccess.getServletTempDirectory() + "/upload/sjrxml/" + UniqueIdCreator.createUUID() + "/";
        this.m_uploadDirectoryName = ValueManager.encodeIntoValidFileName((String)this.m_uploadDirectoryName, (boolean)true);
        FileManager.ensureDirectoryExists((String)this.m_uploadDirectoryName);
    }

    public class MyUploadContent
    extends DefaultUploadContent {
        public void beginPassing() {
            CCSjrxmlImport.this.createUploadDirectory();
        }

        public void passClientFile(String fileName, byte[] content) {
            String serverFileName = CCSjrxmlImport.this.m_uploadDirectoryName + fileName;
            FileManager.writeFile((String)serverFileName, (byte[])content, (boolean)true);
        }

        public void endPassing() {
        }
    }

    public static interface IListener
    extends Serializable {
    }

    public class GridItem
    extends FIXGRIDItem
    implements Serializable {
        File i_file;

        public GridItem(File file) {
            this.i_file = file;
        }

        public String getFileName() {
            return this.i_file.getName();
        }

        public void onRowSelect() {
        }

        public void onRowExecute() {
        }

        public Object checkIfDataAlreadyExists() {
            String xml = FileManager.readUTF8File((String)this.i_file.getAbsolutePath(), (boolean)true);
            if (this.i_file.getName().endsWith("_form.xml")) {
                return SjrxmlLogicExportImport.readExistingForm(xml);
            }
            if (this.i_file.getName().endsWith("_data.xml")) {
                return null;
            }
            Statusbar.outputError((String)SJRXMLLit.lit("msgNoImportDataDefinition", this.i_file.getName()));
            return null;
        }

        public void importData() {
            String xml = FileManager.readUTF8File((String)this.i_file.getAbsolutePath(), (boolean)true);
            if (this.i_file.getName().endsWith("_form.xml")) {
                SjrxmlLogicExportImport.importForm(xml);
                Statusbar.outputSuccess((String)SJRXMLLit.lit("msgImportForm", this.i_file.getName()));
            } else if (this.i_file.getName().endsWith("_data.xml")) {
                SjrxmlLogicExportImport.importDynDataDefinition(xml);
                Statusbar.outputSuccess((String)SJRXMLLit.lit("msgImportDataDefinition", this.i_file.getName()));
            } else {
                Statusbar.outputError((String)SJRXMLLit.lit("msgNoImportExtension", this.i_file.getName()));
            }
        }
    }
}

