/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml.logic;

import org.eclnt.ccaddons.pbc.sjrxml.logic.DataDynDataDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataFormDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.ISjrxmlPersistence;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlPersistence;
import org.eclnt.ccee.xml.JAXBUtil;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class SjrxmlLogicExportImport {
    public static ExportData createFormExportData(String formId) {
        String fileName = formId + "_form.xml";
        String content = SjrxmlLogicExportImport.readFormDataAsXML(formId);
        return new ExportData(fileName, content);
    }

    public static void exportForm(String directoryName, String formId) {
        String xml = SjrxmlLogicExportImport.readFormDataAsXML(formId);
        String fileName = ValueManager.encodeIntoValidFileName((String)(directoryName + "/" + formId + "_form.xml"), (boolean)false);
        FileManager.ensureDirectoryForFileExists((String)fileName);
        FileManager.writeUTF8File((String)fileName, (String)xml, (boolean)true);
    }

    public static DataFormDefinition readExistingForm(String xml) {
        DataFormDefinition dfd = (DataFormDefinition)JAXBUtil.unmarshalSimpleObject((String)xml, DataFormDefinition.class);
        return SjrxmlPersistence.instance().readDataFormForEditor(dfd.getId());
    }

    public static void importForm(String xml) {
        DataFormDefinition dfd = (DataFormDefinition)JAXBUtil.unmarshalSimpleObject((String)xml, DataFormDefinition.class);
        SjrxmlPersistence.instance().saveDataForm(dfd);
    }

    public static ExportData createDynDataDefinitionExportData(String dyndataId) {
        String fileName = dyndataId + "_data.xml";
        String content = SjrxmlLogicExportImport.readDynDataDefintionAsXml(dyndataId);
        return new ExportData(fileName, content);
    }

    public static void exportDynDataDefinition(String directoryName, String dyndataId) {
        String xml = SjrxmlLogicExportImport.readDynDataDefintionAsXml(dyndataId);
        String fileName = ValueManager.encodeIntoValidFileName((String)(directoryName + "/" + dyndataId + "_data.xml"), (boolean)false);
        FileManager.ensureDirectoryForFileExists((String)fileName);
        FileManager.writeUTF8File((String)fileName, (String)xml, (boolean)true);
    }

    public static void importDynDataDefinition(String xml) {
        DataDynDataDefinition ddd = (DataDynDataDefinition)JAXBUtil.unmarshalSimpleObject((String)xml, DataDynDataDefinition.class);
        SjrxmlPersistence.instance().saveDataDynData(ddd);
    }

    private static String readFormDataAsXML(String formId) {
        ISjrxmlPersistence p = SjrxmlPersistence.instance();
        DataFormDefinition dfd = p.readDataFormForEditor(formId);
        String xml = JAXBUtil.marshalSimpleObject((Object)dfd);
        return xml;
    }

    private static String readDynDataDefintionAsXml(String dyndataId) {
        ISjrxmlPersistence p = SjrxmlPersistence.instance();
        DataDynDataDefinition dddd = p.readDataDynData(dyndataId);
        String xml = JAXBUtil.marshalSimpleObject((Object)dddd);
        return xml;
    }

    public static class ExportData {
        String i_fileName;
        String i_content;

        public ExportData(String fileName, String content) {
            this.i_fileName = fileName;
            this.i_content = content;
        }

        public String getFileName() {
            return this.i_fileName;
        }

        public String getContent() {
            return this.i_content;
        }
    }
}

