/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml;

import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class ConfigureJasperLogging
implements ICCEEConstants {
    public static void configure() {
        try {
            String logDirectory = HttpSessionAccess.getServletTempDirectory();
            logDirectory = ValueManager.encodeIntoValidFileName((String)logDirectory, (boolean)true);
            FileManager.ensureDirectoryExists((String)logDirectory);
            Logger root = Logger.getRootLogger();
            root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
            FileAppender fa = new FileAppender();
            fa.setName("FileLogger");
            fa.setFile(logDirectory + "/log_sjrxml.txt");
            fa.setLayout((Layout)new PatternLayout("%d %-5p [%c{1}] %m%n"));
            fa.setThreshold((Priority)Level.DEBUG);
            fa.setAppend(true);
            fa.activateOptions();
            root.addAppender((Appender)fa);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Configuration of jasperreports-logging failed", t);
        }
    }
}

