/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.checking;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.IConstantsElementNames;
import org.eclnt.ccee.sjrxml.checking.CheckingMessages;
import org.eclnt.ccee.sjrxml.checking.ISJRXMLCheckerConstants;
import org.eclnt.ccee.sjrxml.checking.ISJRXMLElementChecker;
import org.eclnt.ccee.sjrxml.checking.SJRXMLCheckerResult;
import org.eclnt.ccee.sjrxml.parsing.ParserUtil;
import org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil;
import org.eclnt.ccee.sjrxml.util.AutoCalculationSJRXML;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.util.valuemgmt.ValueManager;

public abstract class CheckerBase
implements ISJRXMLElementChecker,
IConstantsElementNames,
ISJRXMLCheckerConstants {
    private static int OVERLAPTOLEARANCE = 4;
    private AutoCalculationSJRXML m_autoCalculation;

    public void checkElement(SimpleXMLElement xmlElement, SJRXMLCheckerResult result, AutoCalculationSJRXML calculation) {
        this.m_autoCalculation = calculation;
        this.checkElementExecute(xmlElement, result, this.m_autoCalculation);
    }

    public AutoCalculationSJRXML getAutoCalculation() {
        return this.m_autoCalculation;
    }

    public void checkOverlaping(SimpleXMLElement xmlElement, SJRXMLCheckerResult result) {
        List<SimpleXMLElement> subElements = this.findSubElementsRelevantForOverlapCheck(xmlElement);
        for (int i = 0; i < subElements.size() - 1; ++i) {
            for (int j = i + 1; j < subElements.size(); ++j) {
                if (subElements.get(i) == subElements.get(j) || !this.isOverlapping(subElements.get(i), subElements.get(j), result)) continue;
                String errorText = "Element " + subElements.get(i).getName() + " with X value \"" + subElements.get(i).getValue("x") + "\" and Y value \"" + subElements.get(i).getValue("y") + "\"";
                String errorText2 = " and element " + subElements.get(j).getName() + " with X value \"" + subElements.get(j).getValue("x") + "\" and Y value \"" + subElements.get(j).getValue("y") + "\"";
                result.addResultItem(1, CheckingMessages.createMessage("failComponentsOverlap", subElements.get(i).getName(), subElements.get(j).getName()), "OVERLAP", errorText + errorText2, subElements.get(i), subElements.get(j));
            }
        }
    }

    public SimpleXMLElement getTopElement(SimpleXMLElement element) {
        if ("outputlayout".equals(element.getParent().getName())) {
            return element.getParent();
        }
        return this.getTopElement(element.getParent());
    }

    public SimpleXMLElement getFirstParentElementWithWidth(SimpleXMLElement element) {
        if (element.getParent().getValue("width") != null) {
            return element.getParent();
        }
        return this.getFirstParentElementWithWidth(element.getParent());
    }

    public SimpleXMLElement getFirstParentElementWithHeight(SimpleXMLElement element) {
        if (element.getParent().getValue("height") != null) {
            return element.getParent();
        }
        return this.getFirstParentElementWithWidth(element.getParent());
    }

    public void checkIsOutsideParentHeight(SimpleXMLElement xmlElement, SJRXMLCheckerResult result) {
        int parentHeightInt;
        int yInt = xmlElement.getValue("y") != null && ValueManager.decodeInt((String)xmlElement.getValue("y"), (int)-1) == 0 ? ValueManager.decodeInt((String)xmlElement.getValue("y"), (int)-1) : this.getAutoCalculation().calculatePixelY(xmlElement);
        int heightInt = this.getAutoCalculation().calculatePixelHeight(xmlElement);
        if (!this.isZeroOrNegative(heightInt, parentHeightInt = this.getAutoCalculation().calculatePixelHeight(this.getFirstParentElementWithHeight(xmlElement))) && yInt + heightInt > parentHeightInt) {
            if ("header".equals(xmlElement.getName()) || "title".equals(xmlElement.getName()) || "footer".equals(xmlElement.getName())) {
                result.addResultItem(0, CheckingMessages.createMessage("failComponentReachingOutsideParentHeight", xmlElement.getParent().getName(), xmlElement.getName()), "COMPONENTS_REACHING_OUTSIDE_PARENT_HEIGHT", "height", xmlElement);
            } else {
                String errorText = "Element " + xmlElement.getName() + " with X value \"" + xmlElement.getValue("x") + "\" and Y value \"" + xmlElement.getValue("y") + "\"";
                result.addResultItem(0, CheckingMessages.createMessage("failComponentReachingOutsideParentHeight", xmlElement.getParent().getName(), xmlElement.getName()), errorText, "height", xmlElement);
            }
        }
    }

    public void checkIsOutsideParentWidthWithValue(SimpleXMLElement xmlElement, SJRXMLCheckerResult result, int parentWidthInt) {
        int xInt = xmlElement.getValue("x") != null && ValueManager.decodeInt((String)xmlElement.getValue("x"), (int)-1) == 0 ? ValueManager.decodeInt((String)xmlElement.getValue("x"), (int)-1) : this.getAutoCalculation().calculatePixelX(xmlElement);
        int widthInt = this.getAutoCalculation().calculatePixelWidth(xmlElement);
        if (!this.isZeroOrNegative(widthInt, parentWidthInt) && xInt + widthInt > parentWidthInt) {
            if ("image".equals(xmlElement.getName())) {
                String errorMessage = "Element " + xmlElement.getName() + " with value \"" + xmlElement.getValue("imageExpression") + "\"";
                result.addResultItem(0, CheckingMessages.createMessage("failComponentReachingOutsideParentWidth", xmlElement.getParent().getName(), xmlElement.getName(), errorMessage), "COMPONENTS_REACHING_OUTSIDE_PARENT_WIDTH", "width", xmlElement);
            } else if ("grid".equals(xmlElement.getName())) {
                String errorMessage = "Element " + xmlElement.getName() + " with value \"" + xmlElement.getValue("data") + "\"";
                result.addResultItem(0, CheckingMessages.createMessage("failComponentReachingOutsideParentWidth", xmlElement.getParent().getName(), xmlElement.getName(), errorMessage), "COMPONENTS_REACHING_OUTSIDE_PARENT_WIDTH", "width", xmlElement);
            } else {
                String errorMessage = "Element " + xmlElement.getName() + " with value \"" + xmlElement.getValue("text") + "\"";
                result.addResultItem(0, CheckingMessages.createMessage("failComponentReachingOutsideParentWidth", xmlElement.getParent().getName(), xmlElement.getName(), errorMessage), "COMPONENTS_REACHING_OUTSIDE_PARENT_WIDTH", "width", xmlElement);
            }
        }
    }

    public void checkIsOutsideParentWidthWithXYValues(SimpleXMLElement xmlElement, SJRXMLCheckerResult result, int parentWidthInt) {
        int xInt = xmlElement.getValue("x") != null && ValueManager.decodeInt((String)xmlElement.getValue("x"), (int)-1) == 0 ? ValueManager.decodeInt((String)xmlElement.getValue("x"), (int)-1) : this.getAutoCalculation().calculatePixelX(xmlElement);
        int widthInt = this.getAutoCalculation().calculatePixelWidth(xmlElement);
        if (!this.isZeroOrNegative(widthInt, parentWidthInt) && xInt + widthInt > parentWidthInt) {
            String errorText = "Element " + xmlElement.getName() + " with X value \"" + xmlElement.getValue("x") + "\" and Y value \"" + xmlElement.getValue("y") + "\"";
            result.addResultItem(0, CheckingMessages.createMessage("failComponentReachingOutsideParentWidth", xmlElement.getParent().getName(), xmlElement.getName(), errorText), "COMPONENTS_REACHING_OUTSIDE_PARENT_WIDTH", "width", xmlElement);
        }
    }

    public void checkAttributes(SimpleXMLElement xmlElement, SJRXMLCheckerResult result, Map<String, String> attributes) {
        if (!attributes.isEmpty()) {
            Map borderValues;
            String errorText = "In element: " + xmlElement.getName() + " with x value " + this.getAutoCalculation().calculatePixelX(xmlElement) + " and y value: " + this.getAutoCalculation().calculatePixelY(xmlElement);
            if (attributes.get("align") != null && !ExpressionUtil.checkIfStraightExpression(attributes.get("align"), true) && !ALIGN_VALID_VALUES.contains(attributes.get("align"))) {
                result.addResultItem(1, CheckingMessages.createMessage("failIncorrectAttributeValue", "align", attributes.get("align"), xmlElement.getParent().getName(), xmlElement.getName(), errorText), "INCORRECT_ATTRIBUTE_VALUE", "", xmlElement);
            }
            if (attributes.get("valign") != null && !ExpressionUtil.checkIfStraightExpression(attributes.get("valign"), true) && !VALIGN_VALID_VALUES.contains(attributes.get("valign"))) {
                result.addResultItem(1, CheckingMessages.createMessage("failIncorrectAttributeValue", "valign", attributes.get("valign"), xmlElement.getParent().getName(), xmlElement.getName(), errorText), "INCORRECT_ATTRIBUTE_VALUE", "", xmlElement);
            }
            if (attributes.get("border") != null && !ExpressionUtil.checkIfStraightExpression(attributes.get("border"), true) && !this.isCorrectComplexValue(BORDER_VALID_VALUES, ValueManager.decodeComplexValue((String)attributes.get("border"))) && (borderValues = ValueManager.decodeComplexValue((String)attributes.get("border"))).containsKey("style") && !this.isCorrectStyleValue((String)borderValues.get("style"))) {
                result.addResultItem(1, CheckingMessages.createMessage("failIncorrectAttributeValue", "border", attributes.get("border"), xmlElement.getParent().getName(), xmlElement.getName(), errorText), "INCORRECT_ATTRIBUTE_VALUE", "", xmlElement);
            }
            if (attributes.get("padding") != null && !ExpressionUtil.checkIfStraightExpression(attributes.get("padding")) && !this.isCorrectComplexValue(PADDING_VALID_VALUES, ValueManager.decodeComplexValue((String)attributes.get("padding")))) {
                result.addResultItem(1, CheckingMessages.createMessage("failIncorrectAttributeValue", "padding", attributes.get("padding"), xmlElement.getParent().getName(), xmlElement.getName(), errorText), "INCORRECT_ATTRIBUTE_VALUE", "", xmlElement);
            }
            if (attributes.get("backcolor") != null && !this.isCorrectColorValue(attributes.get("backcolor"))) {
                result.addResultItem(1, CheckingMessages.createMessage("failIncorrectAttributeValue", "backcolor", attributes.get("backcolor"), xmlElement.getParent().getName(), xmlElement.getName(), errorText), "INCORRECT_ATTRIBUTE_VALUE", "", xmlElement);
            }
            if (attributes.get("forecolor") != null && !this.isCorrectColorValue(attributes.get("forecolor"))) {
                result.addResultItem(1, CheckingMessages.createMessage("failIncorrectAttributeValue", "forecolor", attributes.get("forecolor"), xmlElement.getParent().getName(), xmlElement.getName(), errorText), "INCORRECT_ATTRIBUTE_VALUE", "", xmlElement);
            }
        }
    }

    public boolean isCorrectComplexValue(List<String> validValues, Map<String, String> complexValue) {
        if (complexValue.isEmpty()) {
            return false;
        }
        for (String key : complexValue.keySet()) {
            double d;
            int value;
            if (!validValues.contains(key)) {
                return false;
            }
            if (key.equals("color") || (value = DPICalculation.calculate72DpiPixelValue(complexValue.get(key))) != 0 || (d = ValueManager.decodeDouble((String)complexValue.get(key), (double)0.0)) != 0.0) continue;
            return false;
        }
        return true;
    }

    public void checkPotentialInfiniteLoopConstilation(SimpleXMLElement xmlElement, SJRXMLCheckerResult result) {
        if ("header".equals(xmlElement.getName()) || "title".equals(xmlElement.getName()) || "footer".equals(xmlElement.getName())) {
            for (SimpleXMLElement subElement : xmlElement.getSubElements()) {
                if (!"text".equals(subElement.getName()) || subElement.getValue("text") == null || !ExpressionUtil.checkIfStraightExpression(subElement.getValue("text")) || subElement.getValue("textAdjust") != null && (subElement.getValue("textAdjust") == null || "CutText".equals(subElement.getValue("textAdjust")))) continue;
                result.addResultItem(1, CheckingMessages.createMessage("failPotentialInfiniteLoop", subElement.getName(), "textAdjust"), "POTENTIAL_INFINITE_LOOP", "textAdjust", subElement);
            }
        }
    }

    private boolean isCorrectColorValue(String color) {
        if (ParserUtil.isEmpty(color)) {
            return false;
        }
        if (!ExpressionUtil.checkIfStraightExpression(color)) {
            if (!color.startsWith("#")) {
                return false;
            }
            if (color.toCharArray().length != 7) {
                return false;
            }
            for (char c : color.replaceAll("#", "").toCharArray()) {
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
                return false;
            }
        }
        return true;
    }

    private boolean isCorrectStyleValue(String style) {
        if (ParserUtil.isEmpty(style)) {
            return true;
        }
        return BORDER_STYLE_VALID_VALUES.contains(style);
    }

    private boolean isOverlapping(SimpleXMLElement xmlElementA, SimpleXMLElement xmlElementB, SJRXMLCheckerResult result) {
        int xmlElementAX = this.getAutoCalculation().calculatePixelX(xmlElementA);
        int xmlElementAY = this.getAutoCalculation().calculatePixelY(xmlElementA);
        int xmlElementAW = this.getAutoCalculation().calculatePixelWidth(xmlElementA) - OVERLAPTOLEARANCE;
        int xmlElementAH = this.getAutoCalculation().calculatePixelHeight(xmlElementA) - OVERLAPTOLEARANCE;
        int xmlElementBX = this.getAutoCalculation().calculatePixelX(xmlElementB);
        int xmlElementBY = this.getAutoCalculation().calculatePixelY(xmlElementB);
        int xmlElementBW = this.getAutoCalculation().calculatePixelWidth(xmlElementB) - OVERLAPTOLEARANCE;
        int xmlElementBH = this.getAutoCalculation().calculatePixelHeight(xmlElementB) - OVERLAPTOLEARANCE;
        if (!this.isZeroOrNegative(xmlElementAW, xmlElementAH, xmlElementBW, xmlElementBH)) {
            if (xmlElementBX >= xmlElementAX + xmlElementAW) {
                return false;
            }
            if (xmlElementBY + xmlElementBH <= xmlElementAY) {
                return false;
            }
            if (xmlElementAX >= xmlElementBX + xmlElementBW) {
                return false;
            }
            return xmlElementAY + xmlElementAH > xmlElementBY;
        }
        return false;
    }

    private boolean isZeroOrNegative(int ... params) {
        boolean isZeroOrNegative = false;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != 0 && params[i] != -1) continue;
            isZeroOrNegative = true;
        }
        return isZeroOrNegative;
    }

    private SimpleXMLElement getParentElementWithRendering(SimpleXMLElement element) {
        if (element.getParent().getValue("rendered") != null) {
            return element.getParent();
        }
        if (!("header".equals(element.getParent().getName()) || "title".equals(element.getParent().getName()) || "footer".equals(element.getParent().getName()) || "colheader".equals(element.getParent().getName()) || "body".equals(element.getParent().getName()) || "gridcol".equals(element.getParent().getName()) || "gridfooter".equals(element.getParent().getName()) || "gridheader".equals(element.getParent().getName()) || "summary".equals(element.getParent().getName()) || "outputlayout".equals(element.getParent().getName()))) {
            return this.getParentElementWithRendering(element.getParent());
        }
        return element;
    }

    private List<SimpleXMLElement> findSubElementsRelevantForOverlapCheck(SimpleXMLElement xmlElement) {
        ArrayList<SimpleXMLElement> subElements = new ArrayList<SimpleXMLElement>();
        for (SimpleXMLElement subElem : xmlElement.getSubElements()) {
            if ("grid".equals(subElem.getName()) || "colheader".equals(subElem.getName()) || "colfooter".equals(subElem.getName()) || subElem.getValue("rendered") != null && "false".equals(subElem.getValue("rendered")) || subElem.getValue("rendered") != null && ExpressionUtil.checkIfStraightExpression(subElem.getValue("rendered")) || this.getParentElementWithRendering(subElem).getValue("rendered") != null && ExpressionUtil.checkIfStraightExpression(this.getParentElementWithRendering(subElem).getValue("rendered")) || this.getParentElementWithRendering(subElem).getValue("rendered") != null && "false".equals(this.getParentElementWithRendering(subElem).getValue("rendered"))) continue;
            subElements.add(subElem);
        }
        return subElements;
    }
}

