/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.checking.impl;

import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.checking.CheckerBase;
import org.eclnt.ccee.sjrxml.checking.CheckingMessages;
import org.eclnt.ccee.sjrxml.checking.ISJRXMLElementChecker;
import org.eclnt.ccee.sjrxml.checking.SJRXMLCheckerResult;
import org.eclnt.ccee.sjrxml.util.AutoCalculationSJRXML;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.util.valuemgmt.ValueManager;

public class OUTPUTLAYOUTChecker
extends CheckerBase
implements ISJRXMLElementChecker {
    @Override
    public void checkElementExecute(SimpleXMLElement xmlElement, SJRXMLCheckerResult result, AutoCalculationSJRXML autoCalculation) {
        int heightInt = 0;
        if (xmlElement.getValue("width") == null) {
            result.addResultItem(0, CheckingMessages.createMessage("failComponentMandatoryAttributeMissing", "width", xmlElement.getName()), "COMPONENT_MANDATORY_ATTRIBUTE_MISSING", "width", xmlElement);
        } else {
            int widthInt = DPICalculation.calculate72DpiPixelValue(xmlElement.getValue("width"));
            if (widthInt < 0) {
                result.addResultItem(0, CheckingMessages.createMessage("failComponentAttributeWithNegativeValueInExpression", "width", xmlElement.getName()), "COMPONENT_ATTRIBUTE_WITH_NEGATIVE_VALUE_INSET", "width", xmlElement);
            }
        }
        if (xmlElement.getValue("height") == null) {
            result.addResultItem(0, CheckingMessages.createMessage("failComponentMandatoryAttributeMissing", "height", xmlElement.getName()), "COMPONENT_MANDATORY_ATTRIBUTE_MISSING", "height", xmlElement);
        } else {
            heightInt = DPICalculation.calculate72DpiPixelValue(xmlElement.getValue("height"));
            if (heightInt < 0) {
                result.addResultItem(0, CheckingMessages.createMessage("failComponentAttributeWithNegativeValueInExpression", "height", xmlElement.getName()), "COMPONENT_ATTRIBUTE_WITH_NEGATIVE_VALUE_INSET", "height", xmlElement);
            }
        }
        if (xmlElement.getValue("margin") != null && !this.isCorrectComplexValue(MARGIN_VALID_VALUES, ValueManager.decodeComplexValue((String)xmlElement.getValue("margin")))) {
            result.addResultItem(0, CheckingMessages.createMessage("failIncorrectAttributeValue", "margin", xmlElement.getValue("margin"), xmlElement.getName()), "INCORRECT_ATTRIBUTE_VALUE", "", xmlElement);
        }
        int childrenSummaryHeight = 0;
        boolean isInBody = false;
        for (SimpleXMLElement child : xmlElement.getSubElements()) {
            if ("background".equals(child.getName())) continue;
            if ("body".equals(child.getName())) {
                isInBody = true;
                for (SimpleXMLElement band : child.getSubElements()) {
                    childrenSummaryHeight += autoCalculation.calculatePixelHeight(band);
                }
            }
            if (isInBody) continue;
            childrenSummaryHeight += autoCalculation.calculatePixelHeight(child);
        }
        if (childrenSummaryHeight > heightInt) {
            result.addResultItem(0, CheckingMessages.createMessage("failSumarryChildrenHeight", "height", xmlElement.getName()), "INCORRECT_SUMMARY_CHILDREN_HEIGHT", "height", xmlElement);
        }
    }
}

