/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.parsing.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.IConstantsAttributeNames;
import org.eclnt.ccee.sjrxml.IConstantsDefaultAttributeValues;
import org.eclnt.ccee.sjrxml.IConstantsElementNames;
import org.eclnt.ccee.sjrxml.parsing.ICCXMLMacro;
import org.eclnt.ccee.sjrxml.parsing.IJRXMLMacro;
import org.eclnt.ccee.sjrxml.parsing.JRXMLContext;
import org.eclnt.ccee.sjrxml.parsing.StylesGenerator;
import org.eclnt.ccee.sjrxml.parsing.elements.CCXMLMacroFactory;
import org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil;
import org.eclnt.ccee.sjrxml.parsing.elements.PropertyExpressionUtil;
import org.eclnt.ccee.sjrxml.util.AutoCalculationSJRXML;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.ccee.sjrxml.util.IPixelPositionAccess;
import org.eclnt.util.valuemgmt.ValueManager;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class BaseElement
implements IJRXMLMacro,
ICCXMLMacro,
IPixelPositionAccess,
IConstantsAttributeNames,
IConstantsDefaultAttributeValues,
IConstantsElementNames {
    BaseElement m_parent;
    String m_elementName;
    List<BaseElement> m_children = new ArrayList<BaseElement>();
    Map<String, String> m_attributes = new HashMap<String, String>();
    AutoCalculationSJRXML m_autoCalculationSJRXML;
    SimpleXMLElement m_xmlElement;

    public String getElementName() {
        return this.m_elementName;
    }

    public List<BaseElement> getChildren() {
        return this.m_children;
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public BaseElement getParent() {
        return this.m_parent;
    }

    public BaseElement getParentElement() {
        return this.m_parent;
    }

    @Override
    public void setAutoCalculationSJRXML(AutoCalculationSJRXML autoCalculationSJRXML) {
        this.m_autoCalculationSJRXML = autoCalculationSJRXML;
    }

    public AutoCalculationSJRXML getAutoCalculationSJRXML() {
        return this.m_autoCalculationSJRXML;
    }

    public void addChild(BaseElement child) {
        this.m_children.add(child);
        child.m_parent = this;
    }

    public void addChild(ICCXMLMacro child) {
        this.addChild((BaseElement)child);
    }

    @Override
    public int getX() {
        return ValueManager.decodeInt((String)this.m_attributes.get("x"), (int)0);
    }

    @Override
    public int getY() {
        return ValueManager.decodeInt((String)this.m_attributes.get("y"), (int)0);
    }

    @Override
    public int getWidth() {
        return ValueManager.decodeInt((String)this.m_attributes.get("width"), (int)0);
    }

    @Override
    public int getHeight() {
        return ValueManager.decodeInt((String)this.m_attributes.get("height"), (int)0);
    }

    public void fillAttribute(SimpleXMLElement element, String attrName) {
        this.m_xmlElement = element;
        if (element.getValue(attrName) != null) {
            if ("height".equals(attrName)) {
                this.fillAttributeHeight(element);
            } else if ("width".equals(attrName)) {
                this.fillAttributeWidth(element);
            } else if ("x".equals(attrName) || "y".equals(attrName) || "cellHeight".equals(attrName) || "columnsHeaderHeight".equals(attrName) || "columnsCellHeight".equals(attrName)) {
                int pixelsInt = DPICalculation.calculate72DpiPixelValue(element.getValue(attrName));
                String pixels = String.valueOf(pixelsInt);
                this.getAttributes().put(attrName, pixels);
            } else {
                this.getAttributes().put(attrName, element.getValue(attrName));
            }
        }
    }

    private void fillAttributeHeight(SimpleXMLElement element) {
        this.getAttributes().put("height", element.getValue("height"));
        int pixelsInt = this.getAutoCalculationSJRXML().calculatePixelHeight(element);
        String pixels = String.valueOf(pixelsInt);
        this.getAttributes().put("height", pixels);
    }

    private void fillAttributeWidth(SimpleXMLElement element) {
        this.getAttributes().put("width", element.getValue("width"));
        int pixelsInt = this.getAutoCalculationSJRXML().calculatePixelWidth(element);
        String pixels = String.valueOf(pixelsInt);
        this.getAttributes().put("width", pixels);
    }

    public String calculateRenderedAttributeSJRXMLValue(JRXMLContext context) {
        String attributeValue;
        String result = "true";
        if (this.getAttributes().containsKey("rendered") && (attributeValue = this.m_attributes.get("rendered")) != null) {
            boolean isExpression = ExpressionUtil.checkIfStraightExpression(attributeValue);
            if (isExpression) {
                result = ExpressionUtil.parseAndBuildExpression(context, attributeValue);
            } else {
                return attributeValue;
            }
        }
        return result;
    }

    public void setAttributeinJDOMElement(Element element, String attributeName, JRXMLContext context) {
        this.setAttributeInJDOMElement(element, new Attribute(attributeName, this.m_attributes.get(attributeName)), context);
    }

    public void setAttributeInJDOMElement(Element element, Attribute attribute, JRXMLContext context) {
        if (!PropertyExpressionUtil.addPropertyExpressionIfNeeded(element, attribute, context)) {
            element.setAttribute(attribute);
        }
    }

    public String getAttributeValue(String attribute) {
        return this.m_attributes.get(attribute);
    }

    @Override
    public void parseCCXml(SimpleXMLElement ccXmlElement) {
        this.m_elementName = ccXmlElement.getName();
        this.parseCCXmlChildren(ccXmlElement);
        this.transferXmlAttributes(ccXmlElement);
    }

    protected final void transferXmlAttributes(SimpleXMLElement ccXmlElement) {
        Map attributes = ccXmlElement.getValueMap();
        this.addMissingAttributes(attributes);
        ArrayList attributeKeys = new ArrayList(attributes.keySet());
        Collections.sort(attributeKeys, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                s1 = "height".equals(s1) || "width".equals(s1) ? "B" + s1 : "A" + s1;
                s2 = "height".equals(s2) || "width".equals(s2) ? "B" + s2 : "A" + s2;
                return s1.compareTo(s2);
            }
        });
        for (String attribute : attributeKeys) {
            this.fillAttribute(ccXmlElement, attribute);
        }
    }

    private void addMissingAttributes(Map<String, String> attributes) {
        Set<String> autoAttributes = this.findAttributesWithAutoCalculation();
        HashSet usedAttributes = new HashSet();
        attributes.forEach((k, v) -> usedAttributes.add(k));
        for (String aa : autoAttributes) {
            if (usedAttributes.contains(aa)) continue;
            attributes.put(aa, "auto");
        }
    }

    protected Set<String> findAttributesWithAutoCalculation() {
        HashSet<String> result = new HashSet<String>();
        result.add("width");
        result.add("height");
        return result;
    }

    protected final void parseCCXmlChildren(SimpleXMLElement ccXmlElement) {
        for (SimpleXMLElement child : ccXmlElement.getSubElements()) {
            ICCXMLMacro ccXmlMacro = CCXMLMacroFactory.createCCXMLMacro(child.getName(), this.getAutoCalculationSJRXML());
            ccXmlMacro.parseCCXml(child);
            this.addChild(ccXmlMacro);
        }
    }

    protected List<IPixelPositionAccess> buildChildrenListForSizing() {
        ArrayList<IPixelPositionAccess> ppas = new ArrayList<IPixelPositionAccess>();
        for (BaseElement ppa : this.getChildren()) {
            ppas.add(ppa);
        }
        return ppas;
    }

    protected void fillReportElementAttributes(Element reportElement, JRXMLContext context) {
        reportElement.setAttribute("mode", "Transparent");
        if (this.m_attributes.get("height") != null) {
            reportElement.setAttribute(new Attribute("height", this.m_attributes.get("height")));
        }
        if (this.m_attributes.get("width") != null) {
            reportElement.setAttribute(new Attribute("width", this.m_attributes.get("width")));
        }
        if (this.m_attributes.get("x") == null) {
            reportElement.setAttribute(new Attribute("x", "0"));
        } else {
            reportElement.setAttribute(new Attribute("x", this.m_attributes.get("x")));
        }
        if (this.m_attributes.get("y") == null) {
            reportElement.setAttribute(new Attribute("y", "0"));
        } else {
            reportElement.setAttribute(new Attribute("y", this.m_attributes.get("y")));
        }
        if (this.m_attributes.containsKey("positionType")) {
            reportElement.setAttribute("positionType", this.m_attributes.get("positionType"));
        } else {
            reportElement.setAttribute("positionType", "Float");
        }
        if (this.m_attributes.get("border") != null) {
            Map borderAttributes = ValueManager.decodeComplexValue((String)this.m_attributes.get("border"));
            String styleName = new StylesGenerator().createBorderStyleAndReturnName(this.getElementName() + "BorderStyle", context, this.m_attributes, borderAttributes);
            reportElement.setAttribute(new Attribute("style", styleName));
        }
        if (this.m_attributes.get("isRemoveLineWhenBlank") != null && !this.m_attributes.get("isRemoveLineWhenBlank").isEmpty()) {
            reportElement.setAttribute(new Attribute("isRemoveLineWhenBlank", this.m_attributes.get("isRemoveLineWhenBlank")));
        } else {
            reportElement.setAttribute(new Attribute("isRemoveLineWhenBlank", "true"));
        }
        if (this.m_attributes.get("rendered") != null) {
            Element printWhenExpression = new Element("printWhenExpression");
            printWhenExpression.setContent((Content)new CDATA(this.calculateRenderedAttributeSJRXMLValue(context)));
            reportElement.addContent((Content)printWhenExpression);
        }
    }
}

