/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.parsing.elements;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.IConstantsDefaultAttributeValues;
import org.eclnt.ccee.sjrxml.checking.SJRXMLChecker;
import org.eclnt.ccee.sjrxml.checking.SJRXMLCheckerResult;
import org.eclnt.ccee.sjrxml.checking.SJRXMLCheckerResultItem;
import org.eclnt.ccee.sjrxml.parsing.ICCXMLMacro;
import org.eclnt.ccee.sjrxml.parsing.JRXMLContext;
import org.eclnt.ccee.sjrxml.parsing.ParserUtil;
import org.eclnt.ccee.sjrxml.parsing.elements.BaseElement;
import org.eclnt.ccee.sjrxml.parsing.elements.CCXMLMacroFactory;
import org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil;
import org.eclnt.ccee.sjrxml.util.AutoCalculationSJRXML;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.util.log.CLog;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class OUTPUTLAYOUTElement
extends BaseElement {
    private String m_refclass;
    private static String m_defaultFont;

    @Override
    public boolean validate() {
        return false;
    }

    @Override
    public Element generateJRXMLElement(JRXMLContext context) {
        context.setDefaultFont(m_defaultFont);
        int counter = 0;
        Element jasperReport = this.getJasperReportElement();
        context.setRefclass(this.m_refclass);
        for (BaseElement child : this.getChildren()) {
            jasperReport.addContent((Content)child.generateJRXMLElement(context));
        }
        for (String styleName : context.getStyles().keySet()) {
            Element style = context.getStyles().get(styleName);
            jasperReport.addContent(counter, (Content)style);
            ++counter;
        }
        if (context.getSubDataSets().size() > 0) {
            for (JRXMLContext.SubDataSet sds : context.getSubDataSets()) {
                Element dsField;
                Element grid = new Element("subDataset");
                if (sds.getClazz().equals(Map.class.getName())) {
                    grid.setAttribute(new Attribute("name", sds.getName()));
                } else {
                    String[] subDataSetAttributes = sds.getClazz().split("\\.");
                    String subDataSetName = StringUtils.uncapitalize((String)subDataSetAttributes[1]) + "sDataSet";
                    grid.setAttribute(new Attribute("name", subDataSetName));
                }
                Element queryString = new Element("queryString");
                queryString.setContent((Content)new CDATA(""));
                grid.addContent((Content)queryString);
                if (sds.getClazz().equals(Map.class.getName())) {
                    dsField = new Element("field");
                    String dsFieldName = ExpressionUtil.isolateVariablesFromExpression(sds.getName());
                    dsField.setAttribute(new Attribute("name", "data"));
                    dsField.setAttribute(new Attribute("class", sds.getClazz()));
                    grid.addContent((Content)dsField);
                    jasperReport.addContent(counter, (Content)grid);
                    ++counter;
                    if (context.getGridColTotalAttributes().size() <= 0) continue;
                    for (int i = 0; i < context.getGridColTotalAttributes().size(); ++i) {
                        Element gridColSumVariable = new Element("variable");
                        if (context.getGridColTotalAttributes().get(i).get("calculationReference") != null) {
                            gridColSumVariable.setAttribute("name", context.getGridColTotalAttributes().get(i).get("calculationReference"));
                        }
                        gridColSumVariable.setAttribute("class", BigDecimal.class.getName());
                        if (context.getGridColTotalAttributes().get(i).get("calculationType") != null) {
                            gridColSumVariable.setAttribute("calculation", context.getGridColTotalAttributes().get(i).get("calculationType"));
                        } else {
                            gridColSumVariable.setAttribute("calculation", "Sum");
                        }
                        Element variableExpression = new Element("variableExpression");
                        if (context.getGridColTotalAttributes().get(i).get("calculationReference").contains(".")) {
                            String expression = "#{" + context.getGridColTotalAttributes().get(i).get("calculationReference") + "}";
                            String builtExpression = ExpressionUtil.parseAndBuildExpression(context, expression);
                            variableExpression.setContent((Content)new CDATA(builtExpression));
                        } else {
                            variableExpression.setContent((Content)new CDATA("$F{data}.get(\"bigdecimal(" + context.getGridColTotalAttributes().get(i).get("calculationReference") + ")\")"));
                        }
                        gridColSumVariable.addContent((Content)variableExpression);
                        Element initialValueExpression = new Element("initialValueExpression");
                        initialValueExpression.setContent((Content)new CDATA("0"));
                        gridColSumVariable.addContent((Content)initialValueExpression);
                        grid.addContent((Content)gridColSumVariable);
                    }
                    continue;
                }
                dsField = new Element("field");
                dsField.setAttribute(new Attribute("name", "_THIS"));
                dsField.setAttribute(new Attribute("class", sds.getClazz()));
                grid.addContent((Content)dsField);
                jasperReport.addContent(counter, (Content)grid);
                ++counter;
            }
        }
        Element field = new Element("field");
        field.setAttribute(new Attribute("name", "data"));
        field.setAttribute(new Attribute("class", this.m_refclass));
        jasperReport.addContent(counter, (Content)field);
        ++counter;
        return jasperReport;
    }

    public String getRefclss() {
        return this.m_refclass;
    }

    public void setRefclass(String refclass) {
        this.m_refclass = refclass;
    }

    public Document generateJRXMLDocument() {
        Document doc = new Document();
        JRXMLContext context = new JRXMLContext();
        Element root = this.generateJRXMLElement(context);
        doc.setRootElement(root);
        return doc;
    }

    public static OUTPUTLAYOUTElement generateCCXMLElement(SimpleXMLElement rootElement) {
        SJRXMLCheckerResult result = new SJRXMLChecker().checkXml(rootElement);
        for (SJRXMLCheckerResultItem item : result.getItems()) {
            CLog.L.log(CLog.LL_ERR, "ERROR: " + item.getAttributeName() + " " + item.getErrorText() + " " + item.getOneXmlElement().getName());
        }
        AutoCalculationSJRXML autoCalculationSJRXML = new AutoCalculationSJRXML(rootElement);
        OUTPUTLAYOUTElement ole = new OUTPUTLAYOUTElement();
        ole.setAutoCalculationSJRXML(autoCalculationSJRXML);
        String width = OUTPUTLAYOUTElement.transferAttributeValueInPixels(rootElement, "width");
        ole.getAttributes().put("width", width);
        String height = OUTPUTLAYOUTElement.transferAttributeValueInPixels(rootElement, "height");
        ole.getAttributes().put("height", height);
        ole.getAttributes().put("name", rootElement.getValue("name"));
        ole.getAttributes().put("margin", rootElement.getValue("margin"));
        ole.getAttributes().put("storeId", rootElement.getValue("storeId"));
        Map<String, String> marginsMap = ParserUtil.decodeBorder(rootElement.getValue("margin"));
        if (marginsMap.containsKey("left")) {
            ole.getAttributes().put("leftMargin", marginsMap.get("left"));
        }
        if (marginsMap.containsKey("right")) {
            ole.getAttributes().put("rightMargin", marginsMap.get("right"));
        }
        if (marginsMap.containsKey("top")) {
            ole.getAttributes().put("topMargin", marginsMap.get("top"));
        }
        if (marginsMap.containsKey("bottom")) {
            ole.getAttributes().put("bottomMargin", marginsMap.get("bottom"));
        }
        ole.setRefclass(rootElement.getValue("refclass"));
        OUTPUTLAYOUTElement.parseAndOrderElements(rootElement.getSubElements(), ole);
        m_defaultFont = !ParserUtil.isEmpty(rootElement.getValue("defaultfont")) ? (IConstantsDefaultAttributeValues.DEFAULTFONT_VALID_VALUES.contains(rootElement.getValue("defaultfont")) ? rootElement.getValue("defaultfont") : (ExpressionUtil.checkIfStraightExpression(rootElement.getValue("defaultfont")) ? rootElement.getValue("defaultfont") : null)) : null;
        return ole;
    }

    private static List<SimpleXMLElement> sortXMLElements(List<SimpleXMLElement> elements, final String[] order) {
        ArrayList<SimpleXMLElement> result = new ArrayList<SimpleXMLElement>(elements);
        final ArrayList<String> listOrder = new ArrayList<String>();
        for (String name : order) {
            listOrder.add(name);
        }
        Collections.sort(result, new Comparator<SimpleXMLElement>(){

            @Override
            public int compare(SimpleXMLElement o1, SimpleXMLElement o2) {
                String s1 = o1.getName();
                String s2 = o2.getName();
                int index1 = listOrder.indexOf(s1);
                if (index1 < 0) {
                    throw new Error("Could not find name: " + s1 + " in " + order);
                }
                int index2 = listOrder.indexOf(s2);
                if (index2 < 0) {
                    throw new Error("Could not find name: " + s2 + " in " + order);
                }
                return index1 - index2;
            }
        });
        return result;
    }

    private static void parseAndOrderElements(List<SimpleXMLElement> elements, OUTPUTLAYOUTElement ole) {
        String[] elementNames = new String[]{"background", "title", "header", "body", "footer", "summary"};
        List<SimpleXMLElement> sortedElements = OUTPUTLAYOUTElement.sortXMLElements(elements, elementNames);
        for (SimpleXMLElement element : sortedElements) {
            ICCXMLMacro ccXmlMacro = CCXMLMacroFactory.createCCXMLMacro(element.getName(), ole.getAutoCalculationSJRXML());
            ccXmlMacro.parseCCXml(element);
            ole.addChild(ccXmlMacro);
        }
    }

    private static String transferAttributeValueInPixels(SimpleXMLElement element, String attName) {
        String resultValue = null;
        if (element.getValue(attName) != null) {
            String value = element.getValue(attName);
            if (value.endsWith("cm") || value.endsWith("mm")) {
                int calculatedAttribute = DPICalculation.calculate72DpiPixelValue(value);
                resultValue = String.valueOf(calculatedAttribute);
            } else {
                resultValue = element.getValue(attName);
            }
        }
        return resultValue;
    }

    private Element getJasperReportElement() {
        Namespace ns = Namespace.getNamespace((String)"xxx", (String)"http://jasperreports.sourceforge.net/jasperreports");
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Namespace jr = Namespace.getNamespace((String)"jr", (String)"http://jasperreports.sourceforge.net/jasperreports/components");
        Element jasperReport = new Element("jasperReport");
        jasperReport.addNamespaceDeclaration(ns);
        jasperReport.addNamespaceDeclaration(xsi);
        jasperReport.setAttribute("schemaLocation", "http://jasperreports.sourceforge.net/jasperreports  http://jasperreports.sourceforge.net/xsd/jasperreport.xsd", xsi);
        jasperReport.setAttribute("whenNoDataType", "AllSectionsNoDetail");
        if (this.m_attributes.containsKey("leftMargin")) {
            jasperReport.setAttribute("leftMargin", (String)this.m_attributes.get("leftMargin"));
        } else {
            jasperReport.setAttribute("leftMargin", "0");
        }
        int leftMargin = DPICalculation.calculate72DpiPixelValue(jasperReport.getAttribute("leftMargin").getValue());
        if (this.m_attributes.containsKey("rightMargin")) {
            jasperReport.setAttribute("rightMargin", (String)this.m_attributes.get("rightMargin"));
        } else {
            jasperReport.setAttribute("rightMargin", "0");
        }
        int rightMargin = DPICalculation.calculate72DpiPixelValue(jasperReport.getAttribute("rightMargin").getValue());
        if (this.m_attributes.containsKey("topMargin")) {
            jasperReport.setAttribute("topMargin", (String)this.m_attributes.get("topMargin"));
        } else {
            jasperReport.setAttribute("topMargin", "0");
        }
        if (this.m_attributes.containsKey("bottomMargin")) {
            jasperReport.setAttribute("bottomMargin", (String)this.m_attributes.get("bottomMargin"));
        } else {
            jasperReport.setAttribute("bottomMargin", "0");
        }
        jasperReport.setAttribute("name", (String)this.m_attributes.get("name"));
        jasperReport.setAttribute("pageWidth", (String)this.m_attributes.get("width"));
        jasperReport.setAttribute("pageHeight", (String)this.m_attributes.get("height"));
        int pageWidth = Integer.parseInt((String)this.m_attributes.get("width"));
        jasperReport.setAttribute("columnWidth", pageWidth - (leftMargin + rightMargin) + "");
        return jasperReport;
    }
}

