/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.IConstantsElementNames;
import org.eclnt.ccee.sjrxml.util.AutoCalculationFont;
import org.eclnt.ccee.sjrxml.util.AutoCalculationGeneral;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.ccee.sjrxml.util.IPixelPositionAccess;
import org.eclnt.ccee.sjrxml.util.Inset;
import org.eclnt.util.valuemgmt.ValueManager;

public class AutoCalculationSJRXML
implements IConstantsElementNames {
    SimpleXMLElement m_rootElement;
    Map<SimpleXMLElement, PixelPositionAccessBase> m_ppas = new HashMap<SimpleXMLElement, PixelPositionAccessBase>();

    public AutoCalculationSJRXML(SimpleXMLElement rootElement) {
        this.m_rootElement = rootElement;
    }

    public void reset() {
        this.m_ppas.clear();
    }

    public int calculatePixelX(SimpleXMLElement element) {
        return this.getPPAForElement(element).getX();
    }

    public int calculatePixelY(SimpleXMLElement element) {
        return this.getPPAForElement(element).getY();
    }

    public int calculatePixelHeight(SimpleXMLElement element) {
        return this.getPPAForElement(element).getHeight();
    }

    public int calculatePixelWidth(SimpleXMLElement element) {
        return this.getPPAForElement(element).getWidth();
    }

    public int calculateGRIDHeight(SimpleXMLElement element) {
        PixelPositionAccessGRID ppa = (PixelPositionAccessGRID)this.getPPAForElement(element);
        return ppa.getHeight();
    }

    public int calculateGRIDCellContentHeight(SimpleXMLElement element) {
        PixelPositionAccessGRID ppa = (PixelPositionAccessGRID)this.getPPAForElement(element);
        return ppa.getGridCellContentHeight();
    }

    public int calculateGRIDCellHeaderHeight(SimpleXMLElement element) {
        PixelPositionAccessGRID ppa = (PixelPositionAccessGRID)this.getPPAForElement(element);
        return ppa.getGridCellHeaderHeight();
    }

    public int calculateGRIDHeaderHeight(SimpleXMLElement element) {
        PixelPositionAccessGRID ppa = (PixelPositionAccessGRID)this.getPPAForElement(element);
        return ppa.getGridHeaderHeight();
    }

    public int calculateGRIDFooterHeight(SimpleXMLElement element) {
        PixelPositionAccessGRID ppa = (PixelPositionAccessGRID)this.getPPAForElement(element);
        return ppa.getGridFooterHeight();
    }

    public int calculateGRIDCOLColHeaderHeightForAllHeaderTypes(SimpleXMLElement gridColElement) {
        PixelPositionAccessGRIDCOL ppa = (PixelPositionAccessGRIDCOL)this.getPPAForElement(gridColElement);
        return ppa.getColHeaderHeightForAllHeaderTypes();
    }

    public int calculateGRIDCOLHeaderHeight(SimpleXMLElement element) {
        PixelPositionAccessGRIDCOL ppa = (PixelPositionAccessGRIDCOL)this.getPPAForElement(element);
        return ppa.getHeaderHeight();
    }

    public int calculateGRIDCOLColHeaderHeight(SimpleXMLElement element) {
        PixelPositionAccessGRIDCOL ppa = (PixelPositionAccessGRIDCOL)this.getPPAForElement(element);
        return ppa.getColHeaderHeight();
    }

    public int calculateGRIDCOLColFooterHeight(SimpleXMLElement element) {
        PixelPositionAccessGRIDCOL ppa = (PixelPositionAccessGRIDCOL)this.getPPAForElement(element);
        return ppa.getColFooterHeight();
    }

    public int calculateGRIDCOLContentHeight(SimpleXMLElement element) {
        PixelPositionAccessGRIDCOL ppa = (PixelPositionAccessGRIDCOL)this.getPPAForElement(element);
        return ppa.getHeight();
    }

    private PixelPositionAccessBase getPPAForElement(SimpleXMLElement element) {
        PixelPositionAccessBase result = this.m_ppas.get(element);
        if (result == null) {
            switch (element.getName()) {
                case "title": 
                case "header": 
                case "body": 
                case "footer": 
                case "band": 
                case "summary": 
                case "background": {
                    result = new PixelPositionAccessSection(element);
                    break;
                }
                case "text": {
                    result = new PixelPositionAccessTEXT(element);
                    break;
                }
                case "grid": {
                    result = new PixelPositionAccessGRID(element);
                    break;
                }
                case "gridcol": {
                    result = new PixelPositionAccessGRIDCOL(element);
                    break;
                }
                case "colheader": {
                    result = new PixelPositionAccessCOLHEADER(element);
                    break;
                }
                case "colfooter": {
                    result = new PixelPositionAccessCOLFOOTER(element);
                    break;
                }
                default: {
                    result = new PixelPositionAccessBase(element);
                }
            }
            this.m_ppas.put(element, result);
        }
        return result;
    }

    private int calculateLayoutWidth() {
        int result = DPICalculation.calculate72DpiPixelValue(this.m_rootElement.getValue("width"));
        Inset is = new Inset(this.m_rootElement.getValue("margin"));
        result -= is.getPixelLeft();
        return result -= is.getPixelRight();
    }

    public class PixelPositionAccessBase
    implements IPixelPositionAccess {
        SimpleXMLElement i_element;
        int i_widthMinValue = 15;
        int i_heightMinValue = 14;
        String i_widthAttribute = "width";
        String i_heightAttribute = "height";

        public PixelPositionAccessBase(SimpleXMLElement element) {
            this.i_element = element;
        }

        @Override
        public int getX() {
            return DPICalculation.calculate72DpiPixelValue(this.i_element.getValue("x"));
        }

        @Override
        public int getY() {
            return DPICalculation.calculate72DpiPixelValue(this.i_element.getValue("y"));
        }

        @Override
        public int getWidth() {
            String s = this.i_element.getValue(this.i_widthAttribute);
            if (!ValueManager.isEmpty((String)s) && !"auto".equals(s)) {
                return DPICalculation.calculate72DpiPixelValue(s);
            }
            return this.calculateAutoWidth();
        }

        @Override
        public int getHeight() {
            String s = this.i_element.getValue(this.i_heightAttribute);
            if (!ValueManager.isEmpty((String)s) && !"auto".equals(s)) {
                return DPICalculation.calculate72DpiPixelValue(s);
            }
            return this.calculateAutoHeight();
        }

        protected int calculateAutoHeight() {
            return AutoCalculationGeneral.calculatePixelHeightFromElement(this.i_element.getName(), this.i_element.getValueMap(), this.getPPAChildren(this.i_element), this.i_heightMinValue);
        }

        protected int calculateAutoWidth() {
            return AutoCalculationGeneral.calculatePixelWidthFromElement(this.i_element.getName(), this.i_element.getValueMap(), this.getPPAChildren(this.i_element), this.i_widthMinValue);
        }

        protected List<IPixelPositionAccess> getPPAChildren(SimpleXMLElement element) {
            ArrayList<IPixelPositionAccess> result = new ArrayList<IPixelPositionAccess>();
            for (SimpleXMLElement child : element.getSubElements()) {
                PixelPositionAccessBase ppa = AutoCalculationSJRXML.this.getPPAForElement(child);
                result.add(ppa);
            }
            return result;
        }
    }

    public class PixelPositionAccessGRID
    extends PixelPositionAccessBase {
        public PixelPositionAccessGRID(SimpleXMLElement element) {
            super(element);
            this.i_heightMinValue = 14;
            this.i_widthMinValue = 15;
        }

        @Override
        protected int calculateAutoHeight() {
            int result = 0;
            result += this.getGridHeaderHeight();
            result += this.getGridCellHeaderHeight();
            result += this.getGridColHeaderHeight();
            result += this.getGridCellContentHeight();
            result += this.getGridColFooterHeight();
            return result += this.getGridFooterHeight();
        }

        public int getGridCellContentHeight() {
            return super.calculateAutoHeight();
        }

        public int getGridHeaderHeight() {
            SimpleXMLElement gridHeader = this.i_element.getSubElement("gridheader");
            if (gridHeader != null) {
                PixelPositionAccessBase ppa = AutoCalculationSJRXML.this.getPPAForElement(gridHeader);
                return ppa.getHeight();
            }
            return 0;
        }

        public int getGridFooterHeight() {
            SimpleXMLElement gridFooter = this.i_element.getSubElement("gridfooter");
            if (gridFooter != null) {
                PixelPositionAccessBase ppa = AutoCalculationSJRXML.this.getPPAForElement(gridFooter);
                return ppa.getHeight();
            }
            return 0;
        }

        public int getGridColHeaderHeight() {
            int result = 0;
            for (IPixelPositionAccess ppa : this.getPPAChildren(this.i_element)) {
                PixelPositionAccessGRIDCOL ppagc;
                if (!(ppa instanceof PixelPositionAccessGRIDCOL) || (ppagc = (PixelPositionAccessGRIDCOL)ppa).getColHeaderHeight() <= result) continue;
                result = ppagc.getColHeaderHeight();
            }
            return result;
        }

        public int getGridColFooterHeight() {
            int result = 0;
            for (IPixelPositionAccess ppa : this.getPPAChildren(this.i_element)) {
                PixelPositionAccessGRIDCOL ppagc;
                if (!(ppa instanceof PixelPositionAccessGRIDCOL) || (ppagc = (PixelPositionAccessGRIDCOL)ppa).getColFooterHeight() <= result) continue;
                result = ppagc.getColFooterHeight();
            }
            return result;
        }

        public int getGridCellHeaderHeight() {
            int result = 0;
            for (IPixelPositionAccess ppa : this.getPPAChildren(this.i_element)) {
                PixelPositionAccessGRIDCOL ppagc;
                if (!(ppa instanceof PixelPositionAccessGRIDCOL) || (ppagc = (PixelPositionAccessGRIDCOL)ppa).getHeaderHeight() <= result) continue;
                result = ppagc.getHeaderHeight();
            }
            return result;
        }

        @Override
        protected List<IPixelPositionAccess> getPPAChildren(SimpleXMLElement element) {
            ArrayList<PixelPositionAccessBase> result = new ArrayList<PixelPositionAccessBase>();
            for (SimpleXMLElement child : this.i_element.getSubElements()) {
                switch (child.getName()) {
                    case "gridcol": {
                        result.add(AutoCalculationSJRXML.this.getPPAForElement(child));
                        break;
                    }
                }
            }
            return super.getPPAChildren(element);
        }
    }

    public class PixelPositionAccessGRIDCOL
    extends PixelPositionAccessBase {
        public PixelPositionAccessGRIDCOL(SimpleXMLElement element) {
            super(element);
            this.i_heightMinValue = 14;
            this.i_widthMinValue = 15;
        }

        @Override
        public int getHeight() {
            String parentCellHeight = this.i_element.getParent().getValue("columnsCellHeight");
            if (ValueManager.isEmpty((String)parentCellHeight) || "auto".equals(parentCellHeight)) {
                return super.getHeight();
            }
            return DPICalculation.calculate72DpiPixelValue(parentCellHeight);
        }

        public int getHeaderHeight() {
            String parentHeaderHeight = this.i_element.getParent().getValue("columnsHeaderHeight");
            if (ValueManager.isEmpty((String)parentHeaderHeight) || "auto".equals(parentHeaderHeight)) {
                SimpleXMLElement gridElement = this.i_element.getParent();
                List gridCols = gridElement.getSubElements("gridcol");
                int max = 0;
                for (SimpleXMLElement gridCol : gridCols) {
                    PixelPositionAccessGRIDCOL ppa = (PixelPositionAccessGRIDCOL)AutoCalculationSJRXML.this.getPPAForElement(gridCol);
                    int height = AutoCalculationFont.calculatePixelHeightFromElement(gridCol.getValueMap());
                    if (height <= max) continue;
                    max = height;
                }
                return max;
            }
            return DPICalculation.calculate72DpiPixelValue(parentHeaderHeight);
        }

        public int getColHeaderHeight() {
            SimpleXMLElement parentElement = this.i_element.getParent();
            List gridColChildren = parentElement.getSubElements("gridcol");
            int result = 0;
            for (SimpleXMLElement gridColChild : gridColChildren) {
                PixelPositionAccessGRIDCOL ppaGC = (PixelPositionAccessGRIDCOL)AutoCalculationSJRXML.this.getPPAForElement(gridColChild);
                if (ppaGC.getColHeaderHeightSingleCol() <= result) continue;
                result = ppaGC.getColHeaderHeightSingleCol();
            }
            return result;
        }

        public int getColHeaderHeightForAllHeaderTypes() {
            return Math.max(this.getColHeaderHeight(), this.getHeaderHeight());
        }

        public int getColHeaderHeightSingleCol() {
            SimpleXMLElement colHeader = this.i_element.getSubElement("colheader");
            if (colHeader != null) {
                return ((PixelPositionAccessCOLHEADER)AutoCalculationSJRXML.this.getPPAForElement(colHeader)).getHeightSingleCol();
            }
            return 0;
        }

        public int getColFooterHeight() {
            SimpleXMLElement parentElement = this.i_element.getParent();
            List gridColChildren = parentElement.getSubElements("gridcol");
            int result = 0;
            for (SimpleXMLElement gridColChild : gridColChildren) {
                PixelPositionAccessGRIDCOL ppaGC = (PixelPositionAccessGRIDCOL)AutoCalculationSJRXML.this.getPPAForElement(gridColChild);
                if (ppaGC.getColFooterHeightSingleCol() <= result) continue;
                result = ppaGC.getColFooterHeightSingleCol();
            }
            return result;
        }

        public int getColFooterHeightSingleCol() {
            SimpleXMLElement colFooter = this.i_element.getSubElement("colfooter");
            if (colFooter != null) {
                return ((PixelPositionAccessCOLFOOTER)AutoCalculationSJRXML.this.getPPAForElement(colFooter)).getHeightSingleCol();
            }
            return 0;
        }

        @Override
        public int getX() {
            SimpleXMLElement parentElement = this.i_element.getParent();
            List gridColElements = parentElement.getSubElements("gridcol");
            int x = 0;
            for (SimpleXMLElement gridColElement : gridColElements) {
                if (gridColElement == this.i_element) {
                    return x;
                }
                x += AutoCalculationSJRXML.this.getPPAForElement(gridColElement).getWidth();
            }
            throw new Error("Must never happen!");
        }

        @Override
        protected int calculateAutoWidth() {
            return AutoCalculationGeneral.calculatePixelWidthFromElement(this.i_element.getName(), this.i_element.getValueMap(), this.getPPAChildrenForWidthCalculation(this.i_element), this.i_widthMinValue);
        }

        @Override
        protected List<IPixelPositionAccess> getPPAChildren(SimpleXMLElement element) {
            ArrayList<IPixelPositionAccess> result = new ArrayList<IPixelPositionAccess>();
            block7: for (SimpleXMLElement child : this.i_element.getSubElements()) {
                switch (child.getName()) {
                    case "colfooter": 
                    case "colheader": {
                        continue block7;
                    }
                }
                result.add(AutoCalculationSJRXML.this.getPPAForElement(child));
            }
            return result;
        }

        protected List<IPixelPositionAccess> getPPAChildrenForWidthCalculation(SimpleXMLElement element) {
            ArrayList<IPixelPositionAccess> result = new ArrayList<IPixelPositionAccess>();
            for (SimpleXMLElement child : this.i_element.getSubElements()) {
                result.add(AutoCalculationSJRXML.this.getPPAForElement(child));
            }
            return result;
        }
    }

    public class PixelPositionAccessSection
    extends PixelPositionAccessBase {
        public PixelPositionAccessSection(SimpleXMLElement element) {
            super(element);
            this.i_heightMinValue = 14;
            this.i_widthMinValue = 15;
        }

        @Override
        protected int calculateAutoWidth() {
            return AutoCalculationSJRXML.this.calculateLayoutWidth();
        }

        @Override
        public int getY() {
            SimpleXMLElement element;
            ArrayList<PixelPositionAccessBase> neightbourPPAs = new ArrayList<PixelPositionAccessBase>();
            Iterator iterator = this.i_element.getParent().getSubElements().iterator();
            while (iterator.hasNext() && (element = (SimpleXMLElement)iterator.next()) != this.i_element) {
                neightbourPPAs.add(AutoCalculationSJRXML.this.getPPAForElement(element));
            }
            int result = 0;
            for (IPixelPositionAccess iPixelPositionAccess : neightbourPPAs) {
                result += iPixelPositionAccess.getHeight();
            }
            return result;
        }
    }

    public class PixelPositionAccessTEXT
    extends PixelPositionAccessBase {
        public PixelPositionAccessTEXT(SimpleXMLElement element) {
            super(element);
            this.i_heightMinValue = 5;
            this.i_widthMinValue = 100;
        }

        @Override
        protected int calculateAutoHeight() {
            return AutoCalculationFont.calculatePixelHeightFromElement(this.i_element.getValueMap());
        }
    }

    public class PixelPositionAccessCOLHEADER
    extends PixelPositionAccessBase {
        public PixelPositionAccessCOLHEADER(SimpleXMLElement element) {
            super(element);
        }

        @Override
        public int getHeight() {
            SimpleXMLElement parent = this.i_element.getParent();
            PixelPositionAccessGRIDCOL parentPPA = (PixelPositionAccessGRIDCOL)AutoCalculationSJRXML.this.getPPAForElement(parent);
            return parentPPA.getColHeaderHeightForAllHeaderTypes();
        }

        public int getHeightSingleCol() {
            return super.getHeight();
        }
    }

    public class PixelPositionAccessCOLFOOTER
    extends PixelPositionAccessBase {
        public PixelPositionAccessCOLFOOTER(SimpleXMLElement element) {
            super(element);
        }

        @Override
        public int getHeight() {
            SimpleXMLElement parent = this.i_element.getParent();
            PixelPositionAccessGRIDCOL parentPPA = (PixelPositionAccessGRIDCOL)AutoCalculationSJRXML.this.getPPAForElement(parent);
            return parentPPA.getColFooterHeight();
        }

        public int getHeightSingleCol() {
            return super.getHeight();
        }
    }
}

