/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.versions;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.sjrxml.versions.POMVersionReader;
import org.eclnt.util.valuemgmt.ValueManager;

public class POMVersionChecker
implements ICCEEConstants {
    public static void checkVersions() {
        List<ArtifactVersion> avs = POMVersionChecker.readExpectedArtifacts();
        avs.sort((element1, element2) -> {
            String s1 = element1.getPath();
            String s2 = element2.getPath();
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareTo(s2);
        });
        for (ArtifactVersion av : avs) {
            List<String> versionProperties = POMVersionReader.readVersionsOfPomProperties(av.getPath());
            if (versionProperties.size() == 0) {
                AppLog.L.log(LL_ERR, "POMVersionChecker: Artifact is not available: " + av.getPath());
                continue;
            }
            if (versionProperties.size() >= 2) {
                AppLog.L.log(LL_ERR, "POMVersionChecker: Artifact is available multiple times: " + av.getPath());
                for (String version : versionProperties) {
                    AppLog.L.log(LL_ERR, "POMVersionChecker: ..... " + version);
                }
                continue;
            }
            String version = versionProperties.get(0);
            if (ValueManager.checkIfStringsAreEqual((String)version, (String)av.getVersion())) continue;
            AppLog.L.log(LL_ERR, "POMVersionChecker: Artifact is available in wrong version: " + av.getPath());
            AppLog.L.log(LL_ERR, "POMVersionChecker: ..... expected: " + av.getVersion());
            AppLog.L.log(LL_ERR, "POMVersionChecker: ..... found   : " + version);
        }
    }

    private static List<ArtifactVersion> readExpectedArtifacts() {
        ArrayList<ArtifactVersion> result = new ArrayList<ArtifactVersion>();
        result.add(new ArtifactVersion("net.sf.jasperreports/jasperreports", "6.20.0"));
        result.add(new ArtifactVersion("net.sf.jasperreports/jasperreports-fonts", "6.20.0"));
        result.add(new ArtifactVersion("com.github.librepdf/openpdf", "1.3.30"));
        result.add(new ArtifactVersion("org.apache.pdfbox/pdfbox", "2.0.1"));
        result.add(new ArtifactVersion("org.slf4j/slf4j-log4j12", "1.7.5"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-anim", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-awt-util", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-bridge", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-constants", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-css", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-dom", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-ext", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-extension", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-gvt", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-i18n", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-parser", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-script", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-shared-resources", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-svg-dom", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-svggen", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-transcoder", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-util", "1.16"));
        result.add(new ArtifactVersion("org.apache.xmlgraphics/batik-xml", "1.16"));
        result.add(new ArtifactVersion("com.fasterxml.jackson.core/jackson-annotations", "2.13.3"));
        result.add(new ArtifactVersion("com.fasterxml.jackson.core/jackson-core", "2.13.3"));
        result.add(new ArtifactVersion("com.fasterxml.jackson.core/jackson-databind", "2.13.3"));
        result.add(new ArtifactVersion("com.fasterxml.jackson.dataformat/jackson-dataformat-xml", "2.13.3"));
        result.add(new ArtifactVersion("com.fasterxml.jackson.dataformat/jackson-dataformat-xml", "2.13.3"));
        return result;
    }

    public static class ArtifactVersion {
        String i_path;
        String i_version;

        public ArtifactVersion(String path, String version) {
            this.i_path = path;
            this.i_version = version;
        }

        public String getPath() {
            return this.i_path;
        }

        public String getVersion() {
            return this.i_version;
        }
    }
}

