/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.versions;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.file.ClassloaderReader;

public class POMVersionReader
implements ICCEEConstants {
    public static List<String> readVersionsOfPomProperties(String path) {
        try {
            String pomPropertiesPath = "META-INF/maven/" + path + "/pom.properties";
            ArrayList<String> result = new ArrayList<String>();
            List properties = new ClassloaderReader(true).readUTF8Files(pomPropertiesPath, false);
            for (String property : properties) {
                String version = POMVersionReader.findVersionInsidePomProperties(property);
                result.add(version);
            }
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem anylyzing: " + path, t);
        }
    }

    public static List<String> readVersionsOfPomXml(String path) {
        try {
            String pomXmlPath = "META-INF/maven/" + path + "/pom.xml";
            ArrayList<String> result = new ArrayList<String>();
            List xmls = new ClassloaderReader(true).readUTF8Files(pomXmlPath, false);
            for (String xml : xmls) {
                String version = POMVersionReader.findVersionInsidePomXml(xml);
                result.add(version);
            }
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem anylyzing: " + path, t);
        }
    }

    private static String findVersionInsidePomXml(String xml) {
        int index1 = xml.indexOf("<version>");
        if (index1 < 0) {
            return "unknown";
        }
        int index2 = xml.indexOf("</version>", index1);
        if (index1 < 0) {
            return "unknown";
        }
        return xml.substring(index1 + "<version>".length(), index2);
    }

    private static String findVersionInsidePomProperties(String s) {
        Properties ps = new Properties();
        byte[] sBytes = null;
        try {
            sBytes = s.getBytes("UTF-8");
            ByteArrayInputStream is = new ByteArrayInputStream(sBytes);
            ps.load(is);
            String result = ps.getProperty("version");
            if (result == null) {
                result = "undefined";
            }
            return result;
        }
        catch (Throwable e) {
            AppLog.L.log(LL_INF, "Problem with reading POM-properties: " + s, e);
            return "problemWhenReading";
        }
    }
}

