/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.dyndata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import org.eclnt.ccaddons.pbc.dyndata.CCDynDataEditor;
import org.eclnt.ccaddons.pbc.dyndata.ENUMNodeType;
import org.eclnt.ccaddons.pbc.dyndata.util.AttributeTextResolver;
import org.eclnt.ccaddons.pbc.sjrxml.i18n.SJRXMLLit;
import org.eclnt.ccaddons.pbc.text.CCEditText;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.dyndata.DynDataAttribute;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.DynDataUtil;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.util.CloneUtil;
import org.eclnt.ccee.xml.JAXBUtil;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.defaultscreens.Clipboard;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.pagebean.PageBeanConfigItem;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponent;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IWorkpageAwarePageBean;
import org.eclnt.workplace.IWorkpageDispatcher;

@CCGenClass(expressionBase="#{d.CCDynDataBrowser}")
public class CCDynDataBrowser
extends PageBeanComponent
implements Serializable,
IWorkpageAwarePageBean {
    public static final String DRAGSEND_PREFIX_EXPRESSION = "jsrxmlexpression";
    private static ILiteralExpressionBuilder s_literalExpressionBuilder = new DefaultLiteralExpressionBuilder();
    private IListener m_listener;
    TreeNode m_topNode;
    FIXGRIDTreeBinding<TreeNode> m_tree = new FIXGRIDTreeBinding();
    DynDataDefinition m_rootDdd;
    String m_currentExpression;
    String m_currentTextExpression;
    String m_attributeFilter;
    DynDataReaderContext m_ddrContext;
    String m_dddId = null;
    boolean m_availableStartEditor = true;
    IWorkpageDispatcher m_dispatcher;
    CCDynDataBrowser m_this = this;

    public String getRootExpressionUsedInPage() {
        return "#{d.CCDynDataBrowser}";
    }

    public static void initializeLiteralExpressionBuilder(ILiteralExpressionBuilder literalExpressionBuilder) {
        s_literalExpressionBuilder = literalExpressionBuilder;
    }

    public void setWorkpageDispatcher(IWorkpageDispatcher dispatcher) {
        this.m_dispatcher = dispatcher;
    }

    public void prepare(DynDataDefinition rootDdd, DynDataReaderContext readerContext, String dddId, IListener listener) {
        this.m_rootDdd = rootDdd;
        this.m_dddId = dddId;
        this.m_listener = listener;
        this.m_ddrContext = readerContext;
        this.buildTree();
    }

    public boolean getAvailableStartEditor() {
        return this.m_availableStartEditor;
    }

    public void setAvailableStartEditor(boolean value) {
        this.m_availableStartEditor = value;
    }

    public String getDddId() {
        return this.m_dddId;
    }

    public void onEditInEditorAction(ActionEvent event) {
        if (this.m_listener != null) {
            this.m_listener.reactOnRefreshRequested();
        }
        final CCDynDataEditor ui = new CCDynDataEditor();
        ui.setShowFooter(true);
        DynDataDefinition cloneDdd = (DynDataDefinition)CloneUtil.createClone((Serializable)this.m_rootDdd);
        ui.prepare(cloneDdd, this.m_ddrContext, new CCDynDataEditor.IListener(){

            @Override
            public void reactOnOK() {
                CCDynDataBrowser.this.updateDdd(ui.getDynDataDefintion());
                if (CCDynDataBrowser.this.m_dispatcher == null) {
                    CCDynDataBrowser.this.closePopup((IPageBean)ui);
                } else {
                    CCDynDataBrowser.this.m_dispatcher.getWorkpage().closeSemiModalPopup((IPageBean)CCDynDataBrowser.this.m_this, (IPageBean)ui);
                }
            }

            @Override
            public void reactOnCancel() {
                if (CCDynDataBrowser.this.m_dispatcher == null) {
                    CCDynDataBrowser.this.closePopup((IPageBean)ui);
                } else {
                    CCDynDataBrowser.this.m_dispatcher.getWorkpage().closeSemiModalPopup((IPageBean)CCDynDataBrowser.this.m_this, (IPageBean)ui);
                }
            }
        });
        if (this.m_dispatcher == null) {
            ModalPopup p = this.openModalPopup((IPageBean)ui, "Data definition", 1000, 800, new ModalPopup.IModalPopupListener(){

                public void reactOnPopupClosedByUser() {
                    CCDynDataBrowser.this.closePopup((IPageBean)ui);
                }
            });
            p.setLeftTopReferenceCentered();
        } else {
            this.m_dispatcher.getWorkpage().openSemiModalPopup((IPageBean)this, (IPageBean)ui, "Data definition", 1000, 800, new ModelessPopup.IModelessPopupListener(){

                public void reactOnPopupClosedByUser() {
                    CCDynDataBrowser.this.m_dispatcher.getWorkpage().closeSemiModalPopup((IPageBean)CCDynDataBrowser.this.m_this, (IPageBean)ui);
                }
            });
        }
        TreeNode selNode = (TreeNode)this.m_tree.getSelectedItem();
        if (selNode != null) {
            ui.selectNode(selNode.getDdd().getId());
        }
    }

    public void onRefreshAction(ActionEvent event) {
        if (this.m_listener != null) {
            this.m_listener.reactOnRefreshRequested();
        }
    }

    public void onEditAction(ActionEvent event) {
        if (this.m_listener != null) {
            this.m_listener.reactOnRefreshRequested();
        }
        String xml = JAXBUtil.marshalSimpleObject((Object)this.m_rootDdd);
        CCEditText.openAsPopup((IPageBean)this, (String)xml, (CCEditText.IListener)new CCEditText.IListener(){

            public void reactOnOK(String text) {
                CCDynDataBrowser.this.updateDdd(text);
            }

            public void reactOnCancel() {
            }

            public boolean checkText(String text) {
                try {
                    DynDataDefinition ddd = DynDataUtil.parseDynDataDefinitionXml((String)text);
                    return ddd != null;
                }
                catch (Throwable t) {
                    Statusbar.outputAlert((String)("Problem parsing XML: " + t.toString()), (String)"", (String)ValueManager.getStackstraceString((Throwable)t));
                    return false;
                }
            }
        });
    }

    public void initializePageBean(Map<String, String> initData) {
        super.initializePageBean(initData);
    }

    public void initializePageBeanConfigItems(List<PageBeanConfigItem> configItems) {
        super.initializePageBeanConfigItems(configItems);
    }

    public void onBeforeRendering() {
    }

    public FIXGRIDTreeBinding<TreeNode> getTree() {
        return this.m_tree;
    }

    public String getCurrentExpression() {
        return this.m_currentExpression;
    }

    public void setCurrentExpression(String value) {
        this.m_currentExpression = value;
    }

    public String getCurrentTextExpression() {
        return this.m_currentTextExpression;
    }

    public void setCurrentTextExpression(String currentTextExpression) {
        this.m_currentTextExpression = currentTextExpression;
    }

    public String getAttributeFilter() {
        return this.m_attributeFilter;
    }

    public void setAttributeFilter(String value) {
        this.m_attributeFilter = value;
    }

    public void onCopyClipboardAction(ActionEvent event) {
        if (this.m_currentExpression != null) {
            Clipboard.copyToClientClipboard((String)this.m_currentExpression);
            Statusbar.outputSuccess((String)SJRXMLLit.lit("msgCopiedClipboard", this.m_currentExpression));
        }
    }

    public void onCopyClipboardTextAction(ActionEvent event) {
        if (this.m_currentTextExpression != null) {
            Clipboard.copyToClientClipboard((String)this.m_currentTextExpression);
            Statusbar.outputSuccess((String)SJRXMLLit.lit("msgCopiedClipboard", this.m_currentTextExpression));
        }
    }

    public String getCurrentXml() {
        String result = JAXBUtil.marshalSimpleObject((Object)this.m_rootDdd);
        result = result.replace("\t", "    ");
        return result;
    }

    public DynDataDefinition getCurrentDynDataDefinition() {
        return this.m_rootDdd;
    }

    public void onAttributeFilterAction(ActionEvent event) {
        this.filterTree();
    }

    protected void buildTree() {
        this.m_tree.getRootNode().removeAllChildNodes(true);
        this.m_topNode = new TreeNode(this.m_tree.getRootNode(), this.m_rootDdd, 0);
    }

    protected void filterTree() {
        this.m_topNode.filter();
    }

    private String isolateDisplayClassName(String className) {
        if (className == null) {
            return "(JavaScript)";
        }
        int index = className.lastIndexOf(46);
        if (index >= 0) {
            return className.substring(index + 1);
        }
        return className;
    }

    private void updateDdd(String text) {
        try {
            DynDataDefinition ddd = DynDataUtil.parseDynDataDefinitionXml((String)text);
            this.updateDdd(ddd);
        }
        catch (Throwable t) {
            AppLog.L.log(ICCEEConstants.LL_INF, "Problem when updating dynamica data definition", t);
            Statusbar.outputAlert((String)("Problem when updating: " + t.toString()));
        }
    }

    private void updateDdd(DynDataDefinition ddd) {
        try {
            if (this.m_listener != null) {
                this.m_listener.reactOnDynDataChanged(ddd);
            }
            this.prepare(ddd, this.m_ddrContext, this.m_dddId, this.m_listener);
        }
        catch (Throwable t) {
            AppLog.L.log(ICCEEConstants.LL_INF, "Problem when updating dynamica data definition", t);
            Statusbar.outputAlert((String)("Problem when updating: " + t.toString()));
        }
    }

    public static interface ILiteralExpressionBuilder {
        public String buildLiteralExpression(TreeNode var1);
    }

    public static interface IListener
    extends Serializable {
        public void reactOnRefreshRequested();

        public void reactOnDynDataChanged(DynDataDefinition var1);
    }

    public class TreeNode
    extends FIXGRIDTreeItem
    implements Serializable {
        ENUMNodeType i_nodeType;
        DynDataDefinition i_ddd;
        DynDataAttribute i_att;
        String i_expression;
        List<TreeNode> i_bufferedAttributeNodes;
        boolean i_isKey;
        String i_dropReceive;
        String i_dragSend;

        public TreeNode(FIXGRIDTreeItem parentNode, DynDataDefinition ddd, int nodeStatus) {
            super(parentNode);
            this.i_bufferedAttributeNodes = new ArrayList<TreeNode>();
            this.i_isKey = false;
            this.i_ddd = ddd;
            this.i_nodeType = !this.i_ddd.getIsList() ? ENUMNodeType.CHILDOBJECT : ENUMNodeType.CHILDOBJECTLIST;
            this.setText(ddd.getId());
            this.setStatus(nodeStatus);
            this.setImage(this.findImage());
            this.readChildren();
        }

        public TreeNode(FIXGRIDTreeItem parentNode, DynDataAttribute att) {
            super(parentNode);
            this.i_bufferedAttributeNodes = new ArrayList<TreeNode>();
            this.i_isKey = false;
            this.i_att = att;
            this.i_nodeType = ENUMNodeType.PROPERTY;
            this.i_ddd = ((TreeNode)this.getParentNode()).i_ddd;
            this.setText(AttributeTextResolver.instance().resolveText(this.i_ddd, this.i_att.getName()) + " - " + CCDynDataBrowser.this.isolateDisplayClassName(att.getClassName()));
            this.setStatus(2);
        }

        public TreeNode getParentTreeNode() {
            return (TreeNode)this.getParentNode();
        }

        public ENUMNodeType getNodeType() {
            return this.i_nodeType;
        }

        public DynDataDefinition getDdd() {
            return this.i_ddd;
        }

        public DynDataAttribute getAtt() {
            return this.i_att;
        }

        public String getExpression() {
            return this.i_expression;
        }

        public boolean getClipboardIconRendered() {
            return this.i_nodeType == ENUMNodeType.PROPERTY;
        }

        public void onRowSelect() {
            CCDynDataBrowser.this.m_currentExpression = this.calculateExpression();
            CCDynDataBrowser.this.m_currentTextExpression = this.calculateTextExpression(CCDynDataBrowser.this.m_currentExpression);
        }

        public void onRowExecute() {
        }

        public void onToggle() {
        }

        private void readChildren() {
            for (DynDataDefinition childDdd : this.i_ddd.getChildren()) {
                new TreeNode(this, childDdd, 1);
            }
            List atts = DynDataUtil.readAttributesOfDynDataDefinition((DynDataReaderContext)CCDynDataBrowser.this.m_ddrContext, (DynDataDefinition)this.i_ddd);
            for (DynDataAttribute att : atts) {
                TreeNode attNode = new TreeNode(this, att);
                this.i_bufferedAttributeNodes.add(attNode);
            }
        }

        public String getDragSend() {
            return "CCSXMLEDITORVALUE:" + this.calculateExpression() + ";" + CCDynDataBrowser.DRAGSEND_PREFIX_EXPRESSION + ":" + this.calculateExpression();
        }

        private String findImage() {
            String path = "/" + this.getClass().getPackage().getName() + ".resources.IMAGENAME.";
            String color = StyleManager.getStyleValue((String)"@iconDark@");
            String template = path + color + ".16x16.ccsvg";
            switch (this.i_nodeType) {
                case PROPERTY: {
                    return template.replace("IMAGENAME", "att_16x16");
                }
                case CHILDOBJECT: {
                    return template.replace("IMAGENAME", "toone_16x16");
                }
                case CHILDOBJECTLIST: {
                    return template.replace("IMAGENAME", "ton_16x16");
                }
            }
            return null;
        }

        private String calculateTextExpression(String expression) {
            return s_literalExpressionBuilder.buildLiteralExpression(this);
        }

        private String calculateExpression() {
            if (this.i_expression != null) {
                return this.i_expression;
            }
            String result = "";
            TreeNode currentNode = this;
            while (true) {
                boolean finished = false;
                switch (currentNode.i_nodeType) {
                    case PROPERTY: {
                        result = currentNode.i_att.getName();
                        break;
                    }
                    case CHILDOBJECT: {
                        result = currentNode.i_ddd.getId() + "." + result;
                        break;
                    }
                    case CHILDOBJECTLIST: {
                        if (currentNode == this) {
                            result = currentNode.i_ddd.getId();
                            finished = false;
                            break;
                        }
                        finished = true;
                    }
                }
                if (finished || !(currentNode.getParentNode() instanceof TreeNode) || currentNode.getLevelInt() <= 1) break;
                currentNode = (TreeNode)currentNode.getParentNode();
            }
            if (result.endsWith(".")) {
                result = result.substring(0, result.length() - 1);
            }
            this.i_expression = "#{" + result + "}";
            return this.i_expression;
        }

        private void filter() {
            TreeNode tn;
            ArrayList childNodes = new ArrayList(this.getChildNodes());
            for (Object childNode : childNodes) {
                tn = (TreeNode)childNode;
                if (tn.i_att == null) continue;
                tn.removeNode();
            }
            for (TreeNode attNode : this.i_bufferedAttributeNodes) {
                String childNodeText = attNode.getText();
                if (!ValueManager.checkIfStringContainsTokenizedSearchString((String)childNodeText, (String)CCDynDataBrowser.this.m_attributeFilter)) continue;
                new TreeNode(this, attNode.i_att);
            }
            for (Object childNode : childNodes) {
                tn = (TreeNode)childNode;
                if (tn.i_att != null) continue;
                tn.filter();
            }
        }

        public String getFont() {
            if (this.i_att != null && this.i_att.isKey()) {
                return "weight:bold";
            }
            return null;
        }

        public void onClipboardAction(ActionEvent event) {
            Clipboard.copyToClientClipboard((String)this.calculateExpression());
            Statusbar.outputSuccess((String)SJRXMLLit.lit("msgCopiedClipboard", this.calculateExpression()));
        }

        public void onClipboardTextAction(ActionEvent event) {
            Clipboard.copyToClientClipboard((String)CCDynDataBrowser.this.getCurrentTextExpression());
            Statusbar.outputSuccess((String)SJRXMLLit.lit("msgCopiedClipboard", CCDynDataBrowser.this.getCurrentTextExpression()));
        }

        public boolean checkIfNodeContainsSubNode(FIXGRIDTreeItem node) {
            if (node == null) {
                return false;
            }
            if (node == this) {
                return false;
            }
            FIXGRIDTreeItem current = node;
            do {
                if ((current = current.getParentNode()) != null) continue;
                return false;
            } while (current != this);
            return true;
        }

        public void addSubNode(FIXGRIDTreeItem subNode, boolean asFirst) {
            super.addSubNode(subNode, asFirst);
            this.resort();
        }

        public void addSubNode(FIXGRIDTreeItem subNode, int index) {
            super.addSubNode(subNode, index);
            this.resort();
        }

        private void resort() {
            Collections.sort(this.getChildNodes(), new Comparator<FIXGRIDTreeItem>(){

                @Override
                public int compare(FIXGRIDTreeItem o1, FIXGRIDTreeItem o2) {
                    ENUMNodeType nt1 = ((TreeNode)o1).i_nodeType;
                    ENUMNodeType nt2 = ((TreeNode)o2).i_nodeType;
                    String s1 = "A";
                    if (nt1 == ENUMNodeType.PROPERTY) {
                        s1 = "B";
                    }
                    String s2 = "A";
                    if (nt2 == ENUMNodeType.PROPERTY) {
                        s2 = "B";
                    }
                    return s1.compareTo(s2);
                }
            });
        }
    }

    public static class DefaultLiteralExpressionBuilder
    implements ILiteralExpressionBuilder {
        @Override
        public String buildLiteralExpression(TreeNode node) {
            switch (node.getNodeType()) {
                case PROPERTY: {
                    return "#{literal(" + node.getDdd().getId() + "." + node.getAtt().getName() + ")}";
                }
                case CHILDOBJECT: 
                case CHILDOBJECTLIST: {
                    return "#{literal(" + node.getDdd().getId() + ")}";
                }
            }
            return null;
        }
    }
}

