/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataDynDataDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataFormDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataFormVersionInfo;
import org.eclnt.ccaddons.pbc.sjrxml.logic.ISjrxmlPersistence;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlPersistenceBase;
import org.eclnt.ccaddons.pbc.sjrxml.logic.entities.DataPropertyFile;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.ccee.xml.JAXBUtil;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class SjrxmlPersistenceByStreamStore
extends SjrxmlPersistenceBase
implements ISjrxmlPersistence {
    static final String ROOTPATH = "/ccsjrxml/forms/";
    public static final String POSTFIX_FORM = "_form.xml";
    public static final String POSTFIX_PROPERTYFILE = "_properties.xml";
    public static final String POSTFIX_DATA = "_data.xml";
    IStreamStore m_streamStore = StreamStore.getInstance();
    String m_safetyDir = ValueManager.encodeIntoValidFileName((String)(FileManager.getTempFileDirectory().getAbsolutePath() + "/cc" + "/ccsjrxml/forms/"), (boolean)true);

    @Override
    public List<String> readPropertyFileIds() {
        return this.readIds(POSTFIX_PROPERTYFILE);
    }

    @Override
    public DataPropertyFile readPropertyFile(String id) {
        try {
            String path = "/ccsjrxml/forms//" + id + POSTFIX_PROPERTYFILE;
            String xml = this.m_streamStore.readUTF8(path, true);
            DataPropertyFile result = (DataPropertyFile)JAXBUtil.unmarshalSimpleObject((String)xml, DataPropertyFile.class);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public void removePropertyFile(DataPropertyFile dpf) {
        try {
            String path = "/ccsjrxml/forms//" + dpf.getId() + POSTFIX_PROPERTYFILE;
            this.m_streamStore.removeStream(path, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void savePropertyFile(DataPropertyFile dpf) {
        String xml = JAXBUtil.marshalSimpleObject((Object)dpf);
        String path = "/ccsjrxml/forms//" + dpf.getId() + POSTFIX_PROPERTYFILE;
        this.m_streamStore.writeUTF8(path, xml, true);
        String safetyPath = this.m_safetyDir + "/" + dpf.getId() + POSTFIX_PROPERTYFILE + "." + System.currentTimeMillis();
        FileManager.ensureDirectoryExists((String)safetyPath);
        FileManager.writeUTF8File((String)safetyPath, (String)xml, (boolean)false);
    }

    @Override
    public List<String> readCategories() {
        ArrayList<String> result = new ArrayList<String>();
        List<DataFormDefinition> dataForms = this.readAllDataForms();
        for (DataFormDefinition dataForm : dataForms) {
            if (result.contains(dataForm.getCategoryId())) continue;
            result.add(dataForm.getCategoryId());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public void saveDataForm(DataFormDefinition dfd) {
        String xml = JAXBUtil.marshalSimpleObject((Object)dfd);
        String path = "/ccsjrxml/forms//" + dfd.getId() + POSTFIX_FORM;
        this.m_streamStore.writeUTF8(path, xml, true);
        String safetyPath = this.m_safetyDir + "/" + dfd.getId() + POSTFIX_FORM + "." + System.currentTimeMillis();
        FileManager.ensureDirectoryExists((String)safetyPath);
        FileManager.writeUTF8File((String)safetyPath, (String)xml, (boolean)false);
    }

    @Override
    public DataFormDefinition readDataFormForEditor(String formId) {
        return this.readDataForm(formId);
    }

    @Override
    public DataFormDefinition readDataFormForRuntime(String formId) {
        return this.readDataForm(formId);
    }

    @Override
    public DataFormDefinition readDataFormForVersion(String formId, String versionInfo) {
        throw new Error("Versions not implemented with: " + this.getClass().getName());
    }

    @Override
    public List<String> readDynDataIds() {
        return this.readIds(POSTFIX_DATA);
    }

    @Override
    public void saveDataDynData(DataDynDataDefinition dataDdd) {
        String path = "/ccsjrxml/forms//" + dataDdd.getId() + POSTFIX_DATA;
        String xml = JAXBUtil.marshalSimpleObject((Object)dataDdd);
        this.m_streamStore.writeUTF8(path, xml, true);
        String safetyPath = this.m_safetyDir + "/" + dataDdd.getId() + POSTFIX_DATA + "." + System.currentTimeMillis();
        FileManager.ensureDirectoryExists((String)safetyPath);
        FileManager.writeUTF8File((String)safetyPath, (String)xml, (boolean)false);
    }

    @Override
    public DataDynDataDefinition readDataDynData(String dddId) {
        try {
            String path = "/ccsjrxml/forms//" + dddId + POSTFIX_DATA;
            String xml = this.m_streamStore.readUTF8(path, true);
            DataDynDataDefinition result = (DataDynDataDefinition)JAXBUtil.unmarshalSimpleObject((String)xml, DataDynDataDefinition.class);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public List<String> readFormsInCategory(String categoryId) {
        ArrayList<String> result = new ArrayList<String>();
        List<DataFormDefinition> dataForms = this.readAllDataForms();
        for (DataFormDefinition dataForm : dataForms) {
            if (!ValueManager.checkIfStringsAreEqual((String)dataForm.getCategoryId(), (String)categoryId)) continue;
            result.add(dataForm.getId());
        }
        return result;
    }

    @Override
    public DynDataDefinition readDynDataForFormForEditor(String formId) {
        return this.readDynDataForForm(formId);
    }

    @Override
    public DynDataDefinition readDynDataForFormForRuntime(String formId) {
        return this.readDynDataForForm(formId);
    }

    @Override
    public void removeDataForm(String formId) {
        String path = "/ccsjrxml/forms//" + formId + POSTFIX_FORM;
        this.m_streamStore.removeStream(path, true);
    }

    @Override
    public void removeDataDynData(String dynDataId) {
        String path = "/ccsjrxml/forms//" + dynDataId + POSTFIX_DATA;
        this.m_streamStore.removeStream(path, true);
    }

    public void createCategory(String category) {
        this.m_streamStore.writeUTF8(ROOTPATH + category + "/catgegory.xml", "<category/>", false);
    }

    @Override
    public List<DataFormVersionInfo> readDataFormVersionInfos(String formId) {
        ArrayList<DataFormVersionInfo> result = new ArrayList<DataFormVersionInfo>();
        for (int i = 0; i < 5; ++i) {
            result.add(new DataFormVersionInfo(formId + "/" + i, formId + "/" + i));
        }
        return result;
    }

    @Override
    public boolean checkIfToAlwaysCreateNewInstance() {
        return false;
    }

    private List<DataFormDefinition> readAllDataForms() {
        ArrayList<DataFormDefinition> result = new ArrayList<DataFormDefinition>();
        List fileNames = this.m_streamStore.getContainedStreams(ROOTPATH, false);
        for (String fileName : fileNames) {
            if (!fileName.endsWith(POSTFIX_FORM)) continue;
            try {
                String xml = this.m_streamStore.readUTF8("/ccsjrxml/forms//" + fileName, true);
                DataFormDefinition dataForm = (DataFormDefinition)JAXBUtil.unmarshalSimpleObject((String)xml, DataFormDefinition.class);
                if (result.contains(dataForm.getCategoryId())) continue;
                result.add(dataForm);
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public List<String> readIds(String postfix) {
        ArrayList<String> result = new ArrayList<String>();
        List streams = this.m_streamStore.getContainedStreams(ROOTPATH, false);
        for (String stream : streams) {
            if (!stream.endsWith(postfix)) continue;
            result.add(stream.substring(0, stream.length() - postfix.length()));
        }
        Collections.sort(streams);
        return result;
    }

    protected DataFormDefinition readDataForm(String formId) {
        try {
            String path = "/ccsjrxml/forms//" + formId + POSTFIX_FORM;
            String xml = this.m_streamStore.readUTF8(path, true);
            DataFormDefinition result = (DataFormDefinition)JAXBUtil.unmarshalSimpleObject((String)xml, DataFormDefinition.class);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected DynDataDefinition readDynDataForForm(String formId) {
        DataFormDefinition dataForm = this.readDataForm(formId);
        DataDynDataDefinition dataDynDate = this.readDataDynData(dataForm.getDddId());
        String xml = dataDynDate.getXml();
        DynDataDefinition result = (DynDataDefinition)JAXBUtil.unmarshalSimpleObject((String)xml, DynDataDefinition.class);
        return result;
    }
}

