/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccaddons.pbc.sjrxml.logic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclnt.ccaddons.pbc.sjrxml.logic.ISjrxmlViewConstants;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlLogic;
import org.eclnt.ccaddons.pbc.xyeditor.logic.IXYContent;
import org.eclnt.ccaddons.pbc.xyeditor.logic.XYMargin;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.util.AutoCalculationSJRXML;
import org.eclnt.ccee.sjrxml.util.DPICalculation;
import org.eclnt.ccee.sjrxml.util.IPixelPositionAccess;
import org.eclnt.ccee.sjrxml.util.Inset;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class XYContentSJRXMLElement
implements IXYContent,
IPixelPositionAccess,
ISjrxmlViewConstants {
    static final int ADDITIONAL_AUTO_PIXELS = 20;
    String m_id = UniqueIdCreator.createUUID();
    SimpleXMLElement m_xmlElement;
    IXYContent m_parent;
    List<IXYContent> m_children = new ArrayList<IXYContent>();
    boolean m_opensOwnCoordinates = true;
    boolean m_selectionEnabled = false;
    boolean m_fixSizeAndPosition = false;
    int m_z = 20;
    int m_deltaY = 0;
    protected Inset m_ownPadding = new Inset();
    AutoCalculationSJRXML m_calculationSJRXML;
    boolean m_takeOverDrillDown = false;

    public XYContentSJRXMLElement(AutoCalculationSJRXML calculationSJRXML, IXYContent parent, SimpleXMLElement xmlElement, boolean opensOwnCoordinates) {
        this.m_calculationSJRXML = calculationSJRXML;
        this.m_parent = parent;
        this.m_xmlElement = xmlElement;
        this.m_opensOwnCoordinates = opensOwnCoordinates;
        this.m_ownPadding = new Inset(xmlElement.getValue("padding"));
        if (this.m_parent != null) {
            this.m_parent.getChildren().add(this);
        }
    }

    public SimpleXMLElement getXmlElement() {
        return this.m_xmlElement;
    }

    public boolean getTakeOverDrillDown() {
        return this.m_takeOverDrillDown;
    }

    public void setTakeOverDrillDown(boolean takeOverDrillDown) {
        this.m_takeOverDrillDown = takeOverDrillDown;
    }

    public String getId() {
        return this.m_id;
    }

    @Override
    public int getX() {
        return this.calculateParentPaddingLeft() + this.m_calculationSJRXML.calculatePixelX(this.m_xmlElement);
    }

    @Override
    public int getY() {
        return this.calculateParentPaddingTop() + this.m_calculationSJRXML.calculatePixelY(this.m_xmlElement) + this.m_deltaY;
    }

    public int getDeltaY() {
        return this.m_deltaY;
    }

    public void setDeltaY(int deltaY) {
        this.m_deltaY = deltaY;
    }

    public int getZ() {
        return this.m_z;
    }

    public void setZ(int z) {
        this.m_z = z;
    }

    @Override
    public int getWidth() {
        return this.m_calculationSJRXML.calculatePixelWidth(this.m_xmlElement);
    }

    @Override
    public int getHeight() {
        return this.m_calculationSJRXML.calculatePixelHeight(this.m_xmlElement);
    }

    public void setX(int value) {
        if ((value -= this.calculateParentPaddingLeft()) < 0) {
            value = 0;
        }
        this.transferSizeValue(value, "x");
    }

    public void setY(int value) {
        if ((value -= this.calculateParentPaddingTop()) < 0) {
            value = 0;
        }
        this.transferSizeValue(value, "y");
    }

    public void setWidth(int value) {
        if (value < 0) {
            value = 0;
        }
        this.transferSizeValue(value, "width");
    }

    public void setHeight(int value) {
        if (value < 0) {
            value = 0;
        }
        this.transferSizeValue(value, "height");
    }

    public Map<String, String> getAttributes() {
        return this.m_xmlElement.getValueMap();
    }

    public IXYContent getParent() {
        return this.m_parent;
    }

    public List<IXYContent> getChildren() {
        return this.m_children;
    }

    public boolean getOpensOwnCoordinates() {
        return this.m_opensOwnCoordinates;
    }

    public void setOpensOwnCoordinates(boolean opensOwnCoordinates) {
        this.m_opensOwnCoordinates = opensOwnCoordinates;
    }

    public boolean getSelectionEnabled() {
        return this.m_selectionEnabled;
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        this.m_selectionEnabled = selectionEnabled;
    }

    public boolean getFixSizeAndPosition() {
        return this.m_fixSizeAndPosition;
    }

    public void setFixSizeAndPosition(boolean fixSizeAndPosition) {
        this.m_fixSizeAndPosition = fixSizeAndPosition;
    }

    public XYMargin getMargin() {
        if (this.m_xmlElement.getValue("margin") != null) {
            return new XYMargin(this.m_xmlElement.getValue("margin"));
        }
        return new XYMargin(0, 0, 0, 0);
    }

    public Inset getPaddingForPositioningChildren() {
        return this.m_ownPadding;
    }

    public void drillDownXMLElementToXYContent(SjrxmlLogic sjrxmlLogic) {
        throw new Error("Not implemented for this class: " + this.getClass().getName());
    }

    public void postProcessChildrenAfterDrillDown() {
    }

    protected int calculateParentPaddingLeft() {
        if (this.m_parent == null) {
            return 0;
        }
        if (!(this.m_parent instanceof XYContentSJRXMLElement)) {
            return 0;
        }
        Inset pi = ((XYContentSJRXMLElement)this.m_parent).getPaddingForPositioningChildren();
        if (pi != null) {
            return pi.getPixelLeft();
        }
        return 0;
    }

    protected int calculateParentPaddingTop() {
        if (this.m_parent == null) {
            return 0;
        }
        if (!(this.m_parent instanceof XYContentSJRXMLElement)) {
            return 0;
        }
        Inset pi = ((XYContentSJRXMLElement)this.m_parent).getPaddingForPositioningChildren();
        if (pi != null) {
            return pi.getPixelTop();
        }
        return 0;
    }

    private void transferSizeValue(int pixelValue, String attributeName) {
        int current;
        if (pixelValue < 0) {
            pixelValue = 0;
        }
        if (pixelValue == (current = DPICalculation.calculate72DpiPixelValue(this.m_xmlElement.getValue(attributeName)))) {
            return;
        }
        String currentString = this.m_xmlElement.getValue(attributeName);
        if (currentString != null && currentString.contains("mm")) {
            int mmValue = DPICalculation.transfer72DpiPixelValueToMm(pixelValue);
            this.m_xmlElement.setValue(attributeName, ValueManager.convertObject2ValueString((Object)mmValue) + "mm");
        } else if (currentString != null && currentString.contains("cm")) {
            BigDecimal cmValue = DPICalculation.transfer72DpiPixelValueToCm(pixelValue);
            this.m_xmlElement.setValue(attributeName, ValueManager.convertObject2ValueString((Object)cmValue) + "cm");
        } else {
            this.m_xmlElement.setValue(attributeName, "" + pixelValue);
        }
    }
}

