/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.pdfbysjrxml.comm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.json.jackson.JSONUtil;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.pdfbysjrxml.comm.PDFProcessingThreadContextInitializer;
import org.eclnt.ccee.pdfbysjrxml.comm.data.PDFProcessingInvoke;
import org.eclnt.ccee.pdfbysjrxml.comm.data.PDFProcessingResult;
import org.eclnt.ccee.pdfbysjrxml.logic.PdfBySjrxmlLogic;
import org.eclnt.ccee.sjrxml.ISJRXMLConstants;
import org.eclnt.util.file.StreamUtil;
import org.eclnt.util.valuemgmt.ValueManager;

public class PDFProcessingServlet
extends HttpServlet
implements ICCEEConstants,
ISJRXMLConstants {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            AppLog.L.log(LL_INF, "PDFProcessingServlet - GET called");
            req.setCharacterEncoding(ValueManager.CHARSET_UTF8.name());
            String formId = req.getParameter("formId");
            if (ValueManager.isEmpty((String)formId)) {
                throw new Error("Parametger formId is not defined!");
            }
            String tenant = req.getParameter("formTenant");
            String user = req.getParameter("formUser");
            String country = req.getParameter("formCountry");
            String language = req.getParameter("formLanguage");
            String outputFormat = req.getParameter("formOutputFormat");
            if (outputFormat == null) {
                outputFormat = "PDF";
            }
            DynDataReaderContext ddr = new DynDataReaderContext();
            this.passLocale(ddr, language, country);
            PDFProcessingThreadContextInitializer.instance().initializeThreadContext(tenant, user);
            Enumeration params = req.getParameterNames();
            while (params.hasMoreElements()) {
                String param = (String)params.nextElement();
                String value = req.getParameter(param);
                if (value == null) continue;
                AppLog.L.log(LL_INF, "PDF parameter passed: " + param + ", " + value);
                ddr.getGlobals().put(param, value);
            }
            byte[] result = PdfBySjrxmlLogic.instance().createDocument(formId, ddr, outputFormat);
            resp.getOutputStream().write(result);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_INF, "PDFProcessingServlet - problem during processing", t);
            String tString = ValueManager.getStackstraceString((Throwable)t);
            resp.getWriter().print(tString);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String content = null;
        try {
            AppLog.L.log(LL_INF, "PDFProcessingServlet - POST called");
            ServletInputStream is = req.getInputStream();
            byte[] bytes = StreamUtil.transferStreamContentIntoBytes((InputStream)is);
            content = new String(bytes, ValueManager.CHARSET_UTF8);
            PDFProcessingInvoke pc = (PDFProcessingInvoke)JSONUtil.unmarshalSimpleObject((String)content, PDFProcessingInvoke.class);
            DynDataReaderContext ddr = new DynDataReaderContext();
            this.passLocale(ddr, pc.getFormLanguage(), pc.getFormCountry());
            PDFProcessingThreadContextInitializer.instance().initializeThreadContext(pc.getFormTenant(), pc.getFormUser());
            for (String key : pc.getContextGlobals().keySet()) {
                String value = ValueManager.convertObject2ValueString((Object)pc.getContextGlobals().get(key));
                if (value == null) continue;
                ddr.getGlobals().put(key, value);
            }
            byte[] pdfBytes = PdfBySjrxmlLogic.instance().createDocument(pc, ddr);
            PDFProcessingResult result = new PDFProcessingResult();
            result.setMessage("OK");
            result.setSuccess(true);
            result.setContent(pdfBytes);
            String response = JSONUtil.marshalSimpleObject((Object)result);
            resp.setCharacterEncoding(ValueManager.CHARSET_UTF8.name());
            resp.getWriter().write(response);
        }
        catch (Throwable t) {
            AppLog.L.log(ICCEEConstants.LL_ERR, "Problem creaeting PDF: " + content, t);
            PDFProcessingResult result = new PDFProcessingResult();
            result.setMessage("ERROR: " + t);
            result.setSuccess(false);
            result.setContent(new byte[0]);
            String response = JSONUtil.marshalSimpleObject((Object)result);
            resp.getWriter().write(response);
        }
    }

    private void passLocale(DynDataReaderContext ddrContext, String language, String country) {
        try {
            Locale l = null;
            if (language != null) {
                l = country != null ? new Locale(language, country) : new Locale(language);
            }
            if (l != null) {
                ddrContext.setLocale(l);
            }
        }
        catch (Throwable t) {
            AppLog.L.log(AppLog.LL_INF, "Locale was not set during PDF processing: " + language + ", " + country, t);
        }
    }
}

