/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.pdfbysjrxml.logic;

import org.eclnt.ccaddons.pbc.sjrxml.logic.DataDynDataDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.DataFormDefinition;
import org.eclnt.ccaddons.pbc.sjrxml.logic.SjrxmlPersistence;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.dyndata.DynDataMap;
import org.eclnt.ccee.dyndata.DynDataReader;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.pdfbysjrxml.comm.data.PDFProcessingInvoke;
import org.eclnt.ccee.sjrxml.ISJRXMLConstants;
import org.eclnt.ccee.sjrxml.JRXMLGeneratorLogic;
import org.eclnt.ccee.xml.JAXBUtil;
import org.eclnt.util.valuemgmt.ValueManager;

public class PdfBySjrxmlLogic
implements ICCEEConstants,
ISJRXMLConstants {
    static PdfBySjrxmlLogic s_instance = new PdfBySjrxmlLogic();

    public static PdfBySjrxmlLogic instance() {
        return s_instance;
    }

    public static void initialize(PdfBySjrxmlLogic instance) {
        s_instance = instance;
    }

    public byte[] createDocument(String formId, DynDataReaderContext ddrContext, String outputFormat) {
        try {
            AppLog.L.log(LL_INF, "Starting PDF processing with form: " + formId + ", globals: " + ddrContext.getGlobals());
            JRXMLGeneratorLogic gl = new JRXMLGeneratorLogic();
            DataFormDefinition form = this.readDataFormForRuntime(formId, true);
            String sjrxml = form.getXml();
            String dddId = form.getDddId();
            DataDynDataDefinition dddDef = this.readDataDynDataDefinition(dddId, true);
            DynDataDefinition ddd = this.parseDynDataDefinition(dddDef);
            DynDataMap dynDataMap = new DynDataReader(ddrContext).createDynDataMap(ddd);
            byte[] result = this.createDocumentBytes(formId, sjrxml, dynDataMap, outputFormat);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem when processing createPDF: " + formId, t);
        }
    }

    public byte[] createDocument(PDFProcessingInvoke pc, DynDataReaderContext ddrContext) {
        try {
            AppLog.L.log(LL_INF, "Starting PDF processing with form: " + pc.getFormId());
            JRXMLGeneratorLogic gl = new JRXMLGeneratorLogic();
            DataFormDefinition form = this.readDataFormForRuntime(pc.getFormId(), true);
            String sjrxml = form.getXml();
            String dddId = form.getDddId();
            DataDynDataDefinition dddDef = this.readDataDynDataDefinition(dddId, true);
            DynDataDefinition ddd = this.parseDynDataDefinition(dddDef);
            DynDataMap dynDataMap = null;
            dynDataMap = pc.getData().size() > 0 ? new DynDataReader(ddrContext).createDynDataMapFromMap(ddd, pc.getData()) : new DynDataReader(ddrContext).createDynDataMap(ddd);
            String outputFormat = this.findOutputFormat(pc);
            byte[] result = this.createDocumentBytes(pc.getFormId(), sjrxml, dynDataMap, outputFormat);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem when processing createPDF: " + pc.getFormId(), t);
        }
    }

    private byte[] createDocumentBytes(String formId, String sjrxml, DynDataMap dynDataMap, String outputFormat) {
        byte[] result = null;
        JRXMLGeneratorLogic gl = new JRXMLGeneratorLogic();
        switch (outputFormat) {
            case "PDF": {
                result = gl.exportPdfBytes(formId, sjrxml, dynDataMap);
                break;
            }
            case "HTML": {
                result = gl.exportHtmlBytes(formId, sjrxml, dynDataMap);
                break;
            }
            default: {
                throw new Error("output format is not supported: " + outputFormat);
            }
        }
        return result;
    }

    private String findOutputFormat(PDFProcessingInvoke pc) {
        if (ValueManager.isEmpty((String)pc.getFormOutputFormat())) {
            return "PDF";
        }
        return pc.getFormOutputFormat();
    }

    private DynDataDefinition parseDynDataDefinition(DataDynDataDefinition dddDef) {
        if (dddDef == null) {
            throw new Error("dddDef passedas null");
        }
        try {
            String dddxml = dddDef.getXml();
            DynDataDefinition ddd = (DynDataDefinition)JAXBUtil.unmarshalSimpleObject((String)dddxml, DynDataDefinition.class);
            return ddd;
        }
        catch (Throwable t) {
            throw new Error("Problem when parsing XML of data definition: " + dddDef.getId(), t);
        }
    }

    private DataDynDataDefinition readDataDynDataDefinition(String dddId, boolean withError) {
        try {
            if (dddId == null) {
                throw new Exception("The dddId was passed as null.");
            }
            DataDynDataDefinition result = SjrxmlPersistence.instance().readDataDynData(dddId);
            if (result == null) {
                throw new Exception("Could not find dynymic data definition with id: " + dddId);
            }
            return result;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem reading dataForm with dddId: " + dddId, t);
            }
            return null;
        }
    }

    private DataFormDefinition readDataFormForRuntime(String formId, boolean withError) {
        try {
            if (formId == null) {
                throw new Exception("The formId was passed as null.");
            }
            DataFormDefinition result = SjrxmlPersistence.instance().readDataFormForRuntime(formId);
            if (result == null) {
                throw new Exception("Could not find form definition with id: " + formId);
            }
            return result;
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem reading dataForm with formId: " + formId, t);
            }
            return null;
        }
    }
}

