/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.checking.impl;

import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.checking.CheckerBase;
import org.eclnt.ccee.sjrxml.checking.CheckingMessages;
import org.eclnt.ccee.sjrxml.checking.ISJRXMLElementChecker;
import org.eclnt.ccee.sjrxml.checking.SJRXMLCheckerResult;
import org.eclnt.ccee.sjrxml.util.AutoCalculationSJRXML;
import org.eclnt.ccee.sjrxml.util.DPICalculation;

public class BACKGROUNDChecker
extends CheckerBase
implements ISJRXMLElementChecker {
    @Override
    public void checkElementExecute(SimpleXMLElement xmlElement, SJRXMLCheckerResult result, AutoCalculationSJRXML autoCalculation) {
        int outputLayoutHeight;
        int height = DPICalculation.calculate72DpiPixelValue(xmlElement.getValue("height"));
        if (height > (outputLayoutHeight = autoCalculation.calculatePixelHeight(this.getTopElement(xmlElement))) - 100) {
            result.addResultItem(0, CheckingMessages.createMessage("failBackgroundHeight", "height", xmlElement.getName()), "COMPONENTS_REACHING_OUTSIDE_PARENT_HEIGHT", "height", xmlElement);
        }
    }
}

