/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.checking.impl;

import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.checking.CheckerBase;
import org.eclnt.ccee.sjrxml.checking.CheckingMessages;
import org.eclnt.ccee.sjrxml.checking.ISJRXMLElementChecker;
import org.eclnt.ccee.sjrxml.checking.SJRXMLCheckerResult;
import org.eclnt.ccee.sjrxml.util.AutoCalculationSJRXML;
import org.eclnt.util.valuemgmt.ValueManager;

public class BODYChecker
extends CheckerBase
implements ISJRXMLElementChecker {
    @Override
    public void checkElementExecute(SimpleXMLElement xmlElement, SJRXMLCheckerResult result, AutoCalculationSJRXML autoCalculation) {
        int bodyHeight = 0;
        int outputLayoutHeightInt = autoCalculation.calculatePixelWidth(this.getTopElement(xmlElement));
        for (SimpleXMLElement band : xmlElement.getSubElements()) {
            bodyHeight += ValueManager.decodeInt((String)band.getValue("height"), (int)-1);
        }
        if (bodyHeight > outputLayoutHeightInt) {
            result.addResultItem(0, CheckingMessages.createMessage("failComponentReachingOutsideParentHeight", xmlElement.getParent().getName(), xmlElement.getName(), "Element " + xmlElement.getParent().getName()), "COMPONENTS_REACHING_OUTSIDE_PARENT_HEIGHT", "height", xmlElement);
        }
    }
}

