/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.parsing;

import java.util.HashMap;
import java.util.Map;
import org.eclnt.ccee.sjrxml.IConstantsAttributeNames;
import org.eclnt.ccee.sjrxml.IConstantsDefaultAttributeValues;
import org.eclnt.ccee.sjrxml.IConstantsElementNames;
import org.eclnt.ccee.sjrxml.parsing.JRXMLContext;
import org.eclnt.ccee.sjrxml.parsing.ParserUtil;
import org.eclnt.util.valuemgmt.ValueManager;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class StylesGenerator
implements IConstantsAttributeNames,
IConstantsElementNames,
IConstantsDefaultAttributeValues {
    private static final String BOX_TOP = "top";
    private static final String BOX_LEFT = "left";
    private static final String BOX_BOTTOM = "bottom";
    private static final String BOX_RIGHT = "right";
    private static final String PEN_TOP = "topPen";
    private static final String PEN_LEFT = "leftPen";
    private static final String PEN_RIGHT = "rightPen";
    private static final String PEN_BOTTOM = "bottomPen";

    public String createBorderStyleAndReturnName(String styleName, JRXMLContext context, Map<String, String> attributes, Map<String, String> borderAttributes) {
        String generatedStyleName = "";
        generatedStyleName = styleName + context.getStyles().size();
        HashMap<String, Object> convertedBorderAttributes = new HashMap<String, Object>();
        this.convertMap(borderAttributes, convertedBorderAttributes);
        if (attributes.containsKey("oddevenstyle")) {
            Map oddEvenStyle = ValueManager.decodeComplexValue((String)attributes.get("oddevenstyle"));
            convertedBorderAttributes.put("oddEvenStyleAttributes", oddEvenStyle);
        }
        if (!context.getStyles().containsKey(generatedStyleName)) {
            if (!context.getStyleBuffer().hasSavedObjectAttributes(convertedBorderAttributes)) {
                context.getStyleBuffer().saveObjectAttributes(generatedStyleName, convertedBorderAttributes);
                context.getStyles().put(generatedStyleName, this.createBorderStyle(context, generatedStyleName, attributes));
            } else {
                return context.getStyleBuffer().getBufferedObjectStyleName(convertedBorderAttributes);
            }
        }
        return generatedStyleName;
    }

    public String createBorderStyleAndReturnName(String styleName, String attName, String attribute, JRXMLContext context, Map<String, String> attributes, Map<String, String> borderAttributes) {
        String generatedStyleName = "";
        generatedStyleName = styleName + context.getStyles().size();
        if (attribute != null) {
            borderAttributes.put(attName, attribute);
        }
        if (!context.getStyles().containsKey(generatedStyleName)) {
            if (!context.getStyleBuffer().hasSavedAttributes(borderAttributes)) {
                context.getStyleBuffer().saveAttributes(generatedStyleName, borderAttributes);
                context.getStyles().put(generatedStyleName, this.createBorderStyle(context, generatedStyleName, attributes));
            } else {
                return context.getStyleBuffer().getBufferedStyleName(borderAttributes);
            }
        }
        return generatedStyleName;
    }

    public Element createBorderStyle(JRXMLContext context, String generatedStyleName, Map<String, String> attributes) {
        Element style = new Element("style");
        Element box = new Element("box");
        Element topPen = new Element(PEN_TOP);
        Element leftPen = new Element(PEN_LEFT);
        Element bottomPen = new Element(PEN_BOTTOM);
        Element rightPen = new Element(PEN_RIGHT);
        HashMap<String, String> styleValues = new HashMap();
        style.setAttribute(new Attribute("name", generatedStyleName));
        if (generatedStyleName.startsWith("gridCellBorderStyle")) {
            styleValues = ParserUtil.decodeBorder(attributes.get("cellBorder"));
            this.checkAndFillBoxElement(style, box, topPen, leftPen, bottomPen, rightPen, styleValues);
            Map oddEvenStyleAttributes = null;
            if (attributes.get("oddevenstyle") != null) {
                oddEvenStyleAttributes = ValueManager.decodeComplexValue((String)attributes.get("oddevenstyle"));
                HashMap<String, Object> convertedOddEvenStyleAttributes = new HashMap<String, Object>();
                this.convertMap(oddEvenStyleAttributes, convertedOddEvenStyleAttributes);
                this.fillOddEvenRowsStyle(style, generatedStyleName, context, convertedOddEvenStyleAttributes);
            }
        } else if (generatedStyleName.startsWith("gridheader") && attributes.get("backcolor") != null || generatedStyleName.startsWith("gridfooter") && attributes.get("backcolor") != null) {
            styleValues = ParserUtil.decodeBorder(attributes.get("border"));
            style.setAttribute("mode", "Opaque");
            style.setAttribute("backcolor", attributes.get("backcolor"));
            this.checkAndFillBoxElement(style, box, topPen, leftPen, bottomPen, rightPen, styleValues);
        } else {
            styleValues = ParserUtil.decodeBorder(attributes.get("border"));
            this.checkAndFillBoxElement(style, box, topPen, leftPen, bottomPen, rightPen, styleValues);
        }
        return style;
    }

    public String createFontStyleAndReturnName(String styleName, JRXMLContext context, Map<String, String> fontAttributes, Map<String, String> elementAttributes) {
        String generatedStyleName = "";
        generatedStyleName = styleName + context.getStyles().size();
        if (!context.getStyles().containsKey(generatedStyleName)) {
            if (!context.getStyleBuffer().hasSavedAttributes(fontAttributes)) {
                context.getStyleBuffer().saveAttributes(generatedStyleName, fontAttributes);
                context.getStyles().put(generatedStyleName, this.createFontStyle(context, generatedStyleName, fontAttributes, elementAttributes));
            } else {
                return context.getStyleBuffer().getBufferedStyleName(fontAttributes);
            }
        }
        return generatedStyleName;
    }

    public Element createFontStyle(JRXMLContext context, String generatedStyleName, Map<String, String> fontAttributes, Map<String, String> elementAttributes) {
        Element style = new Element("style");
        style.setAttribute(new Attribute("name", generatedStyleName));
        if (fontAttributes.containsKey("size")) {
            style.setAttribute(new Attribute("fontSize", fontAttributes.get("size")));
        }
        if (fontAttributes.containsKey("fontName")) {
            style.setAttribute(new Attribute("fontName", fontAttributes.get("fontName")));
        }
        if (fontAttributes.containsKey("weight")) {
            style.setAttribute(new Attribute("isBold", "true"));
        }
        if (fontAttributes.containsKey("posture")) {
            style.setAttribute(new Attribute("isItalic", "true"));
        }
        if (fontAttributes.containsKey("underline")) {
            style.setAttribute(new Attribute("isUnderline", fontAttributes.get("underline")));
        }
        if (fontAttributes.containsKey("strikethrough")) {
            style.setAttribute(new Attribute("isStrikeThrough", fontAttributes.get("strikethrough")));
        }
        if (elementAttributes.get("border") != null && !elementAttributes.get("border").isEmpty()) {
            Map<String, String> borders = ParserUtil.decodeBorder(elementAttributes.get("border"));
            Element box = new Element("box");
            Element topPen = new Element(PEN_TOP);
            Element leftPen = new Element(PEN_LEFT);
            Element bottomPen = new Element(PEN_BOTTOM);
            Element rightPen = new Element(PEN_RIGHT);
            this.checkAndFillBoxElement(style, box, topPen, leftPen, bottomPen, rightPen, borders);
        }
        return style;
    }

    public Element createPaddingBoxElement(String padding) {
        Map paddingAttributes = ValueManager.decodeComplexValue((String)padding);
        Element box = new Element("box");
        if (paddingAttributes.containsKey(BOX_LEFT)) {
            box.setAttribute(new Attribute("leftPadding", (String)paddingAttributes.get(BOX_LEFT)));
        }
        if (paddingAttributes.containsKey(BOX_RIGHT)) {
            box.setAttribute(new Attribute("rightPadding", (String)paddingAttributes.get(BOX_RIGHT)));
        }
        if (paddingAttributes.containsKey(BOX_BOTTOM)) {
            box.setAttribute(new Attribute("bottomPadding", (String)paddingAttributes.get(BOX_BOTTOM)));
        }
        if (paddingAttributes.containsKey(BOX_TOP)) {
            box.setAttribute(new Attribute("topPadding", (String)paddingAttributes.get(BOX_TOP)));
        }
        return box;
    }

    public String createBackColorStyleAndReturnName(String styleName, JRXMLContext context, Map<String, String> attributes) {
        Element style = new Element("style");
        String generatedStyleName = styleName + context.getStyles().size();
        style.setAttribute("name", generatedStyleName);
        style.setAttribute("mode", "Opaque");
        style.setAttribute("backcolor", attributes.get("backcolor"));
        context.getStyles().put(generatedStyleName, style);
        return generatedStyleName;
    }

    public String createOddEvenStyleAndReturnName(String styleName, JRXMLContext context, Map<String, String> attributes, Map<String, String> oddEvenAttributes) {
        String generatedStyleName = "";
        generatedStyleName = styleName + context.getStyles().size();
        HashMap<String, Object> convertedOddEvenAttributes = new HashMap<String, Object>();
        Map cellBorderAttributes = new HashMap();
        this.convertMap(oddEvenAttributes, convertedOddEvenAttributes);
        if (attributes.get("cellBorder") != null) {
            cellBorderAttributes = ValueManager.decodeComplexValue((String)attributes.get("cellBorder"));
            convertedOddEvenAttributes.put("cellBorderAttributes", cellBorderAttributes);
        }
        if (!context.getStyles().containsKey(generatedStyleName)) {
            if (!context.getStyleBuffer().hasSavedObjectAttributes(convertedOddEvenAttributes)) {
                context.getStyleBuffer().saveObjectAttributes(generatedStyleName, convertedOddEvenAttributes);
                context.getStyles().put(generatedStyleName, this.createOddEvenRowsStyle(generatedStyleName, context, convertedOddEvenAttributes));
            } else {
                return context.getStyleBuffer().getBufferedObjectStyleName(convertedOddEvenAttributes);
            }
        }
        return generatedStyleName;
    }

    public Element createOddEvenRowsStyle(String generatedStyleName, JRXMLContext context, Map<String, Object> attributes) {
        Element style = new Element("style");
        this.fillOddEvenRowsStyle(style, generatedStyleName, context, attributes);
        return style;
    }

    private void convertMap(Map<String, String> mapForConversion, Map<String, Object> mapForConvertedValues) {
        for (Map.Entry<String, String> entry : mapForConversion.entrySet()) {
            String value;
            String key = entry.getKey();
            String objectVal = value = entry.getValue();
            mapForConvertedValues.put(key, objectVal);
        }
    }

    private void fillOddEvenRowsStyle(Element style, String generatedStyleName, JRXMLContext context, Map<String, Object> oddEvenAttributes) {
        style.setAttribute("name", generatedStyleName);
        style.setAttribute("mode", "Opaque");
        style.setAttribute("backcolor", "#FFFFFF");
        Element ifConditionalStyle = new Element("conditionalStyle");
        Element ifConditionExpression = new Element("conditionExpression");
        Element ifSubStyle = new Element("style");
        ifConditionExpression.setContent((Content)new CDATA("$V{REPORT_COUNT} %2 == 0"));
        ifConditionalStyle.addContent((Content)ifConditionExpression);
        ifSubStyle.setAttribute("mode", "Opaque");
        ifSubStyle.setAttribute("backcolor", (String)oddEvenAttributes.get("backcolorEven"));
        ifConditionalStyle.addContent((Content)ifSubStyle);
        style.addContent((Content)ifConditionalStyle);
        Element elseConditionalStyle = new Element("conditionalStyle");
        Element elseConditionExpression = new Element("conditionExpression");
        Element elseSubStyle = new Element("style");
        elseConditionExpression.setContent((Content)new CDATA("$V{REPORT_COUNT} %2 != 0"));
        elseConditionalStyle.addContent((Content)elseConditionExpression);
        elseSubStyle.setAttribute("mode", "Opaque");
        elseSubStyle.setAttribute("backcolor", (String)oddEvenAttributes.get("backcolorOdd"));
        elseConditionalStyle.addContent((Content)elseSubStyle);
        style.addContent((Content)elseConditionalStyle);
    }

    private void checkBorderExpression(String widthValue, String colorValue, String styleValue, Map<String, String> attributes, Element element) {
        if (attributes.containsKey(widthValue)) {
            element.setAttribute("lineWidth", attributes.get(widthValue));
        } else {
            element.setAttribute("lineWidth", "0");
        }
        if (attributes.containsKey(colorValue)) {
            element.setAttribute("lineColor", attributes.get(colorValue));
        } else {
            element.setAttribute("lineColor", "#000000");
        }
        if (attributes.containsKey(styleValue)) {
            element.setAttribute("lineStyle", attributes.get(styleValue));
        } else {
            element.setAttribute("lineStyle", "Solid");
        }
    }

    private void checkAndFillBoxElement(Element style, Element box, Element topPen, Element leftPen, Element bottomPen, Element rightPen, Map<String, String> styleValues) {
        this.checkBorderExpression(BOX_TOP, "color", "style", styleValues, topPen);
        this.checkBorderExpression(BOX_LEFT, "color", "style", styleValues, leftPen);
        this.checkBorderExpression(BOX_BOTTOM, "color", "style", styleValues, bottomPen);
        this.checkBorderExpression(BOX_RIGHT, "color", "style", styleValues, rightPen);
        box.addContent((Content)topPen);
        box.addContent((Content)leftPen);
        box.addContent((Content)bottomPen);
        box.addContent((Content)rightPen);
        style.addContent((Content)box);
    }
}

