/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.parsing.elements;

import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.sjrxml.IConstantsAttributeNames;
import org.eclnt.ccee.sjrxml.parsing.JRXMLContext;
import org.eclnt.ccee.sjrxml.parsing.ParserUtil;
import org.eclnt.util.valuemgmt.ValueManager;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExpressionUtil
implements IConstantsAttributeNames {
    public static boolean checkIfStraightExpression(String s) {
        return ExpressionUtil.checkIfStraightExpression(s, true);
    }

    public static boolean checkIfStraightExpression(String s, boolean anyExpression) {
        List<Integer> expressionIndices;
        if (s == null) {
            return false;
        }
        if (anyExpression && s.startsWith("$V{") && s.endsWith("}")) {
            return true;
        }
        return s.startsWith("#{") && (expressionIndices = ExpressionUtil.findExpressionIndicesInText(s, true)).size() == 2 && expressionIndices.get(1).intValue() == s.length();
    }

    public static boolean checkIfStringContainsExpression(String s, boolean anyExpression) {
        if (s == null) {
            return false;
        }
        int index1 = s.indexOf("#{");
        if (index1 < 0 && anyExpression) {
            index1 = s.indexOf("$V{");
        }
        if (index1 < 0) {
            return false;
        }
        int index2 = s.indexOf("}", index1 + 2);
        return index2 >= 0;
    }

    public static boolean checkIfPageExpression(String pageExpression) {
        if (pageExpression == null) {
            return false;
        }
        return pageExpression.startsWith("$V{MASTER_");
    }

    public static boolean checkIfVariableExpression(String variableExpression) {
        if (variableExpression == null) {
            return false;
        }
        return variableExpression.startsWith("$GRIDCALC{");
    }

    public static String isolateVariablesFromExpression(String s) {
        if (s == null) {
            return null;
        }
        if (!ExpressionUtil.checkIfStraightExpression(s, true)) {
            return s;
        }
        if (s.startsWith("$")) {
            return s.replace("$V{", "").replace("}", "");
        }
        if (s.startsWith("#")) {
            return "data." + s.substring(2, s.length() - 1);
        }
        return s;
    }

    public static Content convertJRXMLAttributValueIntoExpressionJRXML(JRXMLContext context, String value) {
        if (!ExpressionUtil.checkIfStraightExpression(value)) {
            return new CDATA("\"" + value + "\"");
        }
        String expression = ExpressionUtil.parseAndBuildExpression(context, value);
        return new CDATA(expression);
    }

    public static String parseAndBuildExpression(JRXMLContext context, String textValue) {
        if (ExpressionUtil.checkIfStraightExpression(textValue)) {
            if (textValue.startsWith("#{")) {
                return "((java.util.Map)$F{data}).get(\"" + textValue + "\")";
            }
            return textValue;
        }
        String textExpression = "";
        textValue = ExpressionUtil.isolateVariablesFromExpression(textValue);
        String[] values = ValueManager.tokenize((String)textValue, (String)".");
        for (int i = 0; i < values.length; ++i) {
            if (i == 0) {
                if (context.isInGrid() || context.isInGridCol()) {
                    textExpression = "$F{data}";
                    continue;
                }
                textExpression = "$F{" + values[i] + "}";
                continue;
            }
            if (i > 1) {
                textExpression = "((" + Map.class.getName() + ")" + textExpression + ")";
            }
            String value = "";
            if (values.length > 2) {
                value = values[1] + "." + values[2];
            }
            if (context.getVariables().get(value) != null) {
                if (context.getVariables().get(value).startsWith("$GRIDCALC{") && i == values.length - 1) {
                    textExpression = textExpression + ".get(\"bigdecimal(" + values[i] + ")\")";
                    continue;
                }
                textExpression = textExpression + ".get(\"" + values[i] + "\")";
                continue;
            }
            textExpression = textExpression + ".get(\"" + values[i] + "\")";
        }
        return textExpression;
    }

    public static String parseAndBuildPageExpression(JRXMLContext context, String textValue, Element element, Map<String, String> attributes) {
        String textExpression = "";
        if (ExpressionUtil.checkIfPageExpression(textValue = ExpressionUtil.isolateVariablesFromExpression(textValue))) {
            element.setAttribute(new Attribute("evaluationTime", "Master"));
            textExpression = attributes.get("text");
        }
        return textExpression;
    }

    public static String buildStyledText(Object text, Object fontDef) {
        Font font = ParserUtil.decodeFont(fontDef + "");
        String styledText = "<style";
        if (font != null) {
            Map attributes = ValueManager.decodeComplexValue((String)(fontDef + ""));
            if (attributes.containsKey("family")) {
                styledText = styledText + " fontName='" + (String)attributes.get("family") + "'";
            }
            if (attributes.containsKey("size")) {
                styledText = styledText + " size='" + font.getSize() + "'";
            }
            if (font.isBold()) {
                styledText = styledText + " isBold='true'";
            }
            if (font.isItalic()) {
                styledText = styledText + " isItalic='true'";
            }
        }
        styledText = styledText + ">" + text + "</style>";
        return styledText;
    }

    public static String parseAndBuildStaticTextCombinedWithExpression(JRXMLContext context, String textValue) {
        List<Integer> expressionIndices = ExpressionUtil.findExpressionIndicesInText(textValue, true);
        if (expressionIndices.size() == 0) {
            return textValue;
        }
        StringBuffer result = new StringBuffer();
        int currentIndex = 0;
        for (int i = 0; i < expressionIndices.size(); i += 2) {
            try {
                int indexBegin = expressionIndices.get(i);
                int indexEnd = expressionIndices.get(i + 1);
                if (currentIndex != indexBegin) {
                    result.append("\"" + textValue.substring(currentIndex, indexBegin) + "\"");
                    result.append(" + ");
                }
                String expression = textValue.substring(indexBegin, indexEnd);
                String jrXmlExpression = ExpressionUtil.parseAndBuildExpression(context, expression);
                result.append(jrXmlExpression);
                currentIndex = indexEnd;
                if (currentIndex >= textValue.length()) continue;
                result.append(" + ");
                continue;
            }
            catch (Throwable t) {
                AppLog.L.log(ICCEEConstants.LL_INF, "Wrong constellation of expressions in: " + textValue, t);
            }
        }
        if (currentIndex < textValue.length()) {
            result.append("\"" + textValue.substring(currentIndex) + "\"");
        }
        return result.toString();
    }

    private static List<Integer> findExpressionIndicesInText(String textValue, boolean anyExpression) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int currentExpressionStackLevel = 0;
        for (int i = 0; i < textValue.length(); ++i) {
            char charI = textValue.charAt(i);
            int charIp1 = 32;
            int charIp2 = 32;
            if (i < textValue.length() - 1) {
                charIp1 = textValue.charAt(i + 1);
            }
            if (i < textValue.length() - 2) {
                charIp2 = textValue.charAt(i + 2);
            }
            if (charI == '#' && charIp1 == 123 || anyExpression && charI == '$' && charIp1 == 86 && charIp2 == 123) {
                if (currentExpressionStackLevel == 0) {
                    result.add(i);
                }
                ++currentExpressionStackLevel;
                continue;
            }
            if (charI != '}' || --currentExpressionStackLevel != 0) continue;
            result.add(i + 1);
        }
        return result;
    }

    private static List<Integer> findOpenCloseIndicesInText(String textValue, char opener, char closer) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int currentExpressionStackLevel = 0;
        for (int i = 0; i < textValue.length(); ++i) {
            char charI = textValue.charAt(i);
            if (charI == opener) {
                if (currentExpressionStackLevel == 0) {
                    result.add(i);
                }
                ++currentExpressionStackLevel;
                continue;
            }
            if (charI != closer || --currentExpressionStackLevel != 0) continue;
            result.add(i + 1);
        }
        if (result.size() % 2 != 0) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    public static String applyVariableInGridColContext(JRXMLContext context, String textValue) {
        HashMap<String, String> calculationAttributes = new HashMap<String, String>();
        String calculationReference = StringUtils.substringBetween((String)textValue, (String)",", (String)"}").trim();
        if (context.getVariables().get(calculationReference) == null) {
            context.saveVariableExpression(calculationReference, textValue);
        }
        calculationAttributes.put("calculationReference", calculationReference);
        String calculationType = StringUtils.capitalize((String)StringUtils.substringBetween((String)textValue, (String)"{", (String)",")).trim();
        calculationAttributes.put("calculationType", calculationType);
        if (!context.getGridColTotalAttributes().contains(calculationAttributes)) {
            context.addGridColTotalAttributes(calculationAttributes);
        }
        String variableName = "$V{" + (String)calculationAttributes.get("calculationReference") + "}";
        return variableName;
    }
}

