/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.lang.StringUtils;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.sjrxml.persistence.SJRXMLBuffer;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.VersionXml;

public class SJRXMLPersistence
implements ICCEEConstants {
    private static String m_entryPoint = "ccsjrxmlprocessing/";
    private static SJRXMLPersistence m_instance = null;

    private SJRXMLPersistence() {
    }

    public static SJRXMLPersistence getInstance() {
        if (m_instance == null) {
            m_instance = new SJRXMLPersistence();
        }
        return m_instance;
    }

    private String buildSjrxmlKey(String sjrxmlId) {
        return m_entryPoint + sjrxmlId + "/sjrxml";
    }

    private String buildReportKey(String sjrxmlId) {
        return m_entryPoint + sjrxmlId + "/report";
    }

    public String readPersistedSJRXML(String sjrxmlId) {
        String id = this.buildSjrxmlKey(sjrxmlId);
        String sjrxml = (String)SJRXMLBuffer.getInstance().read(id);
        if (sjrxml == null) {
            try {
                IStreamStore streamStore = StreamStore.getInstance();
                sjrxml = streamStore.readUTF8(id, false);
                if (sjrxml != null) {
                    SJRXMLBuffer.getInstance().save(id, sjrxml);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return sjrxml;
    }

    public JasperReport readPersistedJasperReport(String sjrxmlId) {
        String id = this.buildReportKey(sjrxmlId);
        JasperReport report = (JasperReport)SJRXMLBuffer.getInstance().read(id);
        if (report == null) {
            try {
                IStreamStore streamStore = StreamStore.getInstance();
                String serialoizedReport = streamStore.readUTF8(id, true);
                if (serialoizedReport != null) {
                    report = (JasperReport)this.readObjectFromString(serialoizedReport);
                    SJRXMLBuffer.getInstance().save(id, report);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return report;
    }

    public boolean saveReport(String sjrxmlId, String sjrxml, JasperReport jasperReport) {
        try {
            String sjrxmlKey = this.buildSjrxmlKey(sjrxmlId);
            String reportKey = this.buildReportKey(sjrxmlId);
            IStreamStore streamStore = StreamStore.getInstance();
            SJRXMLBuffer.getInstance().save("ccversion", VersionXml.getVersion());
            String ccVersion = "CCVersion: " + (String)SJRXMLBuffer.getInstance().read("ccversion") + " \r\n";
            sjrxml = ccVersion + sjrxml;
            streamStore.writeUTF8(sjrxmlKey, sjrxml, true);
            SJRXMLBuffer.getInstance().save(sjrxmlKey, sjrxml);
            streamStore.writeUTF8(reportKey, this.writeObjectToString((Serializable)jasperReport), true);
            SJRXMLBuffer.getInstance().save(reportKey, jasperReport);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void clearGenerationBufferIfNeccesary() {
        try {
            IStreamStore streamStore = StreamStore.getInstance();
            for (String streamFolder : streamStore.getContainedFolders(m_entryPoint, true)) {
                for (String stream : streamStore.getContainedStreams(m_entryPoint + streamFolder, true)) {
                    if (!"sjrxml".equals(stream)) continue;
                    String sjrxml = streamStore.readUTF8(m_entryPoint + streamFolder + "/" + stream, true);
                    String ccVersion = StringUtils.substringBefore((String)sjrxml, (String)"\r").substring(11).trim();
                    if (VersionXml.getVersion().equals(ccVersion)) continue;
                    streamStore.removeStream(m_entryPoint + streamFolder + "/" + stream, true);
                    streamStore.removeStream(m_entryPoint + streamFolder + "/report", true);
                }
            }
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problem deleting generation buffer", t);
        }
    }

    private Object readObjectFromString(String s) throws IOException, ClassNotFoundException {
        byte[] data = Base64.getDecoder().decode(s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    private String writeObjectToString(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.close();
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

