/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.sjrxml.preprocess;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.ccee.sjrxml.IConstantsAttributeNames;
import org.eclnt.ccee.sjrxml.IConstantsElementNames;
import org.eclnt.ccee.sjrxml.parsing.elements.ExpressionUtil;
import org.eclnt.ccee.sjrxml.preprocess.PreProcessUtil;
import org.eclnt.ccee.sjrxml.util.AutoCalculationSJRXML;

public class SJRXMLPreProcess
implements IConstantsElementNames,
IConstantsAttributeNames {
    AutoCalculationSJRXML m_autoCalculationJSRXML;
    SimpleXMLElement m_rootOld;
    SimpleXMLElement m_rootNew;

    public SJRXMLPreProcess(SimpleXMLElement rootOld) {
        this.m_rootOld = rootOld;
        this.m_autoCalculationJSRXML = new AutoCalculationSJRXML(this.m_rootOld);
    }

    public SimpleXMLElement preprocess() {
        this.m_rootNew = PreProcessUtil.cloneElement(this.m_rootOld);
        this.preProcessElement(this.m_rootOld, this.m_rootNew);
        return this.m_rootNew;
    }

    private void preProcessElement(SimpleXMLElement rootOld, SimpleXMLElement rootNew) {
        block6: for (SimpleXMLElement childOld : rootOld.getSubElements()) {
            switch (childOld.getName()) {
                case "stack": {
                    SimpleXMLElement frameNew = this.preprocessSTACK(rootOld, childOld);
                    rootNew.addSubElement(frameNew);
                    this.preProcessElement(childOld, frameNew);
                    continue block6;
                }
            }
            SimpleXMLElement childNew = PreProcessUtil.cloneElement(childOld);
            rootNew.addSubElement(childNew);
            this.preProcessElement(childOld, childNew);
        }
    }

    private SimpleXMLElement preprocessSTACK(SimpleXMLElement rootOld, SimpleXMLElement stackOld) {
        SimpleXMLElement sortedStack = this.sortStack(stackOld);
        SimpleXMLElement frameNew = PreProcessUtil.cloneElement(sortedStack);
        frameNew.setName("frame");
        SimpleXMLElement currentElement = null;
        for (int i = 0; i < sortedStack.getSubElements().size() - 1; ++i) {
            currentElement = (SimpleXMLElement)sortedStack.getSubElements().get(i);
            if ((!currentElement.getName().equals("text") || !"true".equals(currentElement.getValue("isRemoveLineWhenBlank"))) && currentElement.getName().equals("text") || currentElement.getValue("rendered") == null && currentElement.getValue("text") == null) continue;
            int nextElementY = this.m_autoCalculationJSRXML.calculatePixelY((SimpleXMLElement)sortedStack.getSubElements().get(i + 1));
            int currentElementHeight = this.m_autoCalculationJSRXML.calculatePixelHeight((SimpleXMLElement)sortedStack.getSubElements().get(i));
            int currentElementY = this.m_autoCalculationJSRXML.calculatePixelY((SimpleXMLElement)sortedStack.getSubElements().get(i));
            int gapPixelHeight = nextElementY - (currentElementY + currentElementHeight);
            if (gapPixelHeight <= 0) continue;
            int gapPixelY = this.m_autoCalculationJSRXML.calculatePixelY((SimpleXMLElement)sortedStack.getSubElements().get(i)) + this.m_autoCalculationJSRXML.calculatePixelHeight((SimpleXMLElement)sortedStack.getSubElements().get(i));
            SimpleXMLElement gap = this.createGapElement(currentElement, gapPixelY, gapPixelHeight);
            frameNew.addSubElement(gap);
        }
        return frameNew;
    }

    private SimpleXMLElement sortStack(SimpleXMLElement stackOld) {
        List result = stackOld.getSubElements();
        result.sort((element1, element2) -> {
            String s1 = element1.getValue("y");
            String s2 = element2.getValue("y");
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareTo(s2);
        });
        SimpleXMLElement sortedStack = PreProcessUtil.cloneElement(stackOld);
        ArrayList<SimpleXMLElement> stacks = new ArrayList<SimpleXMLElement>();
        for (SimpleXMLElement child : result) {
            if ("stack".equals(child.getName())) {
                stacks.add(child);
                continue;
            }
            sortedStack.addSubElement(child);
        }
        for (SimpleXMLElement childStack : stacks) {
            sortedStack.addSubElement(childStack);
        }
        return sortedStack;
    }

    private SimpleXMLElement createGapElement(SimpleXMLElement refElement, int y, int height) {
        SimpleXMLElement gap = new SimpleXMLElement("frame");
        gap.setValue("isRemoveLineWhenBlank", "true");
        gap.setValue("height", "" + height);
        gap.setValue("y", "" + y);
        gap.setValue("width", "1");
        gap.setValue("x", "0");
        String refText = refElement.getValue("text");
        String refRendered = refElement.getValue("rendered");
        if (refRendered != null) {
            gap.setValue("rendered", refRendered);
        } else if (ExpressionUtil.checkIfStraightExpression(refText, false)) {
            String refVariable = refText.substring(2, refText.length() - 1);
            int indexDot = refVariable.lastIndexOf(46);
            if (indexDot < 0) {
                gap.setValue("rendered", "#{isNotEmpty(" + refVariable + ")}");
            } else {
                gap.setValue("rendered", "#{" + refVariable.substring(0, indexDot) + ".isNotEmpty(" + refVariable.substring(indexDot + 1) + ")}");
            }
        }
        return gap;
    }
}

